/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.javascript.json.JSON;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import swingjs.api.JSUtilI;

public class Platform {
    private static boolean isJS = false;
    private static Boolean isNoJSMac = null;
    private static Boolean isNoJSWin = null;
    private static Boolean isMac = null;
    private static Boolean isWin = null;
    private static Boolean isLinux = null;
    private static Boolean isHeadless = null;
    private static final int CONSOLEWIDTH;
    private static final String CONSOLEWIDTHPROPERTY = "CONSOLEWIDTH";
    private static JSUtilI jsutil;
    public static int SHORTCUT_KEY_MASK;
    public static final int TIME_RESET = 0;
    public static final int TIME_MARK = 1;
    public static final int TIME_SET = 2;
    public static final int TIME_GET = 3;
    public static long time;
    public static long mark;
    public static long set;
    public static long duration;

    public static boolean isMac() {
        return isMac == null ? (isMac = Boolean.valueOf(System.getProperty("os.name").indexOf("Mac") >= 0)) : isMac;
    }

    public static boolean isWin() {
        return isWin == null ? (isWin = Boolean.valueOf(System.getProperty("os.name").indexOf("Win") >= 0)) : isWin;
    }

    public static boolean isLinux() {
        return isLinux == null ? (isLinux = Boolean.valueOf(System.getProperty("os.name").indexOf("Linux") >= 0)) : isLinux;
    }

    public static boolean isJS() {
        return isJS;
    }

    public static boolean isAMacAndNotJS() {
        return isNoJSMac == null ? (isNoJSMac = Boolean.valueOf(!isJS && Platform.isMac())) : isNoJSMac;
    }

    public static boolean isWindowsAndNotJS() {
        return isNoJSWin == null ? (isNoJSWin = Boolean.valueOf(!isJS && Platform.isWin())) : isNoJSWin;
    }

    public static boolean isHeadless() {
        if (isHeadless == null) {
            isHeadless = "true".equals(System.getProperty("java.awt.headless"));
        }
        return isHeadless;
    }

    public static <T> PlatformDependentValue<T> forArch(T defaultValue) {
        return new PlatformDependentValue<T>(defaultValue);
    }

    public static int getMaxCommandLineLength() {
        return 2046;
    }

    public static String escapeBackslashes(String s) {
        return s == null ? null : s.replace("\\", "\\\\");
    }

    public static boolean isControlDown(MouseEvent e) {
        return Platform.isControlDown(e, Platform.isMac());
    }

    protected static boolean isControlDown(MouseEvent e, boolean aMac) {
        return aMac ? !e.isPopupTrigger() && (SHORTCUT_KEY_MASK & e.getModifiersEx()) != 0 : e.isControlDown();
    }

    public static boolean isWinRightButton(MouseEvent e) {
        return Platform.isWin() && SwingUtilities.isRightMouseButton(e);
    }

    public static boolean isWinMiddleButton(MouseEvent e) {
        return Platform.isWin() && SwingUtilities.isMiddleMouseButton(e);
    }

    public static boolean allowMnemonics() {
        return !Platform.isMac();
    }

    public static void timeCheck(String msg, int mode) {
        long t = System.currentTimeMillis();
        switch (mode) {
            case 0: {
                time = mark = t;
                duration = 0L;
                if (msg == null) break;
                Console.errPrintln("Platform: timer reset\t\t\t" + msg);
                break;
            }
            case 1: {
                if (set > 0L) {
                    duration += t - set;
                    break;
                }
                if (time == 0L) {
                    time = mark = t;
                }
                if (msg != null) {
                    Console.errPrintln("Platform: timer mark\t" + (float)(t - time) / 1000.0f + "\t" + (float)(t - mark) / 1000.0f + "\t" + msg);
                }
                mark = t;
                break;
            }
            case 2: {
                set = t;
                break;
            }
            case 3: {
                if (msg != null) {
                    Console.errPrintln("Platform: timer dur\t" + (float)(t - time) / 1000.0f + "\t" + (float)duration / 1000.0f + "\t" + msg);
                }
                set = 0L;
            }
        }
    }

    public static void cacheFileData(String path, Object data) {
        if (isJS && data != null) {
            jsutil.cachePathData(path, data);
        }
    }

    public static void cacheFileData(File file) {
        byte[] data;
        if (isJS && (data = Platform.getFileBytes(file)) != null) {
            Platform.cacheFileData(file.toString(), data);
        }
    }

    public static byte[] getFileBytes(File f) {
        return isJS && f != null ? jsutil.getBytes(f) : null;
    }

    public static byte[] getFileAsBytes(String fileStr) {
        if (isJS && fileStr != null) {
            byte[] bytes = (byte[])jsutil.getFile(fileStr, false);
            Platform.cacheFileData(fileStr, bytes);
            return bytes;
        }
        return null;
    }

    public static String getFileAsString(String url) {
        if (isJS && url != null) {
            String ret = (String)jsutil.getFile(url, true);
            Platform.cacheFileData(url, ret);
            return ret;
        }
        return null;
    }

    public static boolean setFileBytes(File f, String urlstring) {
        if (isJS && f != null && urlstring != null) {
            byte[] bytes = Platform.getFileAsBytes(urlstring);
            jsutil.setFileBytes(f, bytes);
            return true;
        }
        return false;
    }

    public static void addJ2SBinaryType(String ext) {
        if (isJS) {
            jsutil.addBinaryFileType(ext);
        }
    }

    public static String encodeURI(String value) {
        return value;
    }

    public static boolean openURL(String url) throws IOException {
        return isJS;
    }

    public static String getUniqueAppletID() {
        return isJS ? (String)jsutil.getAppletAttribute("_uniqueId") : null;
    }

    public static void readInfoProperties(String prefix, Properties p) {
        if (!isJS) {
            return;
        }
        String id = Platform.getUniqueAppletID();
        String key = "";
        String value = "";
        Console.outPrintln("Platform id=" + id + " reading Info." + key + " = " + value);
        p.put(id + "_" + key, value);
    }

    public static void setAjaxJSON(URL url) {
        if (isJS) {
            JSON.setAjax(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseJSON(InputStream response) throws IOException, ParseException {
        if (isJS) {
            return JSON.parse(response);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(response, "UTF-8"));
            Object object = new JSONParser().parse(br);
            return object;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Object parseJSON(String json) throws ParseException {
        return isJS ? JSON.parse(json) : new JSONParser().parse(json);
    }

    public static Object parseJSON(Reader r) throws IOException, ParseException {
        if (r == null) {
            return null;
        }
        if (!isJS) {
            return new JSONParser().parse(r);
        }
        if (r instanceof FileReader) {
            throw new IOException("StringJS does not support FileReader parsing for JSON -- but it could...");
        }
        return JSON.parse(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamToFile(InputStream is, File outFile) throws IOException {
        if (isJS) {
            jsutil.setFileBytes(outFile, is);
            return;
        }
        try (FileOutputStream fio = new FileOutputStream(outFile);){
            int l;
            byte[] bb = new byte[32768];
            while ((l = is.read(bb)) > 0) {
                fio.write(bb, 0, l);
            }
        }
    }

    public static void addJ2SDirectDatabaseCall(String domain) {
        if (isJS) {
            jsutil.addDirectDatabaseCall(domain);
            Console.outPrintln("Platform adding known access-control-allow-origin * for domain " + domain);
        }
    }

    public static void getURLCommandArguments() {
    }

    public static boolean pathEquals(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        String p1 = path1.replace('\\', '/');
        String p2 = path2.replace('\\', '/');
        return p1.equals(p2);
    }

    public static int consoleWidth() {
        return CONSOLEWIDTH;
    }

    public static Dimension getDimIfEmbedded(Component frame, int defaultWidth, int defaultHeight) {
        Dimension d = null;
        if (isJS) {
            d = (Dimension)Platform.getEmbeddedAttribute(frame, "dim");
        }
        return d == null && defaultWidth >= 0 ? new Dimension(defaultWidth, defaultHeight) : d;
    }

    public static Regex newRegex(String regex) {
        return Platform.newRegex(regex, null);
    }

    public static Regex newRegex(String searchString, String replaceString) {
        Platform.ensureRegex();
        return replaceString == null ? new Regex(searchString) : new Regex(searchString, replaceString);
    }

    public static Regex newRegexPerl(String code) {
        Platform.ensureRegex();
        return Regex.perlCode(code);
    }

    public static void startJavaLogging() {
        Platform.logClass("java.awt.EventDispatchThread", "java.awt.EventQueue", "java.awt.Component", "java.awt.focus.Component", "java.awt.event.Component", "java.awt.focus.DefaultKeyboardFocusManager");
    }

    public static void logClass(String ... classNames) {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.ALL);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        int i = classNames.length;
        while (--i >= 0) {
            Logger logger = Logger.getLogger(classNames[i]);
            logger.setLevel(Level.ALL);
            logger.addHandler(consoleHandler);
        }
    }

    public static void loadStaticResource(String resourcePath, String className) {
        if (isJS) {
            jsutil.loadResourceIfClassUnknown(resourcePath, className);
        }
    }

    public static void ensureRegex() {
        if (isJS) {
            Platform.loadStaticResource("core/core_stevesoft.z.js", "com.stevesoft.pat.Regex");
        }
    }

    public static void setAppClass(Object j) {
        if (isJS) {
            jsutil.setAppClass(j);
        }
    }

    public static Object getEmbeddedAttribute(Component frame, String type) {
        return isJS ? jsutil.getEmbeddedAttribute(frame, type) : null;
    }

    public static void stackTrace() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static URL getDocumentBase() {
        return isJS ? jsutil.getDocumentBase() : null;
    }

    public static URL getCodeBase() {
        return isJS ? jsutil.getCodeBase() : null;
    }

    public static String getUserPath(String subpath) {
        char sep = File.separatorChar;
        return System.getProperty("user.home") + sep + subpath.replace('/', sep);
    }

    public static boolean isFileOlderThanThreshold(File file, int noOfDays) {
        if (isJS) {
            return false;
        }
        Path filePath = file.toPath();
        int diffInDays = 0;
        try {
            BasicFileAttributes attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            diffInDays = (int)((new Date().getTime() - attr.lastModifiedTime().toMillis()) / 86400000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return noOfDays <= diffInDays;
    }

    public static int getLeadingIntegerValue(String input, int failValue) {
        if (input == null) {
            return failValue;
        }
        if (isJS) {
            int val = 0;
            return val == val + 0 ? val : failValue;
        }
        String[] parts = input.split("(?=\\D)(?<=\\d)");
        if (parts != null && parts.length > 0 && parts[0].matches("[0-9]+")) {
            return Integer.valueOf(parts[0]);
        }
        return failValue;
    }

    public static Map<String, Object> getAppletInfoAsMap() {
        return isJS ? jsutil.getAppletInfoAsMap() : null;
    }

    public static String getAppID(String frameType) {
        String id = Jalview.getInstance().j2sAppletID;
        if (id == null) {
            id = isJS ? (String)jsutil.getAppletAttribute("_id") : "jalview";
            Jalview.getInstance().j2sAppletID = id;
        }
        return id + (String)(frameType == null ? "" : "-" + frameType);
    }

    public static Locale getLocaleOrNone(Locale loc) {
        return isJS && loc.getLanguage() == "en" ? new Locale("") : loc;
    }

    /*
     * Loose catch block
     */
    public static void download(String urlstring, String outfile) throws IOException {
        block35: {
            Path temp;
            block34: {
                InputStream is;
                block32: {
                    block33: {
                        temp = null;
                        is = new URL(urlstring).openStream();
                        if (!isJS) break block32;
                        Platform.streamToFile(is, new File(outfile));
                        if (is == null) break block33;
                        is.close();
                    }
                    try {
                        if (temp != null) {
                            Files.deleteIfExists(temp);
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Exception while deleting download temp file: " + e.getMessage());
                    }
                    return;
                }
                temp = Files.createTempFile(".jalview_", ".tmp", new FileAttribute[0]);
                try (FileOutputStream fos = new FileOutputStream(temp.toString());
                     ReadableByteChannel rbc = Channels.newChannel(is);){
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    Files.copy(temp, Paths.get(outfile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    break block34;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            try {
                if (temp != null) {
                    Files.deleteIfExists(temp);
                }
                break block35;
            }
            catch (IOException e) {
                System.out.println("Exception while deleting download temp file: " + e.getMessage());
            }
            break block35;
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        if (temp != null) {
                            Files.deleteIfExists(temp);
                        }
                    }
                    catch (IOException e2) {
                        System.out.println("Exception while deleting download temp file: " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    static {
        SHORTCUT_KEY_MASK = Platform.isMac() ? 256 : 128;
        int cw = 80;
        if (System.getProperty(CONSOLEWIDTHPROPERTY) != null && System.getProperty(CONSOLEWIDTHPROPERTY).length() > 0) {
            try {
                cw = Integer.parseInt(System.getProperty(CONSOLEWIDTHPROPERTY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        CONSOLEWIDTH = cw;
        if (isJS) {
            try {
                jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (!GraphicsEnvironment.isHeadless()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Method method = null;
            try {
                method = tk.getClass().getMethod("getMenuShortcutKeyMaskEx", new Class[0]);
            }
            catch (Exception e) {
                System.err.println("Could not find Toolkit method getMenuShortcutKeyMaskEx. Trying getMenuShortcutKeyMask.");
            }
            if (method == null) {
                try {
                    method = tk.getClass().getMethod("getMenuShortcutKeyMask", new Class[0]);
                }
                catch (Exception e) {
                    System.err.println("Could not find Toolkit method getMenuShortcutKeyMaskEx or getMenuShortcutKeyMask.");
                    e.printStackTrace();
                }
            }
            if (method != null) {
                try {
                    method.setAccessible(true);
                    SHORTCUT_KEY_MASK = (Integer)method.invoke((Object)tk, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (SHORTCUT_KEY_MASK <= 15) {
                SHORTCUT_KEY_MASK <<= 6;
            }
        }
    }

    public static class PlatformDependentValue<T> {
        private T defaultValue = null;
        private T macValue = null;
        private T winValue = null;
        private T linuxValue = null;
        private T jsValue = null;
        private T headlessValue = null;

        private PlatformDependentValue(T value) {
            Objects.requireNonNull(value);
            this.defaultValue = value;
        }

        public PlatformDependentValue<T> forMac(T value) {
            Objects.requireNonNull(value);
            this.macValue = value;
            return this;
        }

        public PlatformDependentValue<T> forWin(T value) {
            Objects.requireNonNull(value);
            this.winValue = value;
            return this;
        }

        public PlatformDependentValue<T> forLinux(T value) {
            Objects.requireNonNull(value);
            this.linuxValue = value;
            return this;
        }

        public PlatformDependentValue<T> forJS(T value) {
            Objects.requireNonNull(value);
            this.jsValue = value;
            return this;
        }

        public PlatformDependentValue<T> forHeadless(T value) {
            Objects.requireNonNull(value);
            this.headlessValue = value;
            return this;
        }

        public T value() {
            if (this.headlessValue != null && Platform.isHeadless()) {
                return this.headlessValue;
            }
            if (this.macValue != null && Platform.isMac()) {
                return this.macValue;
            }
            if (this.winValue != null && Platform.isWin()) {
                return this.winValue;
            }
            if (this.linuxValue != null && Platform.isLinux()) {
                return this.linuxValue;
            }
            if (this.jsValue != null && isJS) {
                return this.jsValue;
            }
            return this.defaultValue;
        }
    }
}

