/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.log.JLoggerI;
import jalview.util.Platform;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4j {
    public static final String SIMPLE_PATTERN = "%level - %m%n";
    public static final String TIME_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %level - %m%n";
    private static boolean init = false;

    public static boolean isInit() {
        return init;
    }

    public static Level log4jLevel(JLoggerI.LogLevel loglevel) {
        return Level.toLevel((String)loglevel.toString());
    }

    public static void init(JLoggerI.LogLevel myLevel) {
        Log4j.init(Log4j.log4jLevel(myLevel));
    }

    public static void init(JLoggerI.LogLevel myLevel, File logfile) {
        Log4j.init(Log4j.log4jLevel(myLevel), logfile);
    }

    public static void init(Level myLevel) {
        Log4j.init(myLevel, null);
    }

    public static void init(Level myLevel, File logfile) {
        if (init) {
            return;
        }
        try {
            ConfigurationBuilder<BuiltConfiguration> configBuilder = Log4j.getConfigurationBuilder();
            configBuilder.setStatusLevel(Level.INFO);
            String consoleLoggerName = "STDERR";
            AppenderComponentBuilder appenderBuilder = configBuilder.newAppender(consoleLoggerName, "Console");
            appenderBuilder.addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_ERR);
            appenderBuilder.add(Log4j.getSimpleLayoutBuilder());
            appenderBuilder.add(Log4j.getThresholdFilterBuilder());
            configBuilder.add(appenderBuilder);
            RootLoggerComponentBuilder root = configBuilder.newRootLogger(myLevel);
            root.add(configBuilder.newAppenderRef(consoleLoggerName));
            if (logfile != null) {
                String fileLoggerName = "LOGFILE";
                appenderBuilder = (AppenderComponentBuilder)configBuilder.newAppender(fileLoggerName, "File").addAttribute("fileName", logfile.getAbsolutePath());
                appenderBuilder.add(Log4j.getTimeLayoutBuilder());
                appenderBuilder.add(Log4j.getThresholdFilterBuilder());
                configBuilder.add(appenderBuilder);
                root.add(configBuilder.newAppenderRef(fileLoggerName));
            }
            configBuilder.add(root);
            Configurator.initialize((Configuration)((Configuration)configBuilder.build()));
            init = true;
        }
        catch (Exception e) {
            Console.errPrintln("Problems initializing the log4j system\n");
            e.printStackTrace(System.err);
        }
    }

    public static Logger getLogger(String name) {
        return Log4j.getLogger(name, Level.INFO);
    }

    public static Logger getLogger(String name, JLoggerI.LogLevel loglevel) {
        return Log4j.getLogger(name, Log4j.log4jLevel(loglevel));
    }

    public static Logger getLogger(String name, Level level) {
        Logger logger = LogManager.getLogger((String)name);
        Log4j.setLevel(logger, level);
        return logger;
    }

    public static ConfigurationBuilder<BuiltConfiguration> getConfigurationBuilder() {
        return ConfigurationFactory.newConfigurationBuilder();
    }

    public static Layout getTimeLayout() {
        return PatternLayout.newBuilder().withPattern(TIME_PATTERN).build();
    }

    public static Layout getSimpleLayout() {
        return PatternLayout.newBuilder().withPattern(SIMPLE_PATTERN).build();
    }

    public static LayoutComponentBuilder getTimeLayoutBuilder() {
        return (LayoutComponentBuilder)Log4j.getConfigurationBuilder().newLayout("PatternLayout").addAttribute("pattern", TIME_PATTERN);
    }

    public static LayoutComponentBuilder getSimpleLayoutBuilder() {
        return (LayoutComponentBuilder)Log4j.getConfigurationBuilder().newLayout("PatternLayout").addAttribute("pattern", SIMPLE_PATTERN);
    }

    public static Filter getThresholdFilter(Level level) {
        return ThresholdFilter.createFilter((Level)level, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
    }

    public static FilterComponentBuilder getThresholdFilterBuilder() {
        return Log4j.getConfigurationBuilder().newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL);
    }

    public static void setLevel(Logger logger, JLoggerI.LogLevel loglevel) {
        Log4j.setLevel(logger, Log4j.log4jLevel(loglevel));
    }

    public static void setLevel(Logger logger, Level level) {
        if (!Platform.isJS()) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            Map appenders = config.getAppenders();
            Appender jappender = config.getAppender("JalviewAppender");
            context.updateLoggers();
        }
    }

    public static void setRootLevel(JLoggerI.LogLevel loglevel) {
        Log4j.setRootLevel(Log4j.log4jLevel(loglevel));
    }

    public static void setRootLevel(Level level) {
        Log4j.setLevel(LogManager.getRootLogger(), level);
    }

    public static Appender getAppender(String name) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        Map appenders = config.getAppenders();
        return (Appender)appenders.get(name);
    }

    public static void addAppender(Logger logger, Logger logger2, String name2) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig logger2Config = config.getLoggerConfig(logger2.getName());
        Map logger2AppendersMap = logger2Config.getAppenders();
        Appender appender = (Appender)logger2AppendersMap.get(name2);
        Log4j.addAppender(logger, appender);
        context.updateLoggers();
    }

    public static void addAppender(Logger logger, Appender appender) {
        if (appender == null) {
            return;
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (loggerConfig == null) {
            return;
        }
        Level level = loggerConfig.getLevel();
        config.addAppender(appender);
        loggerConfig.addAppender(appender, null, null);
        context.updateLoggers();
    }

    public static void addAppenderToRootLogger(Appender appender) {
        Log4j.addAppender(LogManager.getRootLogger(), appender);
    }
}

