/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.QuickSort;
import java.util.Hashtable;

public class GroupUrlLink {
    private String url_prefix;
    private String target;
    private String label;
    private String[] url_suffix;
    private String[] separators;
    private String[] regexReplace;
    private String invalidMessage = null;
    private static String[] tokens;
    private int[] segs;
    private String[] mtch;
    public static final int SEQUENCEIDS = 1;
    public static final int SEQUENCES = 2;
    public static final int DATASETID = 4;

    public GroupUrlLink(String link) {
        int pass;
        int i;
        int i2;
        int sep = link.indexOf("|");
        this.segs = new int[tokens.length];
        int ntoks = 0;
        for (i2 = 0; i2 < this.segs.length; ++i2) {
            this.segs[i2] = link.indexOf("$" + tokens[i2]);
            if (this.segs[i2] <= -1) continue;
            ++ntoks;
        }
        if (ntoks == 0) {
            this.invalidMessage = "Group URL string must contain at least one of ";
            for (i2 = 0; i2 < this.segs.length; ++i2) {
                this.invalidMessage = this.invalidMessage + " '$" + tokens[i2] + "[=/regex=/]$'";
            }
            return;
        }
        int[] ptok = new int[ntoks + 1];
        Object[] tmtch = new String[ntoks + 1];
        this.mtch = new String[ntoks];
        int t = 0;
        for (i = 0; i < this.segs.length; ++i) {
            if (this.segs[i] <= -1) continue;
            ptok[t] = this.segs[i];
            tmtch[t++] = tokens[i];
        }
        ptok[ntoks] = link.length();
        tmtch[ntoks] = "$$$$$$$$$";
        QuickSort.sort(ptok, tmtch);
        for (i = 0; i < ntoks; ++i) {
            this.mtch[i] = tmtch[i];
        }
        int p = sep;
        while ((p = link.indexOf("|", (sep = p) + 1)) > sep && p < ptok[0]) {
        }
        this.label = link.substring(0, sep);
        this.target = this.label.indexOf("|") > -1 ? this.label.substring(0, this.label.indexOf("|")) : (this.label.indexOf(" ") > 2 ? this.label.substring(0, this.label.indexOf(" ")) : this.label);
        this.url_prefix = link.substring(sep + 1, ptok[0]);
        this.url_suffix = new String[this.mtch.length];
        this.regexReplace = new String[this.mtch.length];
        for (pass = 0; pass < this.mtch.length; ++pass) {
            int mlength = 3 + this.mtch[pass].length();
            if (link.indexOf("$" + this.mtch[pass] + "=/") == ptok[pass] && (p = link.indexOf("/=$", ptok[pass] + mlength)) > ptok[pass] + mlength) {
                if (ptok[pass + 1] < p + 3) {
                    this.invalidMessage = "Token regexes cannot contain other regexes (did you terminate the $" + this.mtch[pass] + " regex with a '/=$' ?";
                    return;
                }
                this.url_suffix[pass] = link.substring(p + 3, ptok[pass + 1]);
                this.regexReplace[pass] = link.substring(ptok[pass] + mlength, p);
                try {
                    Regex rg = Regex.perlCode("/" + this.regexReplace[pass] + "/");
                    if (rg != null) continue;
                    this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace[pass] + "'\n";
                }
                catch (Exception e) {
                    this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace[pass] + "'\n";
                }
                continue;
            }
            this.regexReplace[pass] = null;
            p = link.indexOf("$" + this.mtch[pass] + "$");
            if (p == ptok[pass]) {
                this.url_suffix[pass] = link.substring(p + this.mtch[pass].length() + 2, ptok[pass + 1]);
                continue;
            }
            this.invalidMessage = "Warning: invalid regex structure (after '" + this.mtch[0] + "') for URL link : " + link;
        }
        pass = 0;
        this.separators = new String[this.url_suffix.length];
        String suffices = this.url_suffix[this.url_suffix.length - 1];
        String lastsep = ",";
        while ((p = suffices.indexOf(124)) > -1) {
            this.separators[pass] = suffices.substring(p + 1);
            if (pass == 0) {
                this.url_suffix[this.url_suffix.length - 1] = suffices.substring(0, p);
            } else {
                String string = this.separators[pass - 1].substring(0, p);
                this.separators[pass - 1] = string;
                lastsep = string;
            }
            suffices = this.separators[pass];
            ++pass;
        }
        if (pass > 0) {
            lastsep = this.separators[pass - 1];
        }
        while (pass < this.separators.length) {
            this.separators[pass++] = lastsep;
        }
    }

    public String getUrl_suffix() {
        return this.url_suffix[this.url_suffix.length - 1];
    }

    public String getUrl_prefix() {
        return this.url_prefix;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIDRegexReplace() {
        return this._replaceFor(tokens[0]);
    }

    private String _replaceFor(String token) {
        for (int i = 0; i < this.mtch.length; ++i) {
            if (this.segs[i] <= -1 || !this.mtch[i].equals(token)) continue;
            return this.regexReplace[i];
        }
        return null;
    }

    public String getSeqRegexReplace() {
        return this._replaceFor(tokens[1]);
    }

    public String getInvalidMessage() {
        return this.invalidMessage;
    }

    public boolean isValid() {
        return this.invalidMessage == null;
    }

    public Object[] makeUrls(String[] idstrings, String[] seqstrings, String dsstring, boolean onlyIfMatches) throws UrlStringTooLongException {
        Hashtable rstrings = this.replacementArgs(idstrings, seqstrings, dsstring);
        return this.makeUrls(rstrings, onlyIfMatches);
    }

    private Hashtable replacementArgs(String[] idstrings, String[] seqstrings, String dsstring) {
        Hashtable<String, String[]> rstrings = new Hashtable<String, String[]>();
        rstrings.put(tokens[0], idstrings);
        rstrings.put(tokens[1], seqstrings);
        rstrings.put(tokens[2], new String[]{dsstring});
        if (idstrings.length != seqstrings.length) {
            throw new Error(MessageManager.getString("error.idstring_seqstrings_only_one_per_sequence"));
        }
        return rstrings;
    }

    public Object[] makeUrls(Hashtable repstrings, boolean onlyIfMatches) throws UrlStringTooLongException {
        return this.makeUrlsIf(true, repstrings, onlyIfMatches);
    }

    public Object[] makeUrlStubs(String[] ids, String[] seqstr, String string, boolean b) throws UrlStringTooLongException {
        Hashtable rstrings = this.replacementArgs(ids, seqstr, string);
        Object[] stubs = this.makeUrlsIf(false, rstrings, b);
        if (stubs != null) {
            return new Object[]{stubs[0], stubs[1], rstrings, new boolean[]{b}};
        }
        return null;
    }

    public String constructFrom(Object[] stubs) throws UrlStringTooLongException {
        Object[] results = this.makeUrlsIf(true, (Hashtable)stubs[2], ((boolean[])stubs[3])[0]);
        return ((String[])results[3])[0];
    }

    protected Object[] makeUrlsIf(boolean createFullUrl, Hashtable repstrings, boolean onlyIfMatches) throws UrlStringTooLongException {
        int pass = 0;
        String[][] idseq = new String[this.mtch.length][];
        boolean mins = false;
        int maxs = 0;
        for (int i = 0; i < this.mtch.length; ++i) {
            idseq[i] = (String[])repstrings.get(this.mtch[i]);
            if (idseq[i].length >= 1) {
                if (!mins && idseq[i].length == 1) {
                    mins = true;
                }
                if (maxs < 2) {
                    maxs = idseq[i].length;
                    continue;
                }
                if (maxs == idseq[i].length) continue;
                throw new Error(MessageManager.formatMessage("error.cannot_have_mixed_length_replacement_vectors", new String[]{this.mtch[i], Integer.valueOf(idseq[i].length).toString(), Integer.valueOf(maxs).toString()}));
            }
            throw new Error(MessageManager.getString("error.cannot_have_zero_length_vector_replacement_strings"));
        }
        StringBuffer[] matched = new StringBuffer[idseq.length];
        Regex[] rgxs = new Regex[matched.length];
        for (pass = 0; pass < matched.length; ++pass) {
            matched[pass] = new StringBuffer();
            rgxs[pass] = this.regexReplace[pass] != null ? Regex.perlCode("/" + this.regexReplace[pass] + "/") : null;
        }
        int urllength = this.url_prefix.length();
        for (pass = 0; pass < matched.length; ++pass) {
            urllength += this.url_suffix[pass].length();
        }
        boolean[] thismatched = new boolean[maxs];
        int seqsmatched = 0;
        for (int sq = 0; sq < maxs; ++sq) {
            thismatched[sq] = false;
            StringBuffer[] thematches = new StringBuffer[rgxs.length];
            for (pass = 0; pass < rgxs.length; ++pass) {
                thematches[pass] = new StringBuffer();
                if (idseq[pass].length <= sq) continue;
                if (rgxs[pass] != null) {
                    Regex rg = rgxs[pass];
                    int rematchat = 0;
                    while (rg.searchFrom(idseq[pass][sq], rematchat)) {
                        rematchat = rg.matchedTo();
                        int n = sq;
                        thismatched[n] = thismatched[n] | true;
                        if ((urllength += rg.charsMatched()) + 32 > Platform.getMaxCommandLineLength()) {
                            throw new UrlStringTooLongException(urllength);
                        }
                        if (!createFullUrl) continue;
                        int ns = rg.numSubs();
                        if (ns == 0) {
                            thematches[pass].append(rg.stringMatched());
                            continue;
                        }
                        StringBuffer subs = new StringBuffer();
                        int s = 0;
                        while (s <= ns) {
                            if (s + 1 <= ns && rg.matchedTo(s) > -1 && rg.matchedTo(s + 1) > -1 && rg.matchedTo(s + 1) < rg.matchedTo(s)) {
                                int r;
                                StringBuffer rmtch = new StringBuffer();
                                for (r = s + 1; r <= ns && rg.matchedTo(r) <= rg.matchedTo(s); ++r) {
                                    if (rg.matchedFrom(r) <= -1) continue;
                                    rmtch.append(rg.stringMatched(r));
                                }
                                if (rmtch.length() > 0) {
                                    subs.append(rmtch);
                                }
                                s = r;
                                continue;
                            }
                            if (rg.matchedFrom(s) > -1) {
                                subs.append(rg.stringMatched(s));
                            }
                            ++s;
                        }
                        thematches[pass].append(subs);
                    }
                    continue;
                }
                if (onlyIfMatches) continue;
                int n = sq;
                thismatched[n] = thismatched[n] | true;
                urllength += idseq[pass][sq].length();
                if (!createFullUrl) continue;
                thematches[pass] = new StringBuffer(idseq[pass][sq]);
            }
            if (!thismatched[sq]) continue;
            if (createFullUrl) {
                for (pass = 0; pass < matched.length; ++pass) {
                    if (idseq[pass].length > 1 && matched[pass].length() > 0) {
                        matched[pass].append(this.separators[pass]);
                    }
                    matched[pass].append(thematches[pass]);
                }
            }
            ++seqsmatched;
        }
        if (seqsmatched == 0 || createFullUrl && matched[0].length() == 0) {
            return null;
        }
        if (urllength + 32 > Platform.getMaxCommandLineLength()) {
            throw new UrlStringTooLongException(urllength);
        }
        if (!createFullUrl) {
            return new Object[]{new int[]{seqsmatched}, thismatched};
        }
        StringBuffer submiturl = new StringBuffer();
        submiturl.append(this.url_prefix);
        for (pass = 0; pass < matched.length; ++pass) {
            submiturl.append(matched[pass]);
            if (this.url_suffix[pass] == null) continue;
            submiturl.append(this.url_suffix[pass]);
        }
        return new Object[]{new int[]{seqsmatched}, thismatched, matched, new String[]{submiturl.toString()}};
    }

    public int getNumberInvolved(Object[] urlstub) {
        return ((int[])urlstub[0])[0];
    }

    public int getGroupURLType() {
        int r = 0;
        for (int pass = 0; pass < tokens.length; ++pass) {
            for (int i = 0; i < this.mtch.length; ++i) {
                if (!this.mtch[i].equals(tokens[pass])) continue;
                r += 1 << pass;
            }
        }
        return r;
    }

    public String toString() {
        int r;
        StringBuffer result = new StringBuffer();
        result.append(this.label + "|" + this.url_prefix);
        for (r = 0; r < this.url_suffix.length; ++r) {
            result.append("$");
            result.append(this.mtch[r]);
            if (this.regexReplace[r] != null) {
                result.append("=/");
                result.append(this.regexReplace[r]);
                result.append("/=");
            }
            result.append("$");
            result.append(this.url_suffix[r]);
        }
        for (r = 0; r < this.separators.length; ++r) {
            result.append("|");
            result.append(this.separators[r]);
        }
        return result.toString();
    }

    private static void testUrls(GroupUrlLink ul, String[][] idstring, Object[] url) {
        if (url == null) {
            Console.outPrintln("Created NO urls.");
        } else {
            int sq;
            Console.outPrintln("Created a url from " + ((int[])url[0])[0] + "out of " + idstring[0].length + " sequences.");
            Console.outPrintln("Sequences that did not match:");
            for (sq = 0; sq < idstring[0].length; ++sq) {
                if (((boolean[])url[1])[sq]) continue;
                Console.outPrintln("Seq " + sq + ": " + idstring[0][sq] + "\t: " + idstring[1][sq]);
            }
            Console.outPrintln("Sequences that DID match:");
            for (sq = 0; sq < idstring[0].length; ++sq) {
                if (!((boolean[])url[1])[sq]) continue;
                Console.outPrintln("Seq " + sq + ": " + idstring[0][sq] + "\t: " + idstring[1][sq]);
            }
            Console.outPrintln("The generated URL:");
            Console.outPrintln(((String[])url[3])[0]);
        }
    }

    public static void main(String[] argv) {
        String[] links = new String[]{"EnVision2|IDS|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Enfin%20Default%20Workflow&datasetName=linkInDatasetFromJalview&input=$SEQUENCEIDS$&inputType=0|,", "EnVision2|Seqs|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Enfin%20Default%20Workflow&datasetName=linkInDatasetFromJalview&input=$SEQUENCES$&inputType=1|,", "EnVision2|IDS|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Enfin%20Default%20Workflow&datasetName=$DATASETID$&input=$SEQUENCEIDS$&inputType=0|,", "EnVision2|Seqs|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Enfin%20Default%20Workflow&datasetName=$DATASETID$&input=$SEQUENCES$&inputType=1|,", "EnVision2|IDS|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=$SEQUENCEIDS$&datasetName=linkInDatasetFromJalview&input=$SEQUENCEIDS$&inputType=0|,", "EnVision2|Seqs|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=$SEQUENCEIDS$&datasetName=$DATASETID$&input=$SEQUENCES$&inputType=1|,", "EnVision2 Seqs|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Default&datasetName=JalviewSeqs$DATASETID$&input=$SEQUENCES=/([a-zA-Z]+)/=$&inputType=1|,", "EnVision2 Seqs|http://www.ebi.ac.uk/enfin-srv/envision2/pages/linkin.jsf?workflow=Default&datasetName=JalviewSeqs$DATASETID$&input=$SEQUENCES=/[A-Za-z]+/=$&inputType=1|,"};
        SequenceI[] seqs = new SequenceI[]{new Sequence("StupidLabel:gi|9234|pdb|102L|A", "asdiasdpasdpadpwpadasdpaspdw")};
        String[][] seqsandids = GroupUrlLink.formStrings(seqs);
        for (int i = 0; i < links.length; ++i) {
            GroupUrlLink ul = new GroupUrlLink(links[i]);
            if (ul.isValid()) {
                Object[] urls;
                Console.outPrintln("\n\n\n");
                Console.outPrintln("Link " + i + " " + links[i] + " : " + ul.toString());
                Console.outPrintln(" pref : " + ul.getUrl_prefix());
                Console.outPrintln(" IdReplace : " + ul.getIDRegexReplace());
                Console.outPrintln(" SeqReplace : " + ul.getSeqRegexReplace());
                Console.outPrintln(" Suffixes : " + ul.getUrl_suffix());
                Console.outPrintln("<insert input id and sequence strings here> Without onlyIfMatches:");
                try {
                    urls = ul.makeUrls(seqsandids[0], seqsandids[1], "mydataset", false);
                    GroupUrlLink.testUrls(ul, seqsandids, urls);
                }
                catch (UrlStringTooLongException ex) {
                    Console.outPrintln("too long exception " + ex);
                }
                Console.outPrintln("<insert input id and sequence strings here> With onlyIfMatches set:");
                try {
                    urls = ul.makeUrls(seqsandids[0], seqsandids[1], "mydataset", true);
                    GroupUrlLink.testUrls(ul, seqsandids, urls);
                }
                catch (UrlStringTooLongException ex) {
                    Console.outPrintln("too long exception " + ex);
                }
                continue;
            }
            Console.errPrintln("Invalid URLLink : " + links[i] + " : " + ul.getInvalidMessage());
        }
    }

    public static String[][] formStrings(SequenceI[] seqs) {
        String[][] idset = new String[2][seqs.length];
        for (int i = 0; i < seqs.length; ++i) {
            idset[0][i] = seqs[i].getName();
            idset[1][i] = seqs[i].getSequenceAsString();
        }
        return idset;
    }

    public void setLabel(String newlabel) {
        this.label = newlabel;
    }

    static {
        if (tokens == null) {
            tokens = new String[]{"SEQUENCEIDS", "SEQUENCES", "DATASETID"};
        }
    }

    public class UrlStringTooLongException
    extends Exception {
        public int urlLength;

        public UrlStringTooLongException(int lng) {
            this.urlLength = lng;
        }

        @Override
        public String toString() {
            return "Generated url is estimated to be too long (" + this.urlLength + ")";
        }
    }
}

