/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.meyfa.sha256.Sha256;

public class DigestUtils {
    static final Charset enc = StandardCharsets.UTF_8;
    private static final int INIT_A = 1732584193;
    private static final int INIT_B = -271733879;
    private static final int INIT_C = -1732584194;
    private static final int INIT_D = 271733878;
    private static final int[] SHIFT_AMTS = new int[]{7, 12, 17, 22, 5, 9, 14, 20, 4, 11, 16, 23, 6, 10, 15, 21};
    private static final int[] TABLE_T = new int[64];

    public static byte[] computeMD5(byte[] message) {
        int messageLenBytes = message.length;
        int numBlocks = (messageLenBytes + 8 >>> 6) + 1;
        int totalLen = numBlocks << 6;
        byte[] paddingBytes = new byte[totalLen - messageLenBytes];
        paddingBytes[0] = -128;
        long messageLenBits = (long)messageLenBytes << 3;
        for (int i = 0; i < 8; ++i) {
            paddingBytes[paddingBytes.length - 8 + i] = (byte)messageLenBits;
            messageLenBits >>>= 8;
        }
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int[] buffer = new int[16];
        for (int i = 0; i < numBlocks; ++i) {
            int index = i << 6;
            int j = 0;
            while (j < 64) {
                buffer[j >>> 2] = (index < messageLenBytes ? message[index] : paddingBytes[index - messageLenBytes]) << 24 | buffer[j >>> 2] >>> 8;
                ++j;
                ++index;
            }
            int originalA = a;
            int originalB = b;
            int originalC = c;
            int originalD = d;
            for (int j2 = 0; j2 < 64; ++j2) {
                int div16 = j2 >>> 4;
                int f = 0;
                int bufferIndex = j2;
                switch (div16) {
                    case 0: {
                        f = b & c | ~b & d;
                        break;
                    }
                    case 1: {
                        f = b & d | c & ~d;
                        bufferIndex = bufferIndex * 5 + 1 & 0xF;
                        break;
                    }
                    case 2: {
                        f = b ^ c ^ d;
                        bufferIndex = bufferIndex * 3 + 5 & 0xF;
                        break;
                    }
                    case 3: {
                        f = c ^ (b | ~d);
                        bufferIndex = bufferIndex * 7 & 0xF;
                    }
                }
                int temp = b + Integer.rotateLeft(a + f + buffer[bufferIndex] + TABLE_T[j2], SHIFT_AMTS[div16 << 2 | j2 & 3]);
                a = d;
                d = c;
                c = b;
                b = temp;
            }
            a += originalA;
            b += originalB;
            c += originalC;
            d += originalD;
        }
        byte[] md5 = new byte[16];
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            int n = i == 0 ? a : (i == 1 ? b : (i == 2 ? c : d));
            for (int j = 0; j < 4; ++j) {
                md5[count++] = (byte)n;
                n >>>= 8;
            }
        }
        return md5;
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(String.format("%02X", b[i] & 0xFF));
        }
        return sb.toString();
    }

    public static byte[] computeSHA256(byte[] message) {
        return Sha256.hash(message);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            DigestUtils.TABLE_T[i] = (int)(4.294967296E9 * Math.abs(Math.sin(i + 1)));
        }
    }
}

