/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.bin.argparser.Arg;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.util.FileUtils;
import jalview.util.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ArgParserUtils {
    public static Set<String> alignmentExtensions = null;
    public static Set<String> annotationsExtensions = null;
    public static Set<String> featuresExtensions = null;
    public static Set<String> treeExtensions = null;
    public static List<Arg> argSet = null;
    public static Map<Arg, Set<String>> argExtensionsMap = null;

    public static void preProcessArgs(List<String> filenames) {
        ArgParserUtils.processFilenames(filenames, true);
    }

    public static Map<String, BaseInfo> processFilenames(List<String> filenames, boolean addArgs) {
        return ArgParserUtils.processFilenames(filenames, addArgs, null);
    }

    public static Map<String, BaseInfo> processFilenames(List<String> filenames, boolean addArgs, List<Object> files) {
        if (alignmentExtensions == null) {
            ArgParserUtils.setValidExtensions();
        }
        HashSet<String> filesSet = new HashSet<String>(filenames);
        HashMap<String, BaseInfo> baseInfoMap = new HashMap<String, BaseInfo>();
        ArrayList<String> filenamesCopy = new ArrayList<String>(filenames);
        for (String filename : filenamesCopy) {
            String ext;
            if (filename == null || (ext = FileUtils.getExtension(filename)) == null || ext.length() <= 0 || !alignmentExtensions.contains(ext)) continue;
            BaseInfo bi = new BaseInfo(filename);
            String base = FileUtils.getBase(filename);
            block1: for (Arg arg : argSet) {
                for (String possibleExt : argExtensionsMap.get((Object)arg)) {
                    String possibleFile = base + possibleExt;
                    if (!filesSet.contains(possibleFile)) continue;
                    bi.putAssociatedFile(arg, possibleFile);
                    int filePos = filenames.indexOf(possibleFile);
                    filenames.remove(possibleFile);
                    if (files == null || files.get(filePos) == null || !possibleFile.equals(files.get(filePos).toString())) continue block1;
                    files.remove(filePos);
                    continue block1;
                }
            }
            baseInfoMap.put(filename, bi);
        }
        if (addArgs) {
            for (String filename : baseInfoMap.keySet()) {
                BaseInfo bi = (BaseInfo)baseInfoMap.get(filename);
                int pos = filenames.indexOf(filename);
                if (bi.associatedFiles != null) {
                    for (Arg a : bi.associatedFiles.keySet()) {
                        String associatedFile = bi.associatedFiles.get((Object)a);
                        if (associatedFile == null) continue;
                        filenames.add(pos + 1, a.argString());
                        filenames.add(pos + 2, HttpUtils.equivalentJalviewUrl(associatedFile));
                    }
                }
                filenames.add(pos, Arg.OPEN.argString());
            }
        }
        return baseInfoMap;
    }

    private static void setValidExtensions() {
        alignmentExtensions = new HashSet<String>();
        FileFormats ffs = FileFormats.getInstance();
        List<String> validFormats = ffs.getReadableFormats();
        for (String fname : validFormats) {
            String[] extensions;
            FileFormatI tff = ffs.forName(fname);
            for (String ext : extensions = tff.getExtensions().split(",")) {
                alignmentExtensions.add(ext.toLowerCase(Locale.ROOT));
            }
        }
        annotationsExtensions = new HashSet<String>();
        for (String ext : Cache.getDefault("ARGPREPROCESSORANNOTATIONSEXTENSIONS", "annotation,annotations,jvannotation,jvannotations,gff,gff2,gff3").split(",")) {
            annotationsExtensions.add(ext);
        }
        featuresExtensions = new HashSet<String>();
        for (String ext : Cache.getDefault("ARGPREPROCESSORFEATURESEXTENSIONS", "feature,features,jvfeature,jvfeatures").split(",")) {
            featuresExtensions.add(ext);
        }
        treeExtensions = new HashSet<String>();
        for (String ext : Cache.getDefault("ARGPREPROCESSORTREEEXTENSIONS", "tree,tre,newick,nwk").split(",")) {
            treeExtensions.add(ext);
        }
        argSet = new ArrayList<Arg>();
        argSet.add(Arg.ANNOTATIONS);
        argSet.add(Arg.FEATURES);
        argSet.add(Arg.TREE);
        argExtensionsMap = new HashMap<Arg, Set<String>>();
        argExtensionsMap.put(Arg.ANNOTATIONS, annotationsExtensions);
        argExtensionsMap.put(Arg.FEATURES, featuresExtensions);
        argExtensionsMap.put(Arg.TREE, treeExtensions);
    }

    public static class BaseInfo {
        String filename;
        Map<Arg, String> associatedFiles = null;

        BaseInfo(String filename) {
            this.filename = filename;
        }

        void putAssociatedFile(Arg a, String file) {
            if (this.associatedFiles == null) {
                this.associatedFiles = new HashMap<Arg, String>();
            }
            this.associatedFiles.put(a, file);
        }

        public Map<Arg, String> getAssociatedFilesMap() {
            return this.associatedFiles;
        }
    }
}

