/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StructureMapping {
    public static final int UNASSIGNED_VALUE = Integer.MIN_VALUE;
    private static final int PDB_RES_NUM_INDEX = 0;
    private static final int PDB_ATOM_NUM_INDEX = 1;
    String mappingDetails;
    SequenceI sequence;
    String pdbfile;
    String pdbid;
    String pdbchain;
    HashMap<Integer, int[]> mapping;
    Mapping seqToPdbMapping = null;

    public StructureMapping(SequenceI seq, String pdbfile, String pdbid, String chain, HashMap<Integer, int[]> mapping, String mappingDetails) {
        this.sequence = seq;
        this.pdbfile = pdbfile;
        this.pdbid = pdbid;
        this.pdbchain = chain;
        this.mapping = mapping;
        this.mappingDetails = mappingDetails;
    }

    public StructureMapping(SequenceI seq, String pdbFile2, String pdbId2, String chain, HashMap<Integer, int[]> mapping2, String mappingOutput, Mapping seqToPdbMapping) {
        this(seq, pdbFile2, pdbId2, chain, mapping2, mappingOutput);
        this.seqToPdbMapping = seqToPdbMapping;
    }

    public SequenceI getSequence() {
        return this.sequence;
    }

    public String getChain() {
        return this.pdbchain;
    }

    public String getPdbId() {
        return this.pdbid;
    }

    public int getAtomNum(int seqpos) {
        int[] resNumAtomMap = this.mapping.get(seqpos);
        if (resNumAtomMap != null) {
            return resNumAtomMap[1];
        }
        return Integer.MIN_VALUE;
    }

    public int getPDBResNum(int seqpos) {
        int[] resNumAtomMap = this.mapping.get(seqpos);
        if (resNumAtomMap != null) {
            return resNumAtomMap[0];
        }
        return Integer.MIN_VALUE;
    }

    public List<int[]> getPDBResNumRanges(int fromSeqPos, int toSeqPos) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int startRes = -1;
        int endRes = -1;
        for (int i = fromSeqPos; i <= toSeqPos; ++i) {
            int resNo = this.getPDBResNum(i);
            if (resNo == Integer.MIN_VALUE) continue;
            if (startRes == -1) {
                startRes = resNo;
                endRes = resNo;
            }
            if (resNo >= startRes && resNo <= endRes) continue;
            if (resNo == startRes - 1) {
                --startRes;
                continue;
            }
            if (resNo == endRes + 1) {
                ++endRes;
                continue;
            }
            result.add(new int[]{startRes, endRes});
            startRes = resNo;
            endRes = resNo;
        }
        if (startRes != -1) {
            result.add(new int[]{startRes, endRes});
        }
        return result;
    }

    public int getSeqPos(int pdbResNum) {
        for (Integer seqPos : this.mapping.keySet()) {
            if (pdbResNum != this.getPDBResNum(seqPos)) continue;
            return seqPos;
        }
        return Integer.MIN_VALUE;
    }

    public AlignmentAnnotation transfer(AlignmentAnnotation ana) {
        AlignmentAnnotation ala_copy = new AlignmentAnnotation(ana);
        SequenceI ds = this.sequence;
        while (ds.getDatasetSequence() != null) {
            ds = ds.getDatasetSequence();
        }
        ala_copy.remap(ds, this.mapping, -1, -1, 0);
        ds.addAlignmentAnnotation(ala_copy);
        if (ds != this.sequence) {
            ala_copy = new AlignmentAnnotation(ala_copy);
            this.sequence.addAlignmentAnnotation(ala_copy);
        }
        return ala_copy;
    }

    public String getMappingDetailsOutput() {
        return this.mappingDetails;
    }

    public HashMap<Integer, int[]> getMapping() {
        return this.mapping;
    }

    public Mapping getSeqToPdbMapping() {
        return this.seqToPdbMapping;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mappingDetails == null ? 0 : this.mappingDetails.hashCode());
        result = 31 * result + (this.pdbchain == null ? 0 : this.pdbchain.hashCode());
        result = 31 * result + (this.pdbfile == null ? 0 : this.pdbfile.hashCode());
        result = 31 * result + (this.pdbid == null ? 0 : this.pdbid.hashCode());
        result = 31 * result + (this.seqToPdbMapping == null ? 0 : this.seqToPdbMapping.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapping other = (StructureMapping)obj;
        if (this.mappingDetails == null ? other.mappingDetails != null : !this.mappingDetails.equals(other.mappingDetails)) {
            return false;
        }
        if (this.pdbchain == null ? other.pdbchain != null : !this.pdbchain.equals(other.pdbchain)) {
            return false;
        }
        if (this.pdbfile == null ? other.pdbfile != null : !this.pdbfile.equals(other.pdbfile)) {
            return false;
        }
        if (this.pdbid == null ? other.pdbid != null : !this.pdbid.equals(other.pdbid)) {
            return false;
        }
        if (this.seqToPdbMapping == null ? other.seqToPdbMapping != null : !this.seqToPdbMapping.equals(other.seqToPdbMapping)) {
            return false;
        }
        return this.sequence == other.sequence;
    }
}

