/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.bin.ApplicationSingletonProvider;
import jalview.datamodel.PDBEntry;
import jalview.util.MessageManager;
import java.util.Locale;

public class StructureImportSettings
implements ApplicationSingletonProvider.ApplicationSingletonI {
    private boolean visibleChainAnnotation = false;
    private static boolean processSecStr = false;
    private boolean externalSecondaryStructure = false;
    private static boolean showSeqFeatures = true;
    private PDBEntry.Type defaultStructureFileFormat = PDBEntry.Type.PDB;
    private StructureParser defaultPDBFileParser = StructureParser.JMOL_PARSER;
    private static TFType temperatureFactorType;

    private StructureImportSettings() {
    }

    private static StructureImportSettings getInstance() {
        return ApplicationSingletonProvider.getInstance(StructureImportSettings.class);
    }

    public static void addSettings(boolean addAlignmentAnnotations, boolean processSecStr, boolean externalSecStr) {
        StructureImportSettings s = StructureImportSettings.getInstance();
        s.visibleChainAnnotation = addAlignmentAnnotations;
        StructureImportSettings.processSecStr = processSecStr;
        s.externalSecondaryStructure = externalSecStr;
        showSeqFeatures = true;
    }

    public static boolean isVisibleChainAnnotation() {
        return StructureImportSettings.getInstance().visibleChainAnnotation;
    }

    public static void setTemperatureFactorType(TFType t) {
        temperatureFactorType = t;
    }

    public static void setVisibleChainAnnotation(boolean visibleChainAnnotation) {
        StructureImportSettings.getInstance().visibleChainAnnotation = visibleChainAnnotation;
    }

    public static boolean isProcessSecondaryStructure() {
        StructureImportSettings.getInstance();
        return processSecStr;
    }

    public static void setProcessSecondaryStructure(boolean processSecondaryStructure) {
        StructureImportSettings.getInstance();
        processSecStr = processSecondaryStructure;
    }

    public static boolean isExternalSecondaryStructure() {
        return StructureImportSettings.getInstance().externalSecondaryStructure;
    }

    public static void setExternalSecondaryStructure(boolean externalSecondaryStructure) {
        StructureImportSettings.getInstance().externalSecondaryStructure = externalSecondaryStructure;
    }

    public static boolean isShowSeqFeatures() {
        StructureImportSettings.getInstance();
        return showSeqFeatures;
    }

    public static void setShowSeqFeatures(boolean showSeqFeatures) {
        StructureImportSettings.getInstance();
        StructureImportSettings.showSeqFeatures = showSeqFeatures;
    }

    public static PDBEntry.Type getDefaultStructureFileFormat() {
        return StructureImportSettings.getInstance().defaultStructureFileFormat;
    }

    public static void setDefaultStructureFileFormat(String defaultStructureFileFormat) {
        StructureImportSettings.getInstance().defaultStructureFileFormat = PDBEntry.Type.valueOf(defaultStructureFileFormat.toUpperCase(Locale.ROOT));
    }

    public static String getDefaultPDBFileParser() {
        return StructureImportSettings.getInstance().defaultPDBFileParser.toString();
    }

    public static void setDefaultPDBFileParser(StructureParser defaultPDBFileParser) {
        StructureImportSettings.getInstance().defaultPDBFileParser = defaultPDBFileParser;
    }

    public static void setDefaultPDBFileParser(String defaultPDBFileParser) {
        StructureImportSettings.getInstance().defaultPDBFileParser = StructureParser.valueOf(defaultPDBFileParser.toUpperCase(Locale.ROOT));
    }

    public static TFType getTemperatureFactorType() {
        return temperatureFactorType;
    }

    public static enum TFType {
        DEFAULT,
        PLDDT,
        QMEANDISCO;


        public String toString() {
            return MessageManager.getString("label.tftype_" + this.name().toLowerCase(Locale.ROOT));
        }
    }

    public static enum StructureParser {
        JMOL_PARSER,
        JALVIEW_PARSER;

    }
}

