/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.schemes.BlossomColourScheme;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.FlowerColourScheme;
import jalview.schemes.HMMMatchScoreColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HmmerGlobalBackground;
import jalview.schemes.HmmerLocalBackground;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.IdColourScheme;
import jalview.schemes.NucleotideAmbiguityColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.OceanColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.RNAHelicesColour;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.SunsetColourScheme;
import jalview.schemes.TCoffeeColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;

public enum JalviewColourScheme {
    Clustal("Clustal", ClustalxColourScheme.class),
    Blosum62("Blosum62", Blosum62ColourScheme.class),
    PID("% Identity", PIDColourScheme.class),
    Zappo("Zappo", ZappoColourScheme.class),
    Taylor("Taylor", TaylorColourScheme.class),
    Flower("gecos-flower", FlowerColourScheme.class),
    Blossom("gecos-blossom", BlossomColourScheme.class),
    Sunset("gecos-sunset", SunsetColourScheme.class),
    Ocean("gecos-ocean", OceanColourScheme.class),
    Hydrophobic("Hydrophobic", HydrophobicColourScheme.class),
    Helix("Helix Propensity", HelixColourScheme.class),
    Strand("Strand Propensity", StrandColourScheme.class),
    Turn("Turn Propensity", TurnColourScheme.class),
    Buried("Buried Index", BuriedColourScheme.class),
    Nucleotide("Nucleotide", NucleotideColourScheme.class),
    NucleotideAmbiguity("Nucleotide Ambiguity", NucleotideAmbiguityColourScheme.class),
    PurinePyrimidine("Purine/Pyrimidine", PurinePyrimidineColourScheme.class),
    RNAHelices("RNA Helices", RNAHelicesColour.class),
    TCoffee("T-Coffee Scores", TCoffeeColourScheme.class),
    IdColour("Sequence ID", IdColourScheme.class),
    HMMERU("HMMER-Uniprot", HmmerGlobalBackground.class),
    HMMERA("HMMER-Alignment", HmmerLocalBackground.class),
    HMMMatchScore("HMM Match Score", HMMMatchScoreColourScheme.class);

    private String name;
    private Class<? extends ColourSchemeI> myClass;

    private JalviewColourScheme(String s, Class<? extends ColourSchemeI> cl) {
        this.name = s;
        this.myClass = cl;
    }

    public Class<? extends ColourSchemeI> getSchemeClass() {
        return this.myClass;
    }

    public String toString() {
        return this.name;
    }
}

