/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import java.awt.Color;

public class ResidueColourFinder {
    public Color getResidueColour(boolean showBoxes, ResidueShaderI shader, SequenceGroup[] allGroups, SequenceI seq, int position, FeatureColourFinder finder) {
        Color col = this.getResidueBoxColour(showBoxes, shader, allGroups, seq, position);
        if (finder != null) {
            col = finder.findFeatureColour(col, seq, position);
        }
        return col;
    }

    protected Color getResidueBoxColour(boolean showBoxes, ResidueShaderI shader, SequenceGroup[] allGroups, SequenceI seq, int i) {
        SequenceGroup currentSequenceGroup = this.getCurrentSequenceGroup(allGroups, i);
        if (currentSequenceGroup != null) {
            if (currentSequenceGroup.getDisplayBoxes()) {
                return this.getBoxColour(currentSequenceGroup.getGroupColourScheme(), seq, i);
            }
        } else if (showBoxes) {
            return this.getBoxColour(shader, seq, i);
        }
        return Color.white;
    }

    public SequenceGroup getCurrentSequenceGroup(SequenceGroup[] allGroups, int res) {
        if (allGroups == null) {
            return null;
        }
        for (int i = 0; i < allGroups.length; ++i) {
            if (allGroups[i].getStartRes() > res || allGroups[i].getEndRes() < res) continue;
            return allGroups[i];
        }
        return null;
    }

    public Color getBoxColour(ResidueShaderI shader, SequenceI seq, int i) {
        Color resBoxColour = Color.white;
        if (shader.getColourScheme() != null) {
            resBoxColour = shader.findColour(seq.getCharAt(i), i, seq);
        }
        return resBoxColour;
    }
}

