/*
 * Decompiled with CFR 0.152.
 */
package jalview.math;

import jalview.ext.android.SparseDoubleArray;
import jalview.math.Matrix;
import jalview.math.MatrixI;

public class SparseMatrix
extends Matrix {
    SparseDoubleArray[] sparseColumns;

    public SparseMatrix(double[][] v) {
        super(v.length, v.length > 0 ? v[0].length : 0);
        this.sparseColumns = new SparseDoubleArray[this.cols];
        for (int col = 0; col < this.cols; ++col) {
            SparseDoubleArray sparseColumn;
            this.sparseColumns[col] = sparseColumn = new SparseDoubleArray();
            for (int row = 0; row < this.rows; ++row) {
                double value = v[row][col];
                if (value == 0.0) continue;
                sparseColumn.put(row, value);
            }
        }
    }

    @Override
    public double getValue(int i, int j) {
        return this.sparseColumns[j].get(i);
    }

    @Override
    public void setValue(int i, int j, double val) {
        if (val == 0.0) {
            this.sparseColumns[j].delete(i);
        } else {
            this.sparseColumns[j].put(i, val);
        }
    }

    @Override
    public double[] getColumn(int i) {
        double[] col = new double[this.height()];
        SparseDoubleArray vals = this.sparseColumns[i];
        for (int nonZero = 0; nonZero < vals.size(); ++nonZero) {
            col[vals.keyAt((int)nonZero)] = vals.valueAt(nonZero);
        }
        return col;
    }

    @Override
    public MatrixI copy() {
        double[][] vals = new double[this.height()][this.width()];
        for (int i = 0; i < this.height(); ++i) {
            vals[i] = this.getRow(i);
        }
        return new SparseMatrix(vals);
    }

    @Override
    public MatrixI transpose() {
        double[][] out = new double[this.cols][this.rows];
        for (int i = 0; i < this.cols; ++i) {
            SparseDoubleArray vals = this.sparseColumns[i];
            for (int nonZero = 0; nonZero < vals.size(); ++nonZero) {
                out[i][vals.keyAt((int)nonZero)] = vals.valueAt(nonZero);
            }
        }
        return new SparseMatrix(out);
    }

    @Override
    public MatrixI preMultiply(MatrixI in) {
        if (in.width() != this.rows) {
            throw new IllegalArgumentException("Can't pre-multiply " + this.rows + " rows by " + in.width() + " columns");
        }
        double[][] tmp = new double[in.height()][this.cols];
        long count = 0L;
        for (int i = 0; i < in.height(); ++i) {
            for (int j = 0; j < this.cols; ++j) {
                SparseDoubleArray vals = this.sparseColumns[j];
                boolean added = false;
                for (int nonZero = 0; nonZero < vals.size(); ++nonZero) {
                    int myRow = vals.keyAt(nonZero);
                    double myValue = vals.valueAt(nonZero);
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + in.getValue(i, myRow) * myValue;
                    added = true;
                }
                if (!added || tmp[i][j] == 0.0) continue;
                ++count;
            }
        }
        if (count * 5L < (long)(in.height() * this.cols)) {
            return new SparseMatrix(tmp);
        }
        return new Matrix(tmp);
    }

    @Override
    protected double divideValue(int i, int j, double divisor) {
        if (divisor == 0.0) {
            return this.getValue(i, j);
        }
        double v = this.sparseColumns[j].divide(i, divisor);
        return v;
    }

    @Override
    protected double addValue(int i, int j, double addend) {
        double v = this.sparseColumns[j].add(i, addend);
        return v;
    }

    public float getFillRatio() {
        long count = 0L;
        for (SparseDoubleArray col : this.sparseColumns) {
            count += (long)col.size();
        }
        return (float)count / (float)(this.height() * this.width());
    }
}

