/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.cache;

import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Cache;
import java.util.Hashtable;
import java.util.LinkedHashSet;

public class AppCache
implements ApplicationSingletonProvider.ApplicationSingletonI {
    public static final String DEFAULT_LIMIT = "99";
    public static final String CACHE_DELIMITER = ";";
    private static final String DEFAULT_LIMIT_KEY = ".DEFAULT_LIMIT";
    private Hashtable<String, LinkedHashSet<String>> cacheItems = new Hashtable();

    public static AppCache getInstance() {
        return ApplicationSingletonProvider.getInstance(AppCache.class);
    }

    private AppCache() {
    }

    public LinkedHashSet<String> getAllCachedItemsFor(String cacheKey) {
        LinkedHashSet<String> foundCache = this.cacheItems.get(cacheKey);
        if (foundCache == null) {
            foundCache = new LinkedHashSet();
            this.cacheItems.put(cacheKey, foundCache);
        }
        return foundCache;
    }

    public void persistCache(String cacheKey) {
        LinkedHashSet<String> foundCacheItems = this.getAllCachedItemsFor(cacheKey);
        StringBuffer delimitedCacheBuf = new StringBuffer();
        for (String cacheItem : foundCacheItems) {
            delimitedCacheBuf.append(CACHE_DELIMITER).append(cacheItem);
        }
        if (delimitedCacheBuf.length() > 0) {
            delimitedCacheBuf.deleteCharAt(0);
        }
        String delimitedCacheString = delimitedCacheBuf.toString();
        Cache.setProperty(cacheKey, delimitedCacheString);
    }

    public void deleteCacheItems(String cacheKey) {
        this.cacheItems.put(cacheKey, new LinkedHashSet());
        this.persistCache(cacheKey);
    }

    public String getCacheLimit(String cacheKey) {
        String uniqueKey = cacheKey + DEFAULT_LIMIT_KEY;
        return Cache.getDefault(uniqueKey, DEFAULT_LIMIT);
    }

    public int updateCacheLimit(String cacheKey, int newUserLimit) {
        String newLimit = String.valueOf(newUserLimit);
        String uniqueKey = cacheKey + DEFAULT_LIMIT_KEY;
        String formerLimit = this.getCacheLimit(cacheKey);
        if (newLimit != null && !newLimit.isEmpty() && !formerLimit.equals(newLimit)) {
            Cache.setProperty(uniqueKey, newLimit);
            formerLimit = newLimit;
        }
        return Integer.valueOf(formerLimit);
    }

    public void putCache(String cacheKey, LinkedHashSet<String> newCacheItems) {
        this.cacheItems.put(cacheKey, newCacheItems);
    }
}

