/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.hmmer.HMMAlign;
import jalview.hmmer.Search;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StockholmFile;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.Option;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class HMMSearch
extends Search {
    boolean realign = false;
    boolean trim = false;
    boolean returnNoOfNewSeqs = false;
    int seqsToReturn = Integer.MAX_VALUE;

    public HMMSearch(AlignFrame af, List<ArgumentI> args) {
        super(af, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HiddenMarkovModel hmm = this.getHmmProfile();
        if (hmm == null) {
            Console.error("Error: no hmm for hmmsearch");
            return;
        }
        SequenceI hmmSeq = hmm.getConsensusSequence();
        long msgId = System.currentTimeMillis();
        this.af.setProgressBar(MessageManager.getString("status.running_search"), msgId);
        try {
            File hmmFile = FileUtils.createTempFile("hmm", ".hmm");
            File hitsAlignmentFile = FileUtils.createTempFile("hitAlignment", ".sto");
            File searchOutputFile = FileUtils.createTempFile("searchOutput", ".sto");
            this.exportHmm(hmm, hmmFile.getAbsoluteFile());
            boolean ran = this.runCommand(searchOutputFile, hitsAlignmentFile, hmmFile);
            if (!ran) {
                JvOptionPane.showInternalMessageDialog(this.af, MessageManager.formatMessage("warn.command_failed", "hmmsearch"));
                return;
            }
            this.importData(hmmSeq, hitsAlignmentFile, hmmFile, searchOutputFile);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.af.setProgressBar("", msgId);
        }
    }

    private boolean runCommand(File searchOutputFile, File hitsAlignmentFile, File hmmFile) throws IOException {
        String command = this.getCommandPath("hmmsearch");
        if (command == null) {
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(command);
        this.buildArguments(args, searchOutputFile, hitsAlignmentFile, hmmFile);
        return this.runCommand(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(SequenceI hmmSeq, File inputAlignmentTemp, File hmmTemp, File searchOutputFile) throws IOException, InterruptedException {
        try (BufferedReader br = new BufferedReader(new FileReader(inputAlignmentTemp));){
            if (br.readLine() == null) {
                JOptionPane.showMessageDialog(this.af, MessageManager.getString("label.no_sequences_found"));
                return;
            }
            StockholmFile file = new StockholmFile(new FileParse(inputAlignmentTemp.getAbsolutePath(), DataSourceType.FILE));
            this.seqs = file.getSeqsAsArray();
            this.readDomainTable(searchOutputFile, false);
            if (this.searchAlignment) {
                this.recoverSequences(this.sequencesHash, this.seqs);
            }
            AlignmentAnnotation modelpos = null;
            AlignmentAnnotation ppcons = null;
            for (AlignmentAnnotation aa : file.getAnnotations()) {
                if (aa.sequenceRef != null) continue;
                if (aa.label.equals("Reference Positions")) {
                    modelpos = aa;
                }
                if (!aa.label.equals("Posterior Probability")) continue;
                ppcons = aa;
            }
            int seqCount = Math.min(this.seqs.length, this.seqsToReturn);
            SequenceI[] hmmAndSeqs = new SequenceI[seqCount + 1];
            hmmAndSeqs[0] = hmmSeq = hmmSeq.deriveSequence();
            System.arraycopy(this.seqs, 0, hmmAndSeqs, 1, seqCount);
            if (modelpos != null) {
                hmmSeq.setSequence(hmmSeq.getDatasetSequence().getSequenceAsString());
                Annotation[] refpos = modelpos.annotations;
                int gc = 0;
                int lcol = 0;
                for (int c = 0; c < refpos.length; ++c) {
                    if (refpos[c] != null && "x".equals(refpos[c].displayCharacter)) {
                        if (gc > 0) {
                            hmmSeq.insertCharAt(lcol + 1, gc, '-');
                        }
                        gc = 0;
                        lcol = c;
                        continue;
                    }
                    ++gc;
                }
            }
            if (this.realign) {
                this.realignResults(hmmAndSeqs);
            } else {
                Alignment al = new Alignment(hmmAndSeqs);
                if (ppcons != null) {
                    al.addAnnotation(ppcons);
                }
                if (modelpos != null) {
                    al.addAnnotation(modelpos);
                }
                AlignFrame alignFrame = new AlignFrame(al, 700, 500);
                String ttl = "hmmSearch of " + this.databaseName + " using " + hmmSeq.getName();
                Desktop.addInternalFrame(alignFrame, ttl, 700, 500);
                if (this.returnNoOfNewSeqs) {
                    int nNew = this.checkForNewSequences();
                    JvOptionPane.showMessageDialog((Component)this.af.alignPanel, nNew + " " + MessageManager.getString("label.new_returned"));
                }
            }
            hmmTemp.delete();
            inputAlignmentTemp.delete();
            searchOutputFile.delete();
        }
    }

    private int checkForNewSequences() {
        int nNew = this.seqs.length;
        block0: for (SequenceI resultSeq : this.seqs) {
            for (SequenceI aliSeq : this.alignment.getSequencesArray()) {
                if (!resultSeq.getName().equals(aliSeq.getName())) continue;
                --nNew;
                continue block0;
            }
        }
        return nNew;
    }

    protected void realignResults(SequenceI[] hmmAndSeqs) {
        Alignment al = new Alignment(hmmAndSeqs);
        AlignFrame frame = new AlignFrame(al, 1, 1);
        ArrayList<ArgumentI> alignArgs = new ArrayList<ArgumentI>();
        String alignTo = hmmAndSeqs[0].getName();
        List<String> options = Collections.singletonList(alignTo);
        Option option = new Option(MessageManager.getString("label.use_hmm"), "", true, alignTo, alignTo, options, null);
        alignArgs.add(option);
        if (this.trim) {
            alignArgs.add(new BooleanOption(MessageManager.getString("label.trim_termini"), MessageManager.getString("label.trim_termini_desc"), true, (Boolean)true, (Boolean)true, null));
        }
        HMMAlign hmmalign = new HMMAlign(frame, alignArgs);
        hmmalign.run();
        if (this.returnNoOfNewSeqs) {
            int nNew = this.checkForNewSequences();
            JvOptionPane.showMessageDialog((Component)frame.alignPanel, nNew + " " + MessageManager.getString("label.new_returned"));
        }
    }
}

