/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.StructureSelectionManagerProvider;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import java.awt.Component;

public class AssociatePdbFileWithSeq {
    private AssociatePdbFileWithSeq() {
    }

    public static PDBEntry associatePdbWithSeq(String fileName, DataSourceType type, SequenceI sequence, boolean prompt) {
        return AssociatePdbFileWithSeq.associatePdbWithSeq(fileName, type, sequence, prompt, Desktop.getInstance(), StructureImportSettings.TFType.DEFAULT, null, false);
    }

    public static PDBEntry associatePdbWithSeq(String fileName, DataSourceType type, SequenceI sequence, boolean prompt, StructureSelectionManagerProvider ssmp, StructureImportSettings.TFType tft, String paeFilename, boolean doXferSettings) {
        PDBEntry entry = new PDBEntry();
        StructureFile pdbfile = StructureSelectionManager.getStructureSelectionManager(ssmp).setMapping(false, new SequenceI[]{sequence}, null, fileName, type, tft, paeFilename, doXferSettings);
        if (pdbfile == null) {
            return null;
        }
        String id = pdbfile.getId();
        if (id == null && (id = prompt ? JvOptionPane.showInternalInputDialog((Component)Desktop.getDesktopPane(), MessageManager.getString("label.couldnt_find_pdb_id_in_file"), MessageManager.getString("label.no_pdb_id_in_file"), 3) : null) == null) {
            return null;
        }
        entry.setId(id);
        entry.setType(PDBEntry.Type.FILE);
        entry.setFile(fileName);
        sequence.getDatasetSequence().addPDBId(entry);
        entry.setStructureFile(pdbfile);
        StructureSelectionManager.getStructureSelectionManager(ssmp).registerPDBEntry(entry);
        if (tft != null) {
            entry.setTempFacType(tft);
        }
        if (paeFilename != null) {
            entry.setPAEFile(paeFilename);
        }
        return entry;
    }
}

