/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureRenderer;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.io.AnnotationFile;
import jalview.io.FeaturesFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AnnotationExporter
extends JPanel {
    private JInternalFrame frame;
    private AlignmentPanel ap;
    private boolean exportFeatures = true;
    private AlignmentAnnotation[] annotations;
    private boolean wholeView;
    private JCheckBox includeLinkedFeatures;
    JRadioButton GFFFormat = new JRadioButton();
    JRadioButton CSVFormat = new JRadioButton();
    private JPanel linkedFeaturesPanel;

    public AnnotationExporter(AlignmentPanel panel) {
        this.ap = panel;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Dimension preferredSize = this.frame.getPreferredSize();
        Desktop.addInternalFrame(this.frame, "", true, preferredSize.width, preferredSize.height, true, true);
    }

    public void exportFeatures() {
        this.exportFeatures = true;
        this.CSVFormat.setVisible(false);
        if (this.ap.av.isShowComplementFeatures()) {
            this.linkedFeaturesPanel.setVisible(true);
            this.frame.pack();
        }
        this.frame.setTitle(MessageManager.getString("label.export_features"));
    }

    public void exportAnnotations() {
        boolean showAnnotation = this.ap.av.isShowAnnotation();
        this.exportAnnotation(showAnnotation ? null : this.ap.av.getAlignment().getAlignmentAnnotation(), true);
    }

    public void exportAnnotation(AlignmentAnnotation toExport) {
        this.exportAnnotation(new AlignmentAnnotation[]{toExport}, false);
    }

    private void exportAnnotation(AlignmentAnnotation[] toExport, boolean forWholeView) {
        this.wholeView = forWholeView;
        this.annotations = toExport;
        this.exportFeatures = false;
        this.GFFFormat.setVisible(false);
        this.CSVFormat.setVisible(true);
        this.frame.setTitle(MessageManager.getString("label.export_annotations"));
    }

    public void setExportAsCSV() {
        if (this.CSVFormat != null) {
            this.CSVFormat.setSelected(true);
        }
    }

    private void toFile_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(this.exportFeatures ? MessageManager.getString("label.save_features_to_file") : MessageManager.getString("label.save_annotation_to_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            String text = this.getText();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                out.print(text);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.close_actionPerformed();
    }

    public String getText() {
        return this.exportFeatures ? this.getFeaturesText() : this.getAnnotationsText();
    }

    public String getAnnotationsText() {
        String text = this.CSVFormat.isSelected() ? new AnnotationFile().printCSVAnnotations(this.wholeView ? this.ap.av.getAlignment().getAlignmentAnnotation() : this.annotations) : (this.wholeView ? new AnnotationFile().printAnnotationsForView(this.ap.av) : new AnnotationFile().printAnnotations(this.annotations, null, null));
        return text;
    }

    public String getFeaturesText() {
        SequenceI[] sequences = this.ap.av.getAlignment().getSequencesArray();
        boolean includeNonPositional = this.ap.av.isShowNPFeats();
        FeaturesFile formatter = new FeaturesFile();
        FeatureRenderer fr = this.ap.getFeatureRenderer();
        boolean includeComplement = this.includeLinkedFeatures.isSelected();
        String text = this.GFFFormat.isSelected() ? formatter.printGffFormat(sequences, fr, includeNonPositional, includeComplement) : formatter.printJalviewFormat(sequences, fr, includeNonPositional, includeComplement);
        return text;
    }

    private void toTextbox_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            String text = this.getText();
            cap.setText(text);
            Desktop.addInternalFrame(cap, this.exportFeatures ? MessageManager.formatMessage("label.features_for_params", new String[]{this.ap.alignFrame.getTitle()}) : MessageManager.formatMessage("label.annotations_for_params", new String[]{this.ap.alignFrame.getTitle()}), 600, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning(this.exportFeatures ? MessageManager.formatMessage("label.generating_features_for_params", new String[]{this.ap.alignFrame.getTitle()}) : MessageManager.formatMessage("label.generating_annotations_for_params", new String[]{this.ap.alignFrame.getTitle()}), oom);
            cap.dispose();
        }
        this.close_actionPerformed();
    }

    private void close_actionPerformed() {
        try {
            this.frame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.white);
        JPanel formatPanel = this.buildFormatOptionsPanel();
        JPanel linkedFeatures = this.buildLinkedFeaturesPanel();
        JPanel actionsPanel = this.buildActionsPanel();
        this.add(formatPanel);
        this.add(linkedFeatures);
        this.add(actionsPanel);
    }

    private JPanel buildLinkedFeaturesPanel() {
        this.linkedFeaturesPanel = new JPanel();
        this.linkedFeaturesPanel.setOpaque(false);
        boolean nucleotide = this.ap.av.isNucleotide();
        String complement = nucleotide ? MessageManager.getString("label.protein").toLowerCase(Locale.ROOT) : "CDS";
        JLabel label = new JLabel(MessageManager.formatMessage("label.include_linked_features", complement));
        label.setHorizontalAlignment(11);
        String tooltip = MessageManager.formatMessage("label.include_linked_tooltip", complement);
        label.setToolTipText(JvSwingUtils.wrapTooltip(true, tooltip));
        this.includeLinkedFeatures = new JCheckBox();
        this.linkedFeaturesPanel.add(label);
        this.linkedFeaturesPanel.add(this.includeLinkedFeatures);
        this.linkedFeaturesPanel.setVisible(false);
        return this.linkedFeaturesPanel;
    }

    JPanel buildActionsPanel() {
        JPanel actionsPanel = new JPanel();
        actionsPanel.setOpaque(false);
        JButton toFile = new JButton(MessageManager.getString("label.to_file"));
        toFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.toFile_actionPerformed();
            }
        });
        JButton toTextbox = new JButton(MessageManager.getString("label.to_textbox"));
        toTextbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.toTextbox_actionPerformed();
            }
        });
        JButton close = new JButton(MessageManager.getString("action.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationExporter.this.close_actionPerformed();
            }
        });
        actionsPanel.add(toFile);
        actionsPanel.add(toTextbox);
        actionsPanel.add(close);
        return actionsPanel;
    }

    JPanel buildFormatOptionsPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setOpaque(false);
        JRadioButton jalviewFormat = new JRadioButton("Jalview");
        jalviewFormat.setOpaque(false);
        jalviewFormat.setSelected(true);
        this.GFFFormat.setOpaque(false);
        this.GFFFormat.setText("GFF");
        this.CSVFormat.setOpaque(false);
        this.CSVFormat.setText(MessageManager.getString("label.csv_spreadsheet"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jalviewFormat);
        buttonGroup.add(this.GFFFormat);
        buttonGroup.add(this.CSVFormat);
        JLabel format = new JLabel(MessageManager.getString("action.format") + " ");
        format.setHorizontalAlignment(11);
        formatPanel.add(format);
        formatPanel.add(jalviewFormat);
        formatPanel.add(this.GFFFormat);
        formatPanel.add(this.CSVFormat);
        return formatPanel;
    }
}

