/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.pdb;

import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.gui.Help;
import jalview.gui.SequenceFetcher;
import jalview.util.MessageManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.help.HelpSetException;

public class PDBFTSPanel
extends GFTSPanel {
    private static String defaultFTSFrameTitle = MessageManager.getString("label.pdb_sequence_fetcher");
    private static Map<String, Integer> tempUserPrefs = new HashMap<String, Integer>();
    private static final String PDB_FTS_CACHE_KEY = "CACHE.PDB_FTS";
    private static final String PDB_AUTOSEARCH = "FTS.PDB.AUTOSEARCH";

    public PDBFTSPanel(SequenceFetcher fetcher) {
        super(fetcher);
        this.pageLimit = PDBFTSRestClient.getInstance().getDefaultResponsePageSize();
        this.seqFetcher = fetcher;
        this.progressIndicator = fetcher == null ? null : fetcher.getProgressIndicator();
    }

    @Override
    public void searchAction(boolean isFreshSearch) {
        this.mainFrame.requestFocusInWindow();
        if (isFreshSearch) {
            this.offSet = 0;
        }
        new Thread(){

            @Override
            public void run() {
                PDBFTSPanel.this.reset();
                boolean allowEmptySequence = false;
                if (PDBFTSPanel.this.getTypedText().length() > 0) {
                    String result;
                    FTSRestResponse resultList;
                    PDBFTSPanel.this.setSearchInProgress(true);
                    long startTime = System.currentTimeMillis();
                    String searchTarget = ((FTSDataColumnI)PDBFTSPanel.this.cmb_searchTarget.getSelectedItem()).getCode();
                    PDBFTSPanel.this.wantedFields = PDBFTSRestClient.getInstance().getAllDefaultDisplayedFTSDataColumns();
                    String searchTerm = PDBFTSPanel.decodeSearchTerm(PDBFTSPanel.this.getTypedText(), searchTarget);
                    FTSRestRequest request = new FTSRestRequest();
                    request.setAllowEmptySeq(allowEmptySequence);
                    request.setResponseSize(100);
                    request.setFieldToSearchBy("(" + searchTarget + ":");
                    request.setSearchTerm(searchTerm + ")");
                    request.setOffSet(PDBFTSPanel.this.offSet);
                    request.setWantedFields(PDBFTSPanel.this.wantedFields);
                    FTSRestClientI pdbRestClient = PDBFTSRestClient.getInstance();
                    try {
                        resultList = pdbRestClient.executeRequest(request);
                    }
                    catch (Exception e) {
                        PDBFTSPanel.this.setErrorMessage(e.getMessage());
                        PDBFTSPanel.this.checkForErrors();
                        PDBFTSPanel.this.setSearchInProgress(false);
                        return;
                    }
                    if (resultList.getSearchSummary() != null && resultList.getSearchSummary().size() > 0) {
                        PDBFTSPanel.this.getResultTable().setModel(FTSRestResponse.getTableModel(request, resultList.getSearchSummary()));
                        FTSRestResponse.configureTableColumn(PDBFTSPanel.this.getResultTable(), PDBFTSPanel.this.wantedFields, tempUserPrefs);
                        PDBFTSPanel.this.getResultTable().setVisible(true);
                    }
                    long endTime = System.currentTimeMillis();
                    PDBFTSPanel.this.totalResultSetCount = resultList.getNumberOfItemsFound();
                    PDBFTSPanel.this.resultSetCount = resultList.getSearchSummary() == null ? 0 : resultList.getSearchSummary().size();
                    String string = result = PDBFTSPanel.this.resultSetCount > 0 ? MessageManager.getString("label.results") : MessageManager.getString("label.result");
                    if (PDBFTSPanel.this.isPaginationEnabled() && PDBFTSPanel.this.resultSetCount > 0) {
                        String f1 = totalNumberformatter.format((Object)(PDBFTSPanel.this.offSet + 1));
                        String f2 = totalNumberformatter.format((Object)(PDBFTSPanel.this.offSet + PDBFTSPanel.this.resultSetCount));
                        String f3 = totalNumberformatter.format((Object)PDBFTSPanel.this.totalResultSetCount);
                        PDBFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + result + " " + f1 + " to " + f2 + " of " + f3 + "  (" + (endTime - startTime) + " milli secs)");
                    } else {
                        PDBFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + PDBFTSPanel.this.resultSetCount + " " + result + " (" + (endTime - startTime) + " milli secs)");
                    }
                    PDBFTSPanel.this.setSearchInProgress(false);
                    PDBFTSPanel.this.refreshPaginatorState();
                    PDBFTSPanel.this.updateSummaryTableSelections();
                }
                PDBFTSPanel.this.txt_search.updateCache();
            }
        }.start();
    }

    public static String decodeSearchTerm(String enteredText, String targetField) {
        String foundSearchTerms = enteredText;
        StringBuilder foundSearchTermsBuilder = new StringBuilder();
        if (enteredText.contains(";")) {
            String[] searchTerms;
            for (String searchTerm : searchTerms = enteredText.split(";")) {
                if (searchTerm.contains(":")) {
                    foundSearchTermsBuilder.append(targetField).append(":").append(searchTerm.split(":")[0]).append(" OR ");
                    continue;
                }
                foundSearchTermsBuilder.append(targetField).append(":").append(searchTerm).append(" OR ");
            }
            int endIndex = foundSearchTermsBuilder.lastIndexOf(" OR ");
            foundSearchTerms = foundSearchTermsBuilder.toString();
            if (foundSearchTerms.contains(" OR ")) {
                foundSearchTerms = foundSearchTerms.substring(targetField.length() + 1, endIndex);
            }
        } else if (enteredText.contains(":")) {
            foundSearchTerms = foundSearchTerms.split(":")[0];
        }
        return foundSearchTerms;
    }

    @Override
    public void okAction() {
        this.disableActionButtons();
        StringBuilder selectedIds = new StringBuilder();
        HashSet<String> selectedIdsSet = new HashSet<String>();
        int primaryKeyColIndex = 0;
        try {
            primaryKeyColIndex = this.getFTSRestClient().getPrimaryKeyColumIndex(this.wantedFields, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] selectedRows = this.getResultTable().getSelectedRows();
        String searchTerm = this.getTypedText();
        for (int summaryRow : selectedRows) {
            String idStr = this.getResultTable().getValueAt(summaryRow, primaryKeyColIndex).toString();
            selectedIdsSet.add(PDBFTSPanel.getPDBIdwithSpecifiedChain(idStr, searchTerm));
        }
        Object object = this.paginatorCart.iterator();
        while (object.hasNext()) {
            String idStr = (String)object.next();
            selectedIdsSet.add(PDBFTSPanel.getPDBIdwithSpecifiedChain(idStr, searchTerm));
        }
        for (String selectedId : selectedIdsSet) {
            selectedIds.append(selectedId).append(";");
        }
        String ids = selectedIds.toString();
        this.seqFetcher.setQuery(ids);
        Thread worker = new Thread(this.seqFetcher);
        worker.start();
        this.delayAndEnableActionButtons();
    }

    public static String getPDBIdwithSpecifiedChain(String pdbId, String searchTerm) {
        String pdbIdWithChainCode = "";
        if (searchTerm.contains(";")) {
            String[] foundTerms;
            for (String foundTerm : foundTerms = searchTerm.split(";")) {
                if (!foundTerm.contains(pdbId)) continue;
                pdbIdWithChainCode = foundTerm;
            }
        } else {
            pdbIdWithChainCode = searchTerm.contains(pdbId) ? searchTerm : pdbId;
        }
        return pdbIdWithChainCode;
    }

    @Override
    public FTSRestClientI getFTSRestClient() {
        return PDBFTSRestClient.getInstance();
    }

    @Override
    public String getFTSFrameTitle() {
        return defaultFTSFrameTitle;
    }

    @Override
    public boolean isPaginationEnabled() {
        return true;
    }

    @Override
    public Map<String, Integer> getTempUserPrefs() {
        return tempUserPrefs;
    }

    @Override
    public String getCacheKey() {
        return PDB_FTS_CACHE_KEY;
    }

    @Override
    public String getAutosearchPreference() {
        return PDB_AUTOSEARCH;
    }

    @Override
    protected void showHelp() {
        try {
            Help.showHelpWindow(Help.HelpId.PdbFts);
        }
        catch (HelpSetException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public String getDbName() {
        return "PDB";
    }
}

