/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.bin.Console;
import jalview.ext.ensembl.EnsemblData;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.util.HttpUtils;
import jalview.util.Platform;
import jalview.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

abstract class EnsemblRestClient
extends EnsemblSequenceFetcher {
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int CONNECT_TIMEOUT_MS = 10000;
    private static final int MAX_RETRIES = 3;
    private static final int HTTP_OK = 200;
    private static final int HTTP_OVERLOAD = 429;
    private static final String LATEST_ENSEMBLGENOMES_REST_VERSION = "15.8";
    private static final String LATEST_ENSEMBL_REST_VERSION = "15.8";
    private static final String REST_CHANGE_LOG = "https://github.com/Ensembl/ensembl-rest/wiki/Change-log";
    private static Map<String, EnsemblData> domainData;
    private static final long AVAILABILITY_RETEST_INTERVAL = 10000L;
    private static final long VERSION_RETEST_INTERVAL = 3600000L;
    protected static final String CONTENT_TYPE_JSON = "?content-type=application/json";
    protected volatile boolean inProgress = false;
    protected static final int MODE_ARRAY = 0;
    protected static final int MODE_MAP = 1;
    protected static final int MODE_ITERATOR = 2;

    public EnsemblRestClient() {
        if (!domainData.containsKey(this.ensemblDomain)) {
            domainData.put(this.ensemblDomain, new EnsemblData(this.ensemblDomain, "15.8"));
        }
        if (!domainData.containsKey(this.ensemblGenomesDomain)) {
            domainData.put(this.ensemblGenomesDomain, new EnsemblData(this.ensemblGenomesDomain, "15.8"));
        }
    }

    public EnsemblRestClient(String d) {
        this.setDomain(d);
    }

    @Override
    public boolean queryInProgress() {
        return this.inProgress;
    }

    @Override
    public StringBuffer getRawRecords() {
        return null;
    }

    protected abstract URL getUrl(List<String> var1) throws MalformedURLException;

    protected abstract boolean useGetRequest();

    protected String getRequestMimeType() {
        return "application/json";
    }

    protected String getResponseMimeType() {
        return "application/json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkEnsembl() {
        block16: {
            boolean bl;
            BufferedReader br = null;
            String pingUrl = this.getDomain() + "/info/ping?content-type=application/json";
            try {
                Map val = (Map)this.getJSON(new URL(pingUrl), null, 2000, 1, null);
                if (val == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                String pingString = val.get("ping").toString();
                bl = pingString != null;
            }
            catch (Throwable t) {
                Console.errPrintln("Error connecting to " + pingUrl + ": " + t.getMessage());
                break block16;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    private Object getJSON(URL url, List<String> ids, int readTimeout) throws IOException, ParseException {
        if (readTimeout < 0) {
            readTimeout = 300000;
        }
        int retriesLeft = 3;
        URLConnection connection = null;
        int responseCode = 0;
        Platform.setAjaxJSON(url);
        while (retriesLeft > 0) {
            connection = this.tryConnection(url, ids, readTimeout);
            responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode == 429) {
                --retriesLeft;
                this.checkRetryAfter((HttpURLConnection)connection);
                continue;
            }
            retriesLeft = 0;
        }
        if (responseCode != 200) {
            Console.errPrintln("Response code " + responseCode);
            return null;
        }
        InputStream response = connection.getInputStream();
        Object ret = Platform.parseJSON(response);
        return ret;
    }

    protected HttpURLConnection tryConnection(URL url, List<String> ids, int readTimeout) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)HttpUtils.openConnection(url);
        boolean multipleIds = ids != null && ids.size() > 1;
        connection.setRequestMethod(multipleIds ? "POST" : "GET");
        connection.setRequestProperty("Content-Type", this.getRequestMimeType());
        connection.setRequestProperty("Accept", this.getResponseMimeType());
        connection.setDoInput(true);
        connection.setDoOutput(multipleIds);
        connection.setUseCaches(false);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(readTimeout);
        if (multipleIds) {
            this.writePostBody(connection, ids);
        }
        return connection;
    }

    void checkRetryAfter(HttpURLConnection connection) {
        String retryDelay = connection.getHeaderField("Retry-After");
        if (retryDelay != null) {
            try {
                int retrySecs = Integer.valueOf(retryDelay);
                if (retrySecs > 0 && retrySecs < 10) {
                    Console.errPrintln("Ensembl REST service rate limit exceeded, waiting " + retryDelay + " seconds before retrying");
                    Thread.sleep(1000 * retrySecs);
                }
            }
            catch (InterruptedException | NumberFormatException e) {
                Console.errPrintln("Error handling Retry-After: " + e.getMessage());
            }
        }
    }

    protected boolean isEnsemblAvailable() {
        boolean refetchVersion;
        boolean retestAvailability;
        EnsemblData info = domainData.get(this.getDomain());
        long now = System.currentTimeMillis();
        boolean bl = retestAvailability = now - info.lastAvailableCheckTime > 10000L;
        if (!info.restAvailable || retestAvailability) {
            info.restAvailable = this.checkEnsembl();
            info.lastAvailableCheckTime = now;
        }
        boolean bl2 = refetchVersion = now - info.lastVersionCheckTime > 3600000L;
        if (refetchVersion) {
            this.checkEnsemblRestVersion();
            this.checkEnsemblDataVersion();
            info.lastVersionCheckTime = now;
        }
        return info.restAvailable;
    }

    protected void writePostBody(HttpURLConnection connection, List<String> ids) throws IOException {
        StringBuilder postBody = new StringBuilder(64);
        postBody.append("{\"ids\":[");
        boolean first = true;
        int n = ids.size();
        for (int i = 0; i < n; ++i) {
            String id = ids.get(i);
            if (!first) {
                postBody.append(",");
            }
            first = false;
            postBody.append("\"");
            postBody.append(id.trim());
            postBody.append("\"");
        }
        postBody.append("]}");
        byte[] thepostbody = postBody.toString().getBytes();
        connection.setRequestProperty("Content-Length", Integer.toString(thepostbody.length));
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.write(thepostbody);
        wr.flush();
        wr.close();
    }

    protected Object getJSON(URL url, List<String> ids, int msDelay, int mode, String mapKey) throws IOException, ParseException {
        Iterator json;
        if (url == null) {
            url = this.getUrl(ids);
        }
        Iterator iterator = json = url == null ? null : this.getJSON(url, ids, msDelay);
        if (json != null && mapKey != null) {
            json = ((Map)((Object)json)).get(mapKey);
        }
        if (json == null) {
            return null;
        }
        switch (mode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                json = ((List)((Object)json)).iterator();
            }
        }
        return json;
    }

    private void checkEnsemblRestVersion() {
        EnsemblData info = domainData.get(this.getDomain());
        try {
            boolean laterVersion;
            Map val = (Map)this.getJSON(new URL(this.getDomain() + "/info/rest?content-type=application/json"), null, -1, 1, null);
            if (val == null) {
                return;
            }
            String version = val.get("release").toString();
            String majorVersion = version.substring(0, version.indexOf("."));
            String expected = info.expectedRestVersion;
            String expectedMajorVersion = expected.substring(0, expected.indexOf("."));
            info.restMajorVersionMismatch = false;
            try {
                if (Float.valueOf(majorVersion).floatValue() > Float.valueOf(expectedMajorVersion).floatValue()) {
                    info.restMajorVersionMismatch = true;
                }
            }
            catch (NumberFormatException e) {
                Console.errPrintln("Error in REST version: " + e.toString());
            }
            boolean bl = laterVersion = StringUtils.compareVersions(version, expected) == 1;
            if (laterVersion) {
                Console.errPrintln(String.format("EnsemblRestClient expected %s REST version %s but found %s, see %s", this.getDbSource(), expected, version, REST_CHANGE_LOG));
            }
            info.restVersion = version;
        }
        catch (Throwable t) {
            Console.errPrintln("Error checking Ensembl REST version: " + t.getMessage());
        }
    }

    public boolean isRestMajorVersionMismatch() {
        return EnsemblRestClient.domainData.get((Object)this.getDomain()).restMajorVersionMismatch;
    }

    private void checkEnsemblDataVersion() {
        try {
            Map val = (Map)this.getJSON(new URL(this.getDomain() + "/info/data?content-type=application/json"), null, -1, 1, null);
            if (val == null) {
                return;
            }
            List versions = (List)val.get("releases");
            EnsemblRestClient.domainData.get((Object)this.getDomain()).dataVersion = versions.get(0).toString();
        }
        catch (Throwable e) {
            Console.errPrintln("Error checking Ensembl data version: " + e.getMessage());
        }
    }

    public String getEnsemblDataVersion() {
        return EnsemblRestClient.domainData.get((Object)this.getDomain()).dataVersion;
    }

    @Override
    public String getDbVersion() {
        return this.getEnsemblDataVersion();
    }

    static {
        Platform.addJ2SDirectDatabaseCall("http://rest.ensembl");
        Platform.addJ2SDirectDatabaseCall("https://rest.ensembl");
        domainData = new HashMap<String, EnsemblData>();
        domainData.put("https://rest.ensembl.org", new EnsemblData("https://rest.ensembl.org", "15.8"));
        domainData.put("https://rest.ensembl.org", new EnsemblData("https://rest.ensembl.org", "15.8"));
    }
}

