/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AlignmentUtils;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactMapHolder;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.FastaFile;
import jalview.util.Comparison;
import jalview.util.LinkedIdentityHashSet;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Alignment
implements AlignmentI,
AutoCloseable {
    private Alignment dataset;
    private List<SequenceI> sequences;
    protected List<SequenceGroup> groups;
    protected char gapCharacter = (char)45;
    private boolean nucleotide = true;
    public boolean hasRNAStructure = false;
    public AlignmentAnnotation[] annotations;
    HiddenSequences hiddenSequences;
    HiddenColumns hiddenCols;
    public Hashtable alignmentProperties;
    private List<AlignedCodonFrame> codonFrameList;
    int alignmentRefs = 0;
    private SequenceI seqrep = null;
    ContactMapHolder cmholder = new ContactMapHolder();

    private void initAlignment(SequenceI[] seqs) {
        this.groups = Collections.synchronizedList(new ArrayList());
        this.hiddenSequences = new HiddenSequences(this);
        this.hiddenCols = new HiddenColumns();
        this.codonFrameList = new ArrayList<AlignedCodonFrame>();
        this.nucleotide = Comparison.isNucleotide(seqs);
        this.sequences = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < seqs.length; ++i) {
            this.sequences.add(seqs[i]);
        }
    }

    public Alignment(AlignmentI al) {
        SequenceI[] seqs = al.getSequencesArray();
        for (int i = 0; i < seqs.length; ++i) {
            seqs[i] = new Sequence(seqs[i]);
        }
        this.initAlignment(seqs);
        if (this.dataset == null && al.getDataset() == null) {
            this.setCodonFrames(al.getCodonFrames());
        }
    }

    public Alignment(SequenceI[] seqs) {
        this.initAlignment(seqs);
    }

    public Alignment(SeqCigar[] alseqs) {
        SequenceI[] seqs = SeqCigar.createAlignmentSequences(alseqs, this.gapCharacter, new HiddenColumns(), null);
        this.initAlignment(seqs);
    }

    public static AlignmentI createAlignment(CigarArray compactAlignment) {
        throw new Error(MessageManager.getString("error.alignment_cigararray_not_implemented"));
    }

    @Override
    public List<SequenceI> getSequences() {
        return this.sequences;
    }

    @Override
    public List<SequenceI> getSequences(Map<SequenceI, SequenceCollectionI> hiddenReps) {
        return this.sequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceI[] getSequencesArray() {
        if (this.sequences == null) {
            return null;
        }
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            return this.sequences.toArray(new SequenceI[this.sequences.size()]);
        }
    }

    @Override
    public Map<String, List<SequenceI>> getSequencesByName() {
        return AlignmentUtils.getSequencesByName(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceI getSequenceAt(int i) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (i > -1 && i < this.sequences.size()) {
                return this.sequences.get(i);
            }
        }
        return null;
    }

    @Override
    public SequenceI getSequenceAtAbsoluteIndex(int i) {
        SequenceI seq = null;
        if (this.getHiddenSequences().getSize() > 0) {
            seq = this.getHiddenSequences().getHiddenSequence(i);
            if (seq == null) {
                int index = this.getHiddenSequences().findIndexWithoutHiddenSeqs(i);
                seq = this.getSequenceAt(index);
            }
        } else {
            seq = this.getSequenceAt(i);
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSequence(SequenceI snew) {
        if (this.dataset != null) {
            SequenceI dsseq = snew.getDatasetSequence();
            if (dsseq == null) {
                SequenceI adding;
                snew = adding = snew.deriveSequence();
                dsseq = snew.getDatasetSequence();
            }
            if (this.getDataset().findIndex(dsseq) == -1) {
                this.getDataset().addSequence(dsseq);
            }
        }
        if (this.sequences == null) {
            this.initAlignment(new SequenceI[]{snew});
        } else {
            List<SequenceI> list = this.sequences;
            synchronized (list) {
                this.sequences.add(snew);
            }
        }
        if (this.hiddenSequences != null) {
            this.hiddenSequences.adjustHeightSequenceAdded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceI replaceSequenceAt(int i, SequenceI snew) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (this.sequences.size() > i) {
                return this.sequences.set(i, snew);
            }
            this.sequences.add(snew);
            this.hiddenSequences.adjustHeightSequenceAdded();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertSequenceAt(int i, SequenceI snew) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (this.sequences.size() > i) {
                this.sequences.add(i, snew);
                return;
            }
            this.sequences.add(snew);
            this.hiddenSequences.adjustHeightSequenceAdded();
            return;
        }
    }

    @Override
    public List<SequenceGroup> getGroups() {
        return this.groups;
    }

    @Override
    public void close() {
        if (this.getDataset() != null) {
            try {
                this.getDataset().removeAlignmentRef();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.nullReferences();
    }

    void nullReferences() {
        this.dataset = null;
        this.sequences = null;
        this.groups = null;
        this.annotations = null;
        this.hiddenSequences = null;
    }

    private void removeAlignmentRef() throws Throwable {
        if (--this.alignmentRefs == 0) {
            this.nullReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSequence(SequenceI s) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            this.deleteSequence(this.findIndex(s));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSequence(int i) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (i > -1 && i < this.getHeight()) {
                this.sequences.remove(i);
                this.hiddenSequences.adjustHeightSequenceDeleted(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHiddenSequence(int i) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (i > -1 && i < this.getHeight()) {
                this.sequences.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceGroup findGroup(SequenceI seq, int position) {
        List<SequenceGroup> list = this.groups;
        synchronized (list) {
            for (SequenceGroup sg : this.groups) {
                if (!sg.getSequences(null).contains(seq) || position < sg.getStartRes() || position > sg.getEndRes()) continue;
                return sg;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceGroup[] findAllGroups(SequenceI s) {
        ArrayList<SequenceGroup> temp = new ArrayList<SequenceGroup>();
        List<SequenceGroup> list = this.groups;
        synchronized (list) {
            int gSize = this.groups.size();
            for (int i = 0; i < gSize; ++i) {
                SequenceGroup sg = this.groups.get(i);
                if (sg == null || sg.getSequences() == null) {
                    this.deleteGroup(sg);
                    --gSize;
                    continue;
                }
                if (!sg.getSequences().contains(s)) continue;
                temp.add(sg);
            }
        }
        SequenceGroup[] ret = new SequenceGroup[temp.size()];
        return temp.toArray(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(SequenceGroup sg) {
        List<SequenceGroup> list = this.groups;
        synchronized (list) {
            if (!this.groups.contains(sg)) {
                if (this.hiddenSequences.getSize() > 0) {
                    int iSize = sg.getSize();
                    for (int i = 0; i < iSize; ++i) {
                        if (this.sequences.contains(sg.getSequenceAt(i))) continue;
                        sg.deleteSequence(sg.getSequenceAt(i), false);
                        --iSize;
                        --i;
                    }
                    if (sg.getSize() < 1) {
                        return;
                    }
                }
                sg.setContext(this, true);
                this.groups.add(sg);
            }
        }
    }

    private void removeAnnotationForGroup(SequenceGroup gp) {
        int i;
        int k;
        int p;
        if (this.annotations == null || this.annotations.length == 0) {
            return;
        }
        AlignmentAnnotation[] todelete = new AlignmentAnnotation[this.annotations.length];
        AlignmentAnnotation[] tokeep = new AlignmentAnnotation[this.annotations.length];
        if (gp == null) {
            p = 0;
            k = 0;
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i].groupRef != null) {
                    todelete[p++] = this.annotations[i];
                    continue;
                }
                tokeep[k++] = this.annotations[i];
            }
        } else {
            p = 0;
            k = 0;
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i].groupRef == gp) {
                    todelete[p++] = this.annotations[i];
                    continue;
                }
                tokeep[k++] = this.annotations[i];
            }
        }
        if (p > 0) {
            for (i = 0; i < p; ++i) {
                this.unhookAnnotation(todelete[i]);
                todelete[i] = null;
            }
            AlignmentAnnotation[] t = new AlignmentAnnotation[k];
            for (i = 0; i < k; ++i) {
                t[i] = tokeep[i];
            }
            this.annotations = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllGroups() {
        List<SequenceGroup> list = this.groups;
        synchronized (list) {
            if (this.annotations != null) {
                this.removeAnnotationForGroup(null);
            }
            for (SequenceGroup sg : this.groups) {
                sg.setContext(null, false);
            }
            this.groups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(SequenceGroup g) {
        List<SequenceGroup> list = this.groups;
        synchronized (list) {
            if (this.groups.contains(g)) {
                this.removeAnnotationForGroup(g);
                this.groups.remove(g);
                g.setContext(null, false);
            }
        }
    }

    @Override
    public SequenceI findName(String name) {
        return this.findName(name, false);
    }

    @Override
    public SequenceI findName(String token, boolean b) {
        return this.findName(null, token, b);
    }

    @Override
    public SequenceI findName(SequenceI startAfter, String token, boolean b) {
        if (token == null) {
            return null;
        }
        int i = 0;
        SequenceI sq = null;
        String sqname = null;
        int nseq = this.sequences.size();
        if (startAfter != null) {
            boolean matched = false;
            while (i < nseq) {
                if (this.getSequenceAt(i++) != startAfter) continue;
                matched = true;
                break;
            }
            if (!matched) {
                i = 0;
            }
        }
        while (i < nseq) {
            sq = this.getSequenceAt(i);
            sqname = sq.getName();
            if (sqname.equals(token) || b && sqname.equalsIgnoreCase(token)) {
                return this.getSequenceAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public SequenceI[] findSequenceMatch(String name) {
        int i;
        Vector<SequenceI> matches = new Vector<SequenceI>();
        for (i = 0; i < this.sequences.size(); ++i) {
            if (!this.getSequenceAt(i).getName().equals(name)) continue;
            matches.addElement(this.getSequenceAt(i));
        }
        SequenceI[] result = new SequenceI[matches.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (SequenceI)matches.elementAt(i);
        }
        return result;
    }

    @Override
    public int findIndex(SequenceI s) {
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (s != this.getSequenceAt(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findIndex(SearchResultsI results) {
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (!results.involvesSequence(this.getSequenceAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getHeight() {
        return this.sequences.size();
    }

    @Override
    public int getAbsoluteHeight() {
        return this.sequences.size() + this.getHiddenSequences().getSize();
    }

    @Override
    public int getWidth() {
        int maxLength = -1;
        for (int i = 0; i < this.sequences.size(); ++i) {
            maxLength = Math.max(maxLength, this.getSequenceAt(i).getLength());
        }
        return maxLength;
    }

    @Override
    public int getVisibleWidth() {
        int w = this.getWidth();
        if (this.hiddenCols != null) {
            w -= this.hiddenCols.getSize();
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGapCharacter(char gc) {
        this.gapCharacter = gc;
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            for (SequenceI seq : this.sequences) {
                seq.setSequence(seq.getSequenceAsString().replace('.', gc).replace('-', gc).replace(' ', gc));
            }
        }
    }

    @Override
    public char getGapCharacter() {
        return this.gapCharacter;
    }

    @Override
    public boolean isAligned() {
        return this.isAligned(false);
    }

    @Override
    public boolean isAligned(boolean includeHidden) {
        int width = this.getWidth();
        if (this.hiddenSequences == null || this.hiddenSequences.getSize() == 0) {
            includeHidden = true;
        }
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (!includeHidden && this.hiddenSequences.isHidden(this.getSequenceAt(i)) || this.getSequenceAt(i).getLength() == width) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isHidden(int alignmentIndex) {
        return this.getHiddenSequences().getHiddenSequence(alignmentIndex) != null;
    }

    @Override
    public boolean deleteAllAnnotations(boolean includingAutoCalculated) {
        boolean result = false;
        for (AlignmentAnnotation alan : this.getAlignmentAnnotation()) {
            if (alan.autoCalculated && !includingAutoCalculated) continue;
            this.deleteAnnotation(alan);
            result = true;
        }
        return result;
    }

    @Override
    public boolean deleteAnnotation(AlignmentAnnotation aa) {
        return this.deleteAnnotation(aa, true);
    }

    @Override
    public boolean deleteAnnotation(AlignmentAnnotation aa, boolean unhook) {
        int aSize = 1;
        if (this.annotations != null) {
            aSize = this.annotations.length;
        }
        if (aSize < 1) {
            return false;
        }
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize - 1];
        boolean swap = false;
        int tIndex = 0;
        for (int i = 0; i < aSize; ++i) {
            if (this.annotations[i] == aa) {
                swap = true;
                continue;
            }
            if (tIndex >= temp.length) continue;
            temp[tIndex++] = this.annotations[i];
        }
        if (swap) {
            this.annotations = temp;
            if (unhook) {
                this.unhookAnnotation(aa);
            }
        }
        return swap;
    }

    private void unhookAnnotation(AlignmentAnnotation aa) {
        if (aa.sequenceRef != null) {
            aa.sequenceRef.removeAlignmentAnnotation(aa);
        }
        if (aa.groupRef != null) {
            aa.groupRef = null;
        }
    }

    @Override
    public void addAnnotation(AlignmentAnnotation aa) {
        this.addAnnotation(aa, -1);
    }

    @Override
    public void addAnnotation(AlignmentAnnotation aa, int pos) {
        if (aa.getRNAStruc() != null) {
            this.hasRNAStructure = true;
        }
        int aSize = 1;
        if (this.annotations != null) {
            aSize = this.annotations.length + 1;
        }
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize];
        int i = 0;
        if (pos == -1 || pos >= aSize) {
            temp[aSize - 1] = aa;
        } else {
            temp[pos] = aa;
        }
        if (aSize > 1) {
            int p = 0;
            i = 0;
            while (i < aSize - 1) {
                if (p == pos) {
                    ++p;
                }
                if (p < temp.length) {
                    temp[p] = this.annotations[i];
                }
                ++i;
                ++p;
            }
        }
        this.annotations = temp;
    }

    @Override
    public void setAnnotationIndex(AlignmentAnnotation aa, int index) {
        if (aa == null || this.annotations == null || this.annotations.length - 1 < index) {
            return;
        }
        int aSize = this.annotations.length;
        AlignmentAnnotation[] temp = new AlignmentAnnotation[aSize];
        temp[index] = aa;
        for (int i = 0; i < aSize; ++i) {
            if (i == index) continue;
            temp[i] = i < index ? this.annotations[i] : this.annotations[i - 1];
        }
        this.annotations = temp;
    }

    @Override
    public AlignmentAnnotation[] getAlignmentAnnotation() {
        return this.annotations;
    }

    @Override
    public boolean isNucleotide() {
        return this.nucleotide;
    }

    @Override
    public boolean hasRNAStructure() {
        return this.hasRNAStructure;
    }

    @Override
    public void setDataset(AlignmentI data) {
        if (this.dataset == null && data == null) {
            this.createDatasetAlignment();
        } else if (this.dataset == null && data != null) {
            if (data == this) {
                throw new IllegalArgumentException("Circular dataset reference");
            }
            if (!(data instanceof Alignment)) {
                throw new Error("Implementation Error: jalview.datamodel.Alignment does not yet support other implementations of AlignmentI as its dataset reference");
            }
            this.dataset = (Alignment)data;
            for (int i = 0; i < this.getHeight(); ++i) {
                SequenceI currentSeq = this.getSequenceAt(i);
                SequenceI dsq = currentSeq.getDatasetSequence();
                if (dsq == null) {
                    dsq = currentSeq.createDatasetSequence();
                    this.dataset.addSequence(dsq);
                    continue;
                }
                while (dsq.getDatasetSequence() != null) {
                    dsq = dsq.getDatasetSequence();
                }
                if (this.dataset.findIndex(dsq) != -1) continue;
                this.dataset.addSequence(dsq);
            }
        }
        this.dataset.addAlignmentRef();
    }

    private void resolveAndAddDatasetSeq(SequenceI currentSeq, Set<SequenceI> seqs, boolean createDatasetSequence) {
        SequenceI alignedSeq = currentSeq;
        if (currentSeq.getDatasetSequence() != null) {
            currentSeq = currentSeq.getDatasetSequence();
        } else if (createDatasetSequence) {
            currentSeq = currentSeq.createDatasetSequence();
        }
        ArrayList<SequenceI> toProcess = new ArrayList<SequenceI>();
        toProcess.add(currentSeq);
        while (toProcess.size() > 0) {
            SequenceI curDs = (SequenceI)toProcess.remove(0);
            if (!seqs.add(curDs) || curDs.getDBRefs() == null) continue;
            for (DBRefEntry dbr : curDs.getDBRefs()) {
                if (dbr.getMap() == null || dbr.getMap().getTo() == null) continue;
                if (dbr.getMap().getTo() == alignedSeq) {
                    dbr.getMap().setTo(currentSeq);
                }
                if (dbr.getMap().getTo().getDatasetSequence() != null) {
                    throw new Error("Implementation error: Map.getTo() for dbref " + dbr + " from " + curDs.getName() + " is not a dataset sequence.");
                }
                toProcess.add(dbr.getMap().getTo());
            }
        }
    }

    public void createDatasetAlignment() {
        if (this.dataset != null) {
            return;
        }
        LinkedIdentityHashSet<SequenceI> seqs = new LinkedIdentityHashSet<SequenceI>();
        for (int i = 0; i < this.getHeight(); ++i) {
            SequenceI currentSeq = this.getSequenceAt(i);
            this.resolveAndAddDatasetSeq(currentSeq, seqs, true);
        }
        for (AlignedCodonFrame cf : this.codonFrameList) {
            for (AlignedCodonFrame.SequenceToSequenceMapping ssm : cf.getMappings()) {
                if (!seqs.contains(ssm.getFromSeq())) {
                    this.resolveAndAddDatasetSeq(ssm.getFromSeq(), seqs, false);
                }
                if (seqs.contains(ssm.getMapping().getTo())) continue;
                this.resolveAndAddDatasetSeq(ssm.getMapping().getTo(), seqs, false);
            }
        }
        this.dataset = new Alignment(seqs.toArray(new SequenceI[seqs.size()]));
        this.dataset.codonFrameList = this.codonFrameList;
        this.codonFrameList = null;
    }

    private void addAlignmentRef() {
        ++this.alignmentRefs;
    }

    @Override
    public Alignment getDataset() {
        return this.dataset;
    }

    @Override
    public boolean padGaps() {
        SequenceI current;
        boolean modified = false;
        int maxLength = -1;
        int nseq = this.sequences.size();
        block0: for (int i = 0; i < nseq; ++i) {
            current = this.getSequenceAt(i);
            for (int j = current.getLength(); j > maxLength; --j) {
                if (j <= maxLength || Comparison.isGap(current.getCharAt(j))) continue;
                maxLength = j;
                continue block0;
            }
        }
        ++maxLength;
        for (int i = 0; i < nseq; ++i) {
            current = this.getSequenceAt(i);
            int cLength = current.getLength();
            if (cLength < maxLength) {
                current.insertCharAt(cLength, maxLength - cLength, this.gapCharacter);
                modified = true;
                continue;
            }
            if (current.getLength() <= maxLength) continue;
            current.deleteChars(maxLength, current.getLength());
        }
        return modified;
    }

    @Override
    public boolean justify(boolean right) {
        SequenceI current;
        boolean modified = false;
        int maxLength = -1;
        int[] ends = new int[this.sequences.size() * 2];
        for (int i = 0; i < this.sequences.size(); ++i) {
            current = this.getSequenceAt(i);
            ends[i * 2] = current.findIndex(current.getStart());
            ends[i * 2 + 1] = current.findIndex(current.getStart() + current.getLength());
            boolean hitres = false;
            boolean rs = false;
            int ssiz = current.getLength();
            for (int j = 0; j < ssiz; ++j) {
                if (Comparison.isGap(current.getCharAt(j))) continue;
                if (!hitres) {
                    ends[i * 2] = j;
                    hitres = true;
                    continue;
                }
                ends[i * 2 + 1] = j;
                if (j - ends[i * 2] <= maxLength) continue;
                maxLength = j - ends[i * 2];
            }
        }
        ++maxLength;
        for (int i = 0; i < this.sequences.size(); ++i) {
            current = this.getSequenceAt(i);
            int cLength = 1 + ends[i * 2 + 1] - ends[i * 2];
            int diff = maxLength - cLength;
            int extent = current.getLength();
            if (right) {
                if (extent > ends[i * 2 + 1]) {
                    current.deleteChars(ends[i * 2 + 1] + 1, extent);
                    modified = true;
                }
                if (ends[i * 2] > diff) {
                    current.deleteChars(0, ends[i * 2] - diff);
                    modified = true;
                    continue;
                }
                if (ends[i * 2] >= diff) continue;
                current.insertCharAt(0, diff - ends[i * 2], this.gapCharacter);
                modified = true;
                continue;
            }
            if (ends[i * 2] > 0) {
                current.deleteChars(0, ends[i * 2]);
                modified = true;
                int n = i * 2 + 1;
                ends[n] = ends[n] - ends[i * 2];
                extent -= ends[i * 2];
            }
            if (extent > maxLength) {
                current.deleteChars(maxLength + 1, extent);
                modified = true;
                continue;
            }
            if (extent >= maxLength) continue;
            current.insertCharAt(extent, maxLength - extent, this.gapCharacter);
            modified = true;
        }
        return modified;
    }

    @Override
    public HiddenSequences getHiddenSequences() {
        return this.hiddenSequences;
    }

    @Override
    public HiddenColumns getHiddenColumns() {
        return this.hiddenCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CigarArray getCompactAlignment() {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            CigarSimple[] alseqs = new SeqCigar[this.sequences.size()];
            int i = 0;
            for (SequenceI seq : this.sequences) {
                alseqs[i++] = new SeqCigar(seq);
            }
            CigarArray cal = new CigarArray(alseqs);
            cal.addOperation('M', this.getWidth());
            return cal;
        }
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (this.alignmentProperties == null) {
            this.alignmentProperties = new Hashtable();
        }
        this.alignmentProperties.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        if (this.alignmentProperties != null) {
            return this.alignmentProperties.get(key);
        }
        return null;
    }

    @Override
    public Hashtable getProperties() {
        return this.alignmentProperties;
    }

    @Override
    public void addCodonFrame(AlignedCodonFrame codons) {
        List<AlignedCodonFrame> acfs = this.getCodonFrames();
        if (codons != null && acfs != null && !acfs.contains(codons)) {
            acfs.add(codons);
        }
    }

    @Override
    public List<AlignedCodonFrame> getCodonFrame(SequenceI seq) {
        if (seq == null) {
            return null;
        }
        ArrayList<AlignedCodonFrame> cframes = new ArrayList<AlignedCodonFrame>();
        for (AlignedCodonFrame acf : this.getCodonFrames()) {
            if (!acf.involvesSequence(seq)) continue;
            cframes.add(acf);
        }
        return cframes;
    }

    @Override
    public void setCodonFrames(List<AlignedCodonFrame> acfs) {
        if (this.dataset != null) {
            this.dataset.setCodonFrames(acfs);
        } else {
            this.codonFrameList = acfs;
        }
    }

    @Override
    public List<AlignedCodonFrame> getCodonFrames() {
        return this.dataset != null ? this.dataset.getCodonFrames() : this.codonFrameList;
    }

    @Override
    public boolean removeCodonFrame(AlignedCodonFrame codons) {
        List<AlignedCodonFrame> acfs = this.getCodonFrames();
        if (codons == null || acfs == null) {
            return false;
        }
        return acfs.remove(codons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(AlignmentI toappend) {
        List<SequenceI> sqs;
        char oldc = toappend.getGapCharacter();
        boolean samegap = oldc == this.getGapCharacter();
        boolean hashidden = toappend.getHiddenSequences() != null && toappend.getHiddenSequences().hiddenSequences != null;
        List<SequenceI> list = sqs = hashidden ? toappend.getHiddenSequences().getFullAlignment().getSequences() : toappend.getSequences();
        if (sqs != null) {
            ArrayList<SequenceI> toappendsq = new ArrayList<SequenceI>();
            List<SequenceI> list2 = sqs;
            synchronized (list2) {
                for (SequenceI addedsq : sqs) {
                    if (!samegap) {
                        addedsq.replace(oldc, this.gapCharacter);
                    }
                    toappendsq.add(addedsq);
                }
            }
            for (SequenceI sequenceI : toappendsq) {
                this.addSequence(sequenceI);
            }
        }
        AlignmentAnnotation[] alan = toappend.getAlignmentAnnotation();
        for (int a = 0; alan != null && a < alan.length; ++a) {
            this.addAnnotation(alan[a]);
        }
        this.getCodonFrames().addAll(toappend.getCodonFrames());
        List<SequenceGroup> sg = toappend.getGroups();
        if (sg != null) {
            for (SequenceGroup _sg : sg) {
                this.addGroup(_sg);
            }
        }
        if (toappend.getHiddenSequences() != null) {
            HiddenSequences hiddenSequences = toappend.getHiddenSequences();
            if (this.hiddenSequences == null) {
                this.hiddenSequences = new HiddenSequences(this);
            }
            if (hiddenSequences.hiddenSequences != null) {
                for (int s = 0; s < hiddenSequences.hiddenSequences.length; ++s) {
                    if (hiddenSequences.hiddenSequences[s] == null) continue;
                    this.hiddenSequences.hideSequence(hiddenSequences.hiddenSequences[s]);
                }
            }
        }
        if (toappend.getProperties() != null) {
            Enumeration enumeration = toappend.getProperties().keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object ourval = this.getProperty(k);
                Object toapprop = toappend.getProperty(k);
                if (ourval != null) {
                    if (!ourval.getClass().equals(toapprop.getClass()) || ourval.equals(toapprop)) continue;
                    if (ourval instanceof String) {
                        this.setProperty(k, (String)ourval + "; " + (String)toapprop);
                        continue;
                    }
                    if (!(ourval instanceof Vector)) continue;
                    Enumeration theirv = ((Vector)toapprop).elements();
                    while (theirv.hasMoreElements()) {
                        ((Vector)ourval).addElement(theirv);
                    }
                    continue;
                }
                this.setProperty(k, toapprop);
            }
        }
    }

    @Override
    public AlignmentAnnotation findOrCreateAnnotation(String name, String calcId, boolean autoCalc, SequenceI seqRef, SequenceGroup groupRef) {
        AlignmentAnnotation annot;
        AlignmentAnnotation alignmentAnnotation = annot = this.annotations == null ? null : AlignmentAnnotation.findFirstAnnotation(Arrays.asList(this.getAlignmentAnnotation()), name, calcId, autoCalc, seqRef, groupRef);
        if (annot == null) {
            annot = new AlignmentAnnotation(name, name, new Annotation[1], 0.0f, 0.0f, 1);
            annot.hasText = false;
            if (calcId != null) {
                annot.setCalcId(calcId);
            }
            annot.autoCalculated = autoCalc;
            if (seqRef != null) {
                annot.setSequenceRef(seqRef);
            }
            annot.groupRef = groupRef;
            this.addAnnotation(annot);
        }
        return annot;
    }

    @Override
    public AlignmentAnnotation updateFromOrCopyAnnotation(AlignmentAnnotation ala) {
        AlignmentAnnotation annot = AlignmentAnnotation.findFirstAnnotation(Arrays.asList(this.getAlignmentAnnotation()), ala.label, ala.calcId, ala.autoCalculated, ala.sequenceRef, ala.groupRef);
        if (annot == null) {
            annot = new AlignmentAnnotation(ala);
            this.addAnnotation(annot);
        } else {
            annot.updateAlignmentAnnotationFrom(ala);
        }
        this.validateAnnotation(annot);
        return annot;
    }

    @Override
    public Iterable<AlignmentAnnotation> findAnnotation(String calcId) {
        AlignmentAnnotation[] alignmentAnnotation = this.getAlignmentAnnotation();
        if (alignmentAnnotation != null) {
            return AlignmentAnnotation.findAnnotation(Arrays.asList(this.getAlignmentAnnotation()), calcId);
        }
        return Arrays.asList(new AlignmentAnnotation[0]);
    }

    @Override
    public Iterable<AlignmentAnnotation> findAnnotations(SequenceI seq, String calcId, String label) {
        return this.annotations == null ? null : AlignmentAnnotation.findAnnotations(Arrays.asList(this.getAlignmentAnnotation()), seq, calcId, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveSelectedSequencesByOne(SequenceGroup sg, Map<SequenceI, SequenceCollectionI> map, boolean up) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (up) {
                int iSize = this.sequences.size();
                for (int i = 1; i < iSize; ++i) {
                    SequenceI seq = this.sequences.get(i);
                    if (!sg.getSequences(map).contains(seq)) continue;
                    SequenceI temp = this.sequences.get(i - 1);
                    if (sg.getSequences(null).contains(temp)) continue;
                    this.sequences.set(i, temp);
                    this.sequences.set(i - 1, seq);
                }
            } else {
                for (int i = this.sequences.size() - 2; i > -1; --i) {
                    SequenceI seq = this.sequences.get(i);
                    if (!sg.getSequences(map).contains(seq)) continue;
                    SequenceI temp = this.sequences.get(i + 1);
                    if (sg.getSequences(map).contains(temp)) continue;
                    this.sequences.set(i, temp);
                    this.sequences.set(i + 1, seq);
                }
            }
        }
    }

    @Override
    public void validateAnnotation(AlignmentAnnotation alignmentAnnotation) {
        alignmentAnnotation.validateRangeAndDisplay();
        if (this.isNucleotide() && alignmentAnnotation.isValidStruc()) {
            this.hasRNAStructure = true;
        }
    }

    @Override
    public SequenceI getSeqrep() {
        return this.seqrep;
    }

    @Override
    public void setSeqrep(SequenceI seqrep) {
        this.seqrep = seqrep;
    }

    @Override
    public boolean hasSeqrep() {
        return this.seqrep != null;
    }

    @Override
    public int getEndRes() {
        return this.getWidth() - 1;
    }

    @Override
    public int getStartRes() {
        return 0;
    }

    @Override
    public AnnotatedCollectionI getContext() {
        return this.dataset;
    }

    @Override
    public int alignAs(AlignmentI al) {
        return this.alignAs(al, false, true);
    }

    public int alignAs(AlignmentI al, boolean preserveMappedGaps, boolean preserveUnmappedGaps) {
        boolean thatIsProtein;
        boolean thisIsNucleotide = this.isNucleotide();
        boolean bl = thatIsProtein = !al.isNucleotide();
        if (!thatIsProtein && !thisIsNucleotide) {
            return AlignmentUtils.alignProteinAsDna(this, al);
        }
        if (thatIsProtein && thisIsNucleotide) {
            return AlignmentUtils.alignCdsAsProtein(this, al);
        }
        return AlignmentUtils.alignAs(this, al);
    }

    public String toString() {
        return new FastaFile().print(this.getSequencesArray(), true);
    }

    @Override
    public Set<String> getSequenceNames() {
        HashSet<String> names = new HashSet<String>();
        for (SequenceI seq : this.getSequences()) {
            names.add(seq.getName());
        }
        return names;
    }

    @Override
    public boolean hasValidSequence() {
        boolean hasValidSeq = false;
        for (SequenceI seq : this.getSequences()) {
            if (seq.getEnd() - seq.getStart() <= 0) continue;
            hasValidSeq = true;
            break;
        }
        return hasValidSeq;
    }

    @Override
    public int realiseMappings(List<SequenceI> seqs) {
        int count = 0;
        for (SequenceI seq : seqs) {
            for (AlignedCodonFrame mapping : this.getCodonFrames()) {
                count += mapping.realiseWith(seq);
            }
        }
        return count;
    }

    @Override
    public AlignedCodonFrame getMapping(SequenceI mapFrom, SequenceI mapTo) {
        for (AlignedCodonFrame acf : this.getCodonFrames()) {
            if (acf.getAaForDnaSeq(mapFrom) != mapTo) continue;
            return acf;
        }
        return null;
    }

    @Override
    public boolean setHiddenColumns(HiddenColumns cols) {
        boolean changed = cols == null ? this.hiddenCols != null : !cols.equals(this.hiddenCols);
        this.hiddenCols = cols;
        return changed;
    }

    @Override
    public void setupJPredAlignment() {
        SequenceI repseq = this.getSequenceAt(0);
        this.setSeqrep(repseq);
        HiddenColumns cs = new HiddenColumns();
        cs.hideList(repseq.getInsertions());
        this.setHiddenColumns(cs);
    }

    @Override
    public HiddenColumns propagateInsertions(SequenceI profileseq, AlignmentView input) {
        int profsqpos = 0;
        char gc = this.getGapCharacter();
        Object[] alandhidden = input.getAlignmentAndHiddenColumns(gc);
        HiddenColumns nview = (HiddenColumns)alandhidden[1];
        SequenceI origseq = ((SequenceI[])alandhidden[0])[profsqpos];
        return this.propagateInsertions(profileseq, origseq, nview);
    }

    private HiddenColumns propagateInsertions(SequenceI profileseq, SequenceI origseq, HiddenColumns hc) {
        BitSet gaps = origseq.gapBitset();
        hc.andNot(gaps);
        HiddenColumns newhidden = new HiddenColumns();
        int numGapsBefore = 0;
        int gapPosition = 0;
        Iterator<int[]> it = hc.iterator();
        while (it.hasNext()) {
            int[] region = it.next();
            while (gapPosition < region[0]) {
                if (!gaps.get(++gapPosition)) continue;
                ++numGapsBefore;
            }
            int left = region[0] - numGapsBefore;
            int right = region[1] - numGapsBefore;
            newhidden.hideColumns(left, right);
            this.padGaps(left, right, profileseq);
        }
        return newhidden;
    }

    private void padGaps(int left, int right, SequenceI profileseq) {
        char gc = this.getGapCharacter();
        StringBuilder sb = new StringBuilder();
        for (int g = 0; g < right - left + 1; ++g) {
            sb.append(gc);
        }
        int ns = this.getHeight();
        for (int s = 0; s < ns; ++s) {
            SequenceI sqobj = this.getSequenceAt(s);
            if (sqobj == profileseq || sqobj.getLength() < left) continue;
            String sq = sqobj.getSequenceAsString();
            sqobj.setSequence(sq.substring(0, left) + sb.toString() + sq.substring(left));
        }
    }

    @Override
    public Collection<ContactMatrixI> getContactMaps() {
        return this.cmholder.getContactMaps();
    }

    @Override
    public ContactMatrixI getContactMatrixFor(AlignmentAnnotation _aa) {
        ContactMatrixI cm = this.cmholder.getContactMatrixFor(_aa);
        if (cm == null && _aa.groupRef != null) {
            cm = _aa.groupRef.getContactMatrixFor(_aa);
        }
        if (cm == null && _aa.sequenceRef != null && (cm = _aa.sequenceRef.getContactMatrixFor(_aa)) == null && _aa.sequenceRef.getDatasetSequence() != null) {
            cm = _aa.sequenceRef.getDatasetSequence().getContactMatrixFor(_aa);
        }
        return cm;
    }

    @Override
    public ContactListI getContactListFor(AlignmentAnnotation _aa, int column) {
        int spos;
        if (_aa.annotations == null || column >= _aa.annotations.length || column < 0) {
            return null;
        }
        ContactListI cl = this.cmholder.getContactListFor(_aa, column);
        if (cl == null && _aa.groupRef != null) {
            cl = _aa.groupRef.getContactListFor(_aa, column);
        }
        if (cl == null && _aa.sequenceRef != null && _aa.annotations[column] != null && (cl = _aa.sequenceRef.getContactListFor(_aa, column)) == null && _aa.sequenceRef.getDatasetSequence() != null && (spos = _aa.sequenceRef.findPosition(column)) >= _aa.sequenceRef.getStart() && spos <= 1 + _aa.sequenceRef.getEnd()) {
            cl = _aa.sequenceRef.getDatasetSequence().getContactListFor(_aa, spos - _aa.sequenceRef.getStart());
        }
        return cl;
    }

    @Override
    public AlignmentAnnotation addContactList(ContactMatrixI cm) {
        AlignmentAnnotation aa = this.cmholder.addContactList(cm);
        Annotation[] _aa = new Annotation[this.getWidth()];
        int i = 0;
        while (i < _aa.length) {
            _aa[i++] = new Annotation(0.0f);
        }
        aa.annotations = _aa;
        this.addAnnotation(aa);
        return aa;
    }

    @Override
    public void addContactListFor(AlignmentAnnotation annotation, ContactMatrixI cm) {
        this.cmholder.addContactListFor(annotation, cm);
    }

    @Override
    public boolean isSecondaryStructurePresent() {
        if (this.annotations == null || this.annotations.length == 0) {
            return false;
        }
        boolean hasSeqRef = false;
        for (int a = 0; !hasSeqRef && a < this.annotations.length; ++a) {
            if (this.annotations[a] == null || this.annotations[a].sequenceRef == null) continue;
            hasSeqRef = true;
        }
        return hasSeqRef && AlignmentUtils.isSecondaryStructurePresent(this.annotations);
    }

    @Override
    public List<SequenceI> getHmmSequences() {
        ArrayList<SequenceI> result = new ArrayList<SequenceI>();
        for (int i = 0; i < this.sequences.size(); ++i) {
            SequenceI seq = this.sequences.get(i);
            if (!seq.hasHMMProfile()) continue;
            result.add(seq);
        }
        return result;
    }
}

