/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.bin.argparser.ArgValue;
import jalview.bin.argparser.ArgValues;
import jalview.bin.argparser.SubVals;
import jalview.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ArgValuesMap {
    private List<ArgInfo> argInfoList = new ArrayList<ArgInfo>();
    protected Map<Arg, ArgValues> m;
    private String linkedId;

    protected ArgValuesMap(String linkedId) {
        this.linkedId = linkedId;
        this.newMap();
    }

    protected ArgValuesMap(String linkedId, Map<Arg, ArgValues> map) {
        this.linkedId = linkedId;
        this.m = map;
    }

    public String getLinkedId() {
        return this.linkedId;
    }

    private Map<Arg, ArgValues> getMap() {
        return this.m;
    }

    private void newMap() {
        this.m = new HashMap<Arg, ArgValues>();
    }

    private void newArg(Arg a) {
        if (this.m == null) {
            this.newMap();
        }
        if (!this.containsArg(a)) {
            this.m.put(a, new ArgValues(a, this));
        }
    }

    public ArgValues getArgValues(Arg a) {
        return this.m == null ? null : this.m.get((Object)a);
    }

    public ArgValues getOrCreateArgValues(Arg a) {
        ArgValues avs = this.m.get((Object)a);
        if (avs == null) {
            this.newArg(a);
        }
        return this.getArgValues(a);
    }

    public List<ArgValue> getArgValueList(Arg a) {
        ArgValues avs = this.getArgValues(a);
        return avs == null ? new ArrayList() : avs.getArgValueList();
    }

    public List<ArgValue> getArgValueListFromSubValOrArg(ArgValue av, Arg a, SubVals sv) {
        return this.getArgValueListFromSubValArgOrPrefWithSubstitutionsWithinTypes(null, a, Position.AFTER, av, sv, null, null, null, true, null);
    }

    public List<ArgValue> getArgValueListFromSubValArgOrPrefWithSubstitutionsWithinTypes(ArgParser ap, Arg a, Position pos, ArgValue av, SubVals sv, String key, String pref, String def, boolean withinTypes, Arg.Type type) {
        if (key == null) {
            key = a.getName();
        }
        HashSet<Arg.Type> types = new HashSet<Arg.Type>();
        if (type == null) {
            types.addAll(Arrays.asList(av.getArg().getTypes()));
        } else {
            types.add(type);
        }
        ArrayList<ArgValue> avList = new ArrayList<ArgValue>();
        if (sv != null && sv.has(key) && sv.get(key) != null) {
            Iterator<ArgValue> value = ap == null ? sv.get(key) : sv.getWithSubstitutions(ap, this.getLinkedId(), key);
            ArgValue argValue = new ArgValue(a, null, null, (String)((Object)value), av.getArgIndex(), false, null, this.getLinkedId());
            avList.add(argValue);
        } else if (this.containsArg(a)) {
            if (pos == Position.FIRST && this.getValue(a) != null) {
                avList.add(this.getArgValue(a));
            } else if (pos == Position.BEFORE && this.getClosestPreviousArgValueOfArg(av, a) != null) {
                for (ArgValue argValue : this.getArgValues(a).getArgValueList()) {
                    if (argValue.getArgIndex() >= av.getArgIndex()) continue;
                    avList.add(argValue);
                }
            } else if (pos == Position.AFTER && this.getClosestNextArgValueOfArg(av, a, withinTypes) != null) {
                for (ArgValue argValue : this.getArgValues(a).getArgValueList()) {
                    if (argValue.getArgIndex() <= av.getArgIndex()) continue;
                    avList.add(argValue);
                }
            }
        }
        if (withinTypes && !avList.isEmpty()) {
            int nextPrimaryArgOfSameTypeIndex = Integer.MAX_VALUE;
            for (Arg tmpA : this.getArgKeys()) {
                if (!tmpA.hasType(types) || !tmpA.hasOption(Arg.Opt.PRIMARY)) continue;
                for (ArgValue tmpAv : this.getArgValueList(tmpA)) {
                    int tmpArgIndex = tmpAv.getArgIndex();
                    if (tmpArgIndex <= av.getArgIndex() || tmpArgIndex >= nextPrimaryArgOfSameTypeIndex) continue;
                    nextPrimaryArgOfSameTypeIndex = tmpArgIndex;
                }
            }
            ArrayList<ArgValue> arrayList = new ArrayList<ArgValue>();
            for (ArgValue tmpAv : avList) {
                int tmpAvIndex = tmpAv.getArgIndex();
                if (av.getArgIndex() >= tmpAvIndex || tmpAvIndex >= nextPrimaryArgOfSameTypeIndex) continue;
                arrayList.add(tmpAv);
            }
            avList = arrayList;
        }
        return avList;
    }

    public ArgValue getArgValue(Arg a) {
        List<ArgValue> vals = this.getArgValueList(a);
        return vals == null || vals.size() == 0 ? null : vals.get(0);
    }

    public String getValue(Arg a) {
        ArgValue av = this.getArgValue(a);
        return av == null ? null : av.getValue();
    }

    public List<String> getValues(Arg a) {
        return ArgValuesMap.toValues(this.getArgValueList(a));
    }

    public static List<String> toValues(List<ArgValue> avl) {
        if (avl == null) {
            return null;
        }
        ArrayList<String> vl = new ArrayList<String>();
        for (ArgValue av : avl) {
            vl.add(av.getValue());
        }
        return vl;
    }

    public boolean containsArg(Arg a) {
        if (this.m == null || !this.m.containsKey((Object)a)) {
            return false;
        }
        return a.hasOption(Arg.Opt.STRING) ? this.getArgValue(a) != null : true;
    }

    public boolean hasValue(Arg a, String val) {
        if (this.m == null || !this.m.containsKey((Object)a)) {
            return false;
        }
        for (ArgValue av : this.getArgValueList(a)) {
            String avVal = av.getValue();
            if ((val != null || avVal != null) && (val == null || !val.equals(avVal))) continue;
            return true;
        }
        return false;
    }

    public boolean getBoolean(Arg a) {
        ArgValues av = this.getArgValues(a);
        return av == null ? false : av.getBoolean();
    }

    public Set<Arg> getArgKeys() {
        return this.m.keySet();
    }

    public ArgValue getArgValueOfArgWithSubValKey(Arg a, String svKey) {
        return this.getArgValueOfArgWithSubValKey(a, svKey, false);
    }

    public ArgValue getArgValueOfArgWithSubValKey(Arg a, String svKey, boolean last) {
        ArgValues avs = this.getArgValues(a);
        if (avs == null) {
            return null;
        }
        List<ArgValue> compareAvs = avs.getArgValueList();
        for (int i = 0; i < compareAvs.size(); ++i) {
            int index = last ? compareAvs.size() - 1 - i : i;
            ArgValue av = compareAvs.get(index);
            SubVals sv = av.getSubVals();
            if (!sv.has(svKey) || sv.get(svKey).equals("false")) continue;
            return av;
        }
        return null;
    }

    public ArgValue getClosestPreviousArgValueOfArg(ArgValue thisAv, Arg a) {
        ArgValue closestAv = null;
        int thisArgIndex = thisAv.getArgIndex();
        ArgValues compareAvs = this.getArgValues(a);
        int closestPreviousIndex = -1;
        for (ArgValue av : compareAvs.getArgValueList()) {
            int argIndex = av.getArgIndex();
            if (argIndex >= thisArgIndex || argIndex <= closestPreviousIndex) continue;
            closestPreviousIndex = argIndex;
            closestAv = av;
        }
        return closestAv;
    }

    public ArgValue getClosestNextArgValueOfArg(ArgValue thisAv, Arg a, boolean withinTypes) {
        ArgValue closestAv = null;
        int thisArgIndex = thisAv.getArgIndex();
        if (!this.containsArg(a)) {
            return null;
        }
        ArgValues compareAvs = this.getArgValues(a);
        int closestNextIndex = Integer.MAX_VALUE;
        for (ArgValue av : compareAvs.getArgValueList()) {
            int argIndex = av.getArgIndex();
            if (argIndex <= thisArgIndex || argIndex >= closestNextIndex) continue;
            closestNextIndex = argIndex;
            closestAv = av;
        }
        if (withinTypes && closestAv != null) {
            int nextPrimaryArgOfSameTypeIndex = Integer.MAX_VALUE;
            for (Arg tmpA : this.getArgKeys()) {
                if (!tmpA.sharesType(a) || !tmpA.hasOption(Arg.Opt.PRIMARY)) continue;
                for (ArgValue tmpAv : this.getArgValueList(tmpA)) {
                    int tmpArgIndex = tmpAv.getArgIndex();
                    if (tmpArgIndex <= thisArgIndex || tmpArgIndex >= nextPrimaryArgOfSameTypeIndex) continue;
                    nextPrimaryArgOfSameTypeIndex = tmpArgIndex;
                }
            }
            if (nextPrimaryArgOfSameTypeIndex < closestAv.getArgIndex()) {
                return null;
            }
        }
        return closestAv;
    }

    public ArgValue[] getArgValuesReferringTo(String key, String value, Arg a) {
        Arg[] args;
        Arg[] argArray;
        ArrayList avList = new ArrayList();
        if (a == null) {
            argArray = (Arg[])this.getMap().keySet().toArray();
        } else {
            Arg[] argArray2 = new Arg[1];
            argArray = argArray2;
            argArray2[0] = a;
        }
        for (Arg keyArg : args = argArray) {
            for (ArgValue argValue : this.getArgValueList(keyArg)) {
            }
        }
        return (ArgValue[])avList.toArray();
    }

    public boolean hasId(Arg a, String id) {
        ArgValues avs = this.getArgValues(a);
        return avs == null ? false : avs.hasId(id);
    }

    public ArgValue getId(Arg a, String id) {
        ArgValues avs = this.getArgValues(a);
        return avs == null ? null : avs.getId(id);
    }

    public String getBasename() {
        return this.getDirBasenameOrExtension(false, false, false);
    }

    public String getExtension() {
        return this.getDirBasenameOrExtension(false, true, false);
    }

    public String getDirname() {
        return this.getDirBasenameOrExtension(true, false, false);
    }

    public String getDirBasenameOrExtension(boolean dirname, boolean extension, boolean absoluteDirname) {
        String filename = null;
        String appendVal = this.getValue(Arg.APPEND);
        String openVal = this.getValue(Arg.OPEN);
        if (appendVal != null) {
            filename = appendVal;
        }
        if (filename == null && openVal != null) {
            filename = openVal;
        }
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (dirname) {
            return FileUtils.getDirname(file);
        }
        return extension ? FileUtils.getExtension(file) : FileUtils.getBasename(file);
    }

    public boolean hasArgWithOption(Arg.Opt o) {
        for (Arg a : this.getArgKeys()) {
            if (!a.hasOption(o)) continue;
            return true;
        }
        return false;
    }

    public void addArgInfo(Arg arg, String value, SubVals subVals, int argIndex) {
        this.argInfoList.add(new ArgInfo(arg, value, subVals, argIndex));
    }

    public List<ArgInfo> getArgInfoList() {
        Collections.sort(this.argInfoList);
        return this.argInfoList;
    }

    public List<String> getValuesFromSubValOrArgs(ArgParser ap, Arg a, SubVals sv) {
        ArrayList<String> vals = new ArrayList<String>();
        String key = a.getName();
        if (sv != null && sv.has(key) && sv.get(key) != null) {
            String value;
            String string = value = ap == null ? sv.get(key) : sv.getWithSubstitutions(ap, this.getLinkedId(), key);
            if (value != null) {
                vals.add(value);
            }
        }
        vals.addAll(this.getValues(a));
        return vals;
    }

    public String getValueFromSubValOrArg(ArgValue av, Arg a, SubVals sv) {
        return this.getFromSubValArgOrPref(av, a, sv, null, null, null);
    }

    public String getFromSubValArgOrPref(ArgValue av, Arg a, SubVals sv, String key, String pref, String def) {
        return this.getFromSubValArgOrPref(a, Position.AFTER, av, sv, key, pref, def);
    }

    public String getFromSubValArgOrPref(Arg a, Position pos, ArgValue av, SubVals sv, String key, String pref, String def) {
        return this.getFromSubValArgOrPrefWithSubstitutions(null, a, pos, av, sv, key, pref, def);
    }

    public String getFromSubValArgOrPrefWithSubstitutions(ArgParser ap, Arg a, Position pos, ArgValue av, SubVals sv, String key, String pref, String def) {
        return this.getFromSubValArgOrPrefWithSubstitutionsWithinTypes(ap, a, pos, av, sv, key, pref, def, true);
    }

    public String getFromSubValArgOrPrefWithSubstitutionsWithinTypes(ArgParser ap, Arg a, Position pos, ArgValue av, SubVals sv, String key, String pref, String def, boolean withinTypes) {
        if (key == null) {
            key = a.getName();
        }
        String value = null;
        if (sv != null && sv.has(key) && sv.get(key) != null) {
            value = ap == null ? sv.get(key) : sv.getWithSubstitutions(ap, this.getLinkedId(), key);
        } else if (this.containsArg(a)) {
            ArgValue av2;
            if (pos == Position.FIRST && this.getValue(a) != null) {
                value = this.getValue(a);
            } else if (pos == Position.BEFORE && this.getClosestPreviousArgValueOfArg(av, a) != null) {
                value = this.getClosestPreviousArgValueOfArg(av, a).getValue();
            } else if (pos == Position.AFTER && this.getClosestNextArgValueOfArg(av, a, withinTypes) != null) {
                value = this.getClosestNextArgValueOfArg(av, a, withinTypes).getValue();
            }
            Arg arg = av.getArg();
            if (value == null && arg.hasOption(Arg.Opt.PRIMARY) && arg.hasType(Arg.Type.STRUCTURE) && !a.hasOption(Arg.Opt.PRIMARY) && a.getFirstType() == Arg.Type.STRUCTURE && (av2 = this.getArgValueOfArgWithSubValKey(a, Arg.ALLSTRUCTURES.getName())) != null) {
                value = av2.getValue();
            }
            if (value == null) {
                for (ArgValue tmpAv : this.getArgValueList(a)) {
                    if (!tmpAv.setByWildcardLinkedId()) continue;
                    value = tmpAv.getValue();
                }
            }
        }
        if (value == null) {
            value = pref != null ? Cache.getDefault(pref, def) : def;
        }
        return value;
    }

    public boolean getBoolFromSubVal(Arg a, SubVals sv, boolean def) {
        return this.getFromSubValArgOrPref(a, sv, null, null, def);
    }

    public boolean getBoolFromSubValOrArg(Arg a, SubVals sv) {
        return this.getFromSubValArgOrPref(a, sv, null, null, false);
    }

    public boolean getFromSubValArgOrPref(Arg a, SubVals sv, String key, String pref, boolean def) {
        return this.getFromSubValArgOrPref(a, sv, key, pref, def, false);
    }

    public boolean getFromSubValArgOrPref(Arg a, SubVals sv, String key, String pref, boolean def, boolean invertPref) {
        boolean prefVal;
        if (key == null && a == null || sv == null && a == null) {
            return false;
        }
        boolean usingArgKey = false;
        if (key == null) {
            key = a.getName();
            usingArgKey = true;
        }
        String nokey = "no" + key;
        if (sv != null) {
            if (sv.has(key) && sv.get(key) != null) {
                if (usingArgKey && !a.hasOption(Arg.Opt.BOOLEAN) && !a.hasOption(Arg.Opt.UNARY)) {
                    Console.debug("Looking for boolean in subval from non-boolean/non-unary Arg " + a.getName());
                    return false;
                }
                return sv.get(key).toLowerCase(Locale.ROOT).equals("true");
            }
            if (sv.has(nokey) && sv.get(nokey) != null) {
                if (usingArgKey && !a.hasOption(Arg.Opt.BOOLEAN)) {
                    Console.debug("Looking for negative boolean in subval from non-boolean Arg " + a.getName());
                    return false;
                }
                return !sv.get(nokey).toLowerCase(Locale.ROOT).equals("true");
            }
        }
        if (this.containsArg(a)) {
            return this.getBoolean(a);
        }
        boolean bl = prefVal = pref != null ? Cache.getDefault(pref, def) : false;
        return pref != null ? (invertPref ? !prefVal : prefVal) : def;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Arg a : this.getArgKeys()) {
            sb.append(a.argString());
            sb.append(":\n");
            for (ArgValue av : this.getArgValueList(a)) {
                sb.append("  ");
                sb.append(av.getValue());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static enum Position {
        FIRST,
        BEFORE,
        AFTER;

    }

    public class ArgInfo
    implements Comparable<ArgInfo> {
        private Arg arg;
        private String value;
        private SubVals subVals;
        private int argIndex;

        public ArgInfo(Arg arg, String value, SubVals subVals, int argIndex) {
            this.arg = arg;
            this.value = value;
            this.subVals = subVals;
            this.argIndex = argIndex;
        }

        public Arg arg() {
            return this.arg;
        }

        public String value() {
            return this.value;
        }

        public SubVals subVals() {
            return this.subVals;
        }

        public int argIndex() {
            return this.argIndex;
        }

        @Override
        public int compareTo(ArgInfo ai2) {
            return Integer.compare(this.argIndex(), ai2.argIndex());
        }
    }
}

