/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.analysis.SequenceIdMatcher;
import jalview.api.JalviewJSApi;
import jalview.api.StructureSelectionManagerProvider;
import jalview.bin.ArgsParser;
import jalview.bin.Jalview;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.CalculationChooser;
import jalview.gui.Desktop;
import jalview.gui.StructureViewer;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.io.NewickFile;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.StructureSelectionManager;
import jalview.util.HttpUtils;
import jalview.util.Platform;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class JalviewJSApp
implements JalviewJSApi {
    private ArgsParser aparser;
    private String[] ret = new String[1];
    private String separator = "\u00ac";
    private Jalview jalview;

    public JalviewJSApp(Jalview jalview, ArgsParser aparser) {
        Platform.setAppClass(this);
        this.jalview = jalview;
        this.aparser = aparser;
    }

    @Override
    public boolean addPdbFile(String sequenceId, String pdbId, String pdbFile, AlignFrame alf) {
        SequenceI seq;
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        if ((seq = alf.getViewport().getAlignment().findName(sequenceId)) != null) {
            Vector<PDBEntry> pdbe = seq.getAllPDBEntries();
            PDBEntry pdbentry = null;
            if (pdbe != null && pdbe.size() > 0) {
                int peSize = pdbe.size();
                for (int pe = 0; pe < peSize; ++pe) {
                    pdbentry = pdbe.elementAt(pe);
                    if (pdbentry.getId().equals(pdbId) && (pdbFile == null || pdbentry.getFile().equals(pdbFile))) continue;
                    pdbentry = null;
                }
            }
            if (pdbentry == null) {
                pdbentry = new PDBEntry(pdbId, null, pdbFile);
                if (pdbFile != null) {
                    DataSourceType protocol = AppletFormatAdapter.resolveProtocol(pdbFile, FileFormat.PDB);
                    if (protocol == null) {
                        return false;
                    }
                    pdbentry.setProperty("protocol", (Object)protocol);
                }
                seq.addPDBId(pdbentry);
                alf.alignPanel.getStructureSelectionManager().registerPDBEntry(pdbentry);
            }
        }
        return true;
    }

    @Override
    public String getAlignment(String format, boolean addSuffix, AlignFrame alf) {
        try {
            if (alf == null) {
                alf = this.getCurrentAlignFrame();
            }
            FileFormatI theFormat = FileFormats.getInstance().forName(format);
            String reply = new AppletFormatAdapter().formatSequences(theFormat, alf.getViewport().getAlignment(), addSuffix);
            return reply;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return "Error retrieving alignment, possibly invalid format specifier: " + format;
        }
    }

    @Override
    public String[] getAlignmentOrder(AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        AlignmentI alorder = alf.getViewport().getAlignment();
        String[] order = new String[alorder.getHeight()];
        for (int i = 0; i < order.length; ++i) {
            order[i] = alorder.getSequenceAt(i).getName();
        }
        return order;
    }

    @Override
    public String getAnnotation(AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        String annotation = new AnnotationFile().printAnnotationsForView(alf.getViewport());
        return annotation;
    }

    @Override
    public URL getCodeBase() {
        return Platform.getCodeBase();
    }

    @Override
    public AlignFrame getCurrentAlignFrame() {
        return this.jalview.currentAlignFrame;
    }

    @Override
    public URL getDocumentBase() {
        return Platform.getDocumentBase();
    }

    @Override
    public String[] getFeatureGroups(AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        return alf.getFeatureGroups();
    }

    @Override
    public String[] getFeatureGroupsOfState(boolean visible, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        return alf.getFeatureGroupsOfState(visible);
    }

    @Override
    public String getFeatures(String format, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        FeaturesFile formatter = new FeaturesFile();
        if (((String)(format = ((String)format).toLowerCase())).indexOf(";") < 0) {
            format = (String)format + ";includenonpositional";
        }
        boolean nonpos = ((String)format).indexOf(";includenonpositional") >= 0;
        boolean compl = ((String)format).indexOf(";includecomplement") >= 0;
        String features = ((String)format).startsWith("jalview") ? formatter.printJalviewFormat(alf.getViewport().getAlignment().getSequencesArray(), alf.alignPanel.getFeatureRenderer(), nonpos, compl) : formatter.printGffFormat(alf.getViewport().getAlignment().getSequencesArray(), alf.alignPanel.getFeatureRenderer(), nonpos, compl);
        if (features == null) {
            features = "";
        }
        return features;
    }

    @Override
    public String getParameter(String name) {
        return (String)this.aparser.getAppletValue(name, null, true);
    }

    @Override
    public Object getParameterAsObject(String name) {
        return this.aparser.getAppletValue(name, null, false);
    }

    public String getPastedSequence(JalviewJSApp jalviewApp) {
        StringBuffer data = new StringBuffer("PASTE");
        int i = 1;
        String file = null;
        while ((file = this.getParameter("sequence" + i)) != null) {
            data.append(file.toString() + "\n");
            ++i;
        }
        if (data.length() > 5) {
            file = data.toString();
        }
        return file;
    }

    @Override
    public SequenceI[] getSelectedSequences(AlignFrame alf) {
        AlignViewport v;
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        if ((v = alf.getViewport()).getSelectionGroup() != null) {
            return v.getSelectionGroup().getSequencesInOrder(v.getAlignment());
        }
        return null;
    }

    @Override
    public String getSelectedSequencesAsAlignment(String format, boolean addSuffix, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        try {
            AlignViewport vp = alf.getViewport();
            FileFormatI theFormat = FileFormats.getInstance().forName(format);
            if (vp.getSelectionGroup() != null) {
                String reply = new AppletFormatAdapter().formatSequences(theFormat, new Alignment(vp.getSelectionAsNewSequence()), addSuffix);
                return reply;
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return "Error retrieving alignment, possibly invalid format specifier: " + format;
        }
        return "";
    }

    @Override
    public void highlight(String sequenceId, String position, String alignedPosition, AlignFrame alf) {
        SequenceIdMatcher matcher;
        SequenceI sq;
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        if ((sq = (matcher = new SequenceIdMatcher(alf.getViewport().getAlignment().getSequencesArray())).findIdMatch(sequenceId)) != null) {
            int apos = -1;
            try {
                apos = Integer.valueOf(position);
            }
            catch (NumberFormatException ex) {
                return;
            }
            final int pos = --apos;
            if (alignedPosition != null && (alignedPosition.trim().length() == 0 || alignedPosition.toLowerCase().indexOf("false") > -1)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance()).mouseOverVamsasSequence(sq, sq.findIndex(pos), null);
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance()).mouseOverVamsasSequence(sq, pos, null);
                    }
                });
            }
        }
    }

    @Override
    public AlignFrame loadAlignment(String text, String title, int width, int height) {
        AlignmentI al = null;
        try {
            FileFormatI format = new IdentifyFile().identify(text, DataSourceType.PASTE);
            al = new AppletFormatAdapter().readFile(text, DataSourceType.PASTE, format);
            if (al.getHeight() > 0) {
                return new AlignFrame(al, width > 0 ? width : 700, height > 0 ? height : 500, title);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void loadAnnotation(String annotation, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        if (new AnnotationFile().annotateAlignmentView(alf.getViewport(), annotation, DataSourceType.PASTE)) {
            alf.alignPanel.fontChanged();
            alf.alignPanel.setScrollValues(0, 0);
        } else {
            alf.parseFeaturesFile(annotation, DataSourceType.PASTE);
        }
    }

    @Override
    public boolean loadFeatures(String features, boolean autoenabledisplay, AlignFrame alf) {
        boolean ret;
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        if (!(ret = alf.parseFeaturesFile(features, DataSourceType.PASTE))) {
            return false;
        }
        if (autoenabledisplay) {
            alf.getViewport().setShowSequenceFeatures(true);
        }
        return true;
    }

    @Override
    public boolean loadScoreFile(String fileName, AlignFrame alf) {
        try {
            (alf == null ? this.getCurrentAlignFrame() : alf).loadJalviewDataFile(fileName, null, null, null);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public Object openPcaPanel(String modelName, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        return CalculationChooser.openPcaPanel(alf, modelName, null);
    }

    @Override
    public Object openTreePanel(String treeType, String modelName, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        return CalculationChooser.openTreePanel(alf, treeType, modelName, null);
    }

    @Override
    public boolean orderAlignment(String[] ids, String undoName, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        SequenceI[] sqs = null;
        if (ids != null && ids.length > 0) {
            SequenceIdMatcher matcher = new SequenceIdMatcher(alf.getViewport().getAlignment().getSequencesArray());
            int s = 0;
            sqs = new SequenceI[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                SequenceI sq;
                if (ids[i].trim().length() == 0 || (sq = matcher.findIdMatch(ids[i])) == null) continue;
                sqs[s++] = sq;
            }
            if (s > 0) {
                SequenceI[] sqq = new SequenceI[s];
                System.arraycopy(sqs, 0, sqq, 0, s);
                sqs = sqq;
            } else {
                sqs = null;
            }
        }
        if (sqs == null) {
            return false;
        }
        AlignmentOrder aorder = new AlignmentOrder(sqs);
        if (undoName != null && undoName.trim().length() == 0) {
            undoName = null;
        }
        String _undoName = undoName;
        return alf.sortBy(aorder, _undoName);
    }

    @Override
    public Object parseArguments(String[] args) {
        try {
            this.jalview.parseArguments(new ArgsParser(args), false);
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    @Override
    public boolean parseFeaturesFile(String filename, AlignFrame alf) {
        this.ret[0] = filename;
        DataSourceType protocol = this.resolveFileProtocol(this.ret);
        if (protocol == null) {
            return false;
        }
        return (alf == null ? this.getCurrentAlignFrame() : alf).parseFeaturesFile(this.ret[0], protocol);
    }

    @Override
    public void removeSelectionListener(String listener, AlignFrame alf) {
        List<SelectionListener> listeners = Desktop.getStructureSelectionManager().getListeners();
        int i = listeners.size();
        while (--i >= 0) {
            SelectionListener l = listeners.get(i);
            if (!(l instanceof JsSelectionListener) || !((JsSelectionListener)l).isFor(alf, listener)) continue;
            listeners.remove(i);
            break;
        }
    }

    private DataSourceType resolveFileProtocol(String[] retPath) {
        String path = retPath[0];
        if (path.startsWith("PASTE")) {
            retPath[0] = path.substring(5);
            return DataSourceType.PASTE;
        }
        if (path.indexOf("://") >= 0) {
            return DataSourceType.URL;
        }
        URL documentBase = this.getDocumentBase();
        String withDocBase = JalviewJSApp.resolveUrlForLocalOrAbsolute(path, documentBase);
        if (HttpUtils.isValidUrl(withDocBase)) {
            retPath[0] = withDocBase;
            return DataSourceType.URL;
        }
        URL codeBase = this.getCodeBase();
        String withCodeBase = JalviewJSApp.resolveUrlForLocalOrAbsolute(path, codeBase);
        if (!withCodeBase.equals(withDocBase) && HttpUtils.isValidUrl(withCodeBase)) {
            retPath[0] = withCodeBase;
            return DataSourceType.URL;
        }
        if (JalviewJSApp.inArchive(this.getClass(), path)) {
            return DataSourceType.CLASSLOADER;
        }
        return null;
    }

    @Override
    public void scrollViewTo(final int topRow, final int leftHandColumn, final AlignFrame alf) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    (alf == null ? JalviewJSApp.this.getCurrentAlignFrame() : alf).scrollTo(topRow, leftHandColumn);
                }
                catch (Exception ex) {
                    System.err.println("Couldn't parse integer arguments (topRow='" + topRow + "' and leftHandColumn='" + leftHandColumn + "')");
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public void select(String[] ids, String[] cols, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        final SequenceGroup sel = new SequenceGroup();
        final ColumnSelection csel = new ColumnSelection();
        AlignmentI al = alf.getViewport().getAlignment();
        SequenceIdMatcher matcher = new SequenceIdMatcher(alf.getViewport().getAlignment().getSequencesArray());
        int start = 0;
        int end = al.getWidth();
        int alw = al.getWidth();
        boolean seqsfound = true;
        if (ids != null && ids.length > 0) {
            seqsfound = false;
            for (int i = 0; i < ids.length; ++i) {
                SequenceI sq;
                if (ids[i].trim().length() == 0 || (sq = matcher.findIdMatch(ids[i])) == null) continue;
                seqsfound = true;
                sel.addSequence(sq, false);
            }
        }
        boolean inseqpos = false;
        if (cols != null && cols.length > 0) {
            boolean seset = false;
            for (int i = 0; i < cols.length; ++i) {
                String cl = cols[i].trim();
                if (cl.length() == 0) continue;
                int p = cl.indexOf("-");
                if (p > -1) {
                    int from = -1;
                    int to = -1;
                    try {
                        from = Integer.valueOf(cl.substring(0, p));
                        --from;
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("ERROR: Couldn't parse first integer in range element column selection string '" + cl + "' - format is 'from-to'");
                        return;
                    }
                    try {
                        to = Integer.valueOf(cl.substring(p + 1));
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("ERROR: Couldn't parse second integer in range element column selection string '" + cl + "' - format is 'from-to'");
                        return;
                    }
                    if (from >= 0 && --to >= 0) {
                        if (from < to) {
                            int t = to;
                            to = from;
                            to = t;
                        }
                        if (!seset) {
                            start = from;
                            end = to;
                            seset = true;
                        } else {
                            if (start > from) {
                                start = from;
                            }
                            if (end < to) {
                                end = to;
                            }
                        }
                        for (int r = from; r <= to; ++r) {
                            if (r < 0 || r >= alw) continue;
                            csel.addElement(r);
                        }
                        continue;
                    }
                    System.err.println("ERROR: Invalid Range '" + cl + "' deparsed as [" + from + "," + to + "]");
                    continue;
                }
                int r = -1;
                try {
                    r = Integer.valueOf(cl);
                    --r;
                }
                catch (NumberFormatException ex) {
                    if (cl.toLowerCase().equals("sequence")) {
                        inseqpos = true;
                    }
                    System.err.println("ERROR: Couldn't parse integer from point selection element of column selection string '" + cl + "'");
                    return;
                }
                if (r >= 0 && r <= alw) {
                    if (!seset) {
                        start = r;
                        end = r;
                        seset = true;
                    } else {
                        if (start > r) {
                            start = r;
                        }
                        if (end < r) {
                            end = r;
                        }
                    }
                    csel.addElement(r);
                    continue;
                }
                System.err.println("ERROR: Invalid Point selection '" + cl + "' deparsed as [" + r + "]");
            }
        }
        if (seqsfound) {
            if (inseqpos && sel.getSize() > 0) {
                SequenceI rs = sel.getSequenceAt(0);
                start = rs.findIndex(start);
                end = rs.findIndex(end);
                ArrayList<Integer> cs = new ArrayList<Integer>(csel.getSelected());
                csel.clear();
                for (Integer selectedCol : cs) {
                    csel.addElement(rs.findIndex(selectedCol));
                }
            }
            sel.setStartRes(start);
            sel.setEndRes(end);
            final AlignFrame af = alf;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    af.select(sel, csel, af.getCurrentView().getAlignment().getHiddenColumns());
                }
            });
        }
    }

    @Override
    public void setFeatureGroupState(String[] groups, boolean state, AlignFrame alf) {
        (alf == null ? this.getCurrentAlignFrame() : alf).setFeatureGroupState(groups, state);
    }

    @Override
    public void setSelectionListener(String listener, AlignFrame alf) {
        Desktop.getStructureSelectionManager().addSelectionListener(new JsSelectionListener(alf, listener));
    }

    @Override
    public void showOverview() {
        this.getCurrentAlignFrame().overviewMenuItem_actionPerformed(null);
    }

    @Override
    public void showStructure(String pdbID, String fileType, AlignFrame alf) {
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        PDBEntry pe = null;
        SequenceI[] seqs = null;
        if (pdbID == null) {
            seqs = alf.getViewport().getSequenceSelection();
            if (seqs.length == 0) {
                seqs = alf.getViewport().getAlignment().getSequencesArray();
            }
            for (int i = 0; i < seqs.length; ++i) {
                Vector<PDBEntry> list = seqs[i].getAllPDBEntries();
                if (list.size() <= 0) continue;
                pe = list.get(0);
                break;
            }
        }
        if (pe == null) {
            if (pdbID == null) {
                return;
            }
            pe = new PDBEntry(pdbID, null, fileType);
            List<SequenceI> list = alf.getViewport().getAlignment().getSequences();
            ArrayList<SequenceI> tmp = new ArrayList<SequenceI>();
            for (int i = 0; i < list.size(); ++i) {
                SequenceI seq = list.get(i);
                if (seq.getPDBEntry(pdbID) == null) continue;
                tmp.add(seq);
            }
            seqs = tmp.toArray(new SequenceI[tmp.size()]);
            alf.alignPanel.selectSequences(tmp);
        }
        StructureViewer.launchStructureViewer(alf.alignPanel, pe, seqs);
    }

    private static String resolveUrlForLocalOrAbsolute(String targetPath, URL localref) {
        Object resolvedPath = "";
        if (targetPath.startsWith("/")) {
            String codebase = localref.toString();
            String localfile = localref.getFile();
            resolvedPath = codebase.substring(0, codebase.length() - localfile.length()) + targetPath;
            return resolvedPath;
        }
        String urlPath = localref.toString();
        String directoryPath = urlPath;
        int lastSeparator = directoryPath.lastIndexOf("/");
        if (lastSeparator > 0) {
            directoryPath = directoryPath.substring(0, lastSeparator + 1);
        }
        resolvedPath = targetPath.startsWith("/") ? directoryPath + targetPath.substring(1) : directoryPath + targetPath;
        return resolvedPath;
    }

    private static String[] separatorListToArray(String list, String separator) {
        String c;
        int pos;
        int seplen = separator.length();
        if (list == null || list.equals("") || list.equals(separator)) {
            return null;
        }
        Vector<String> jv = new Vector<String>();
        int cp = 0;
        while ((pos = list.indexOf(separator, cp)) > cp) {
            jv.addElement(list.substring(cp, pos));
            cp = pos + seplen;
        }
        if (cp < list.length() && !(c = list.substring(cp)).equals(separator)) {
            jv.addElement(c);
        }
        if (jv.size() > 0) {
            String[] v = new String[jv.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = (String)jv.elementAt(i);
            }
            jv.removeAllElements();
            return v;
        }
        return null;
    }

    private static boolean inArchive(Class<?> c, String f) {
        try {
            boolean rtn = c.getResourceAsStream("/" + f) != null;
            return rtn;
        }
        catch (Exception ex) {
            System.out.println("Exception checking resources: " + f + " " + ex);
            return false;
        }
    }

    void callInitCallback() {
        final Object initjscallback = this.getParameterAsObject("oninit");
        if (initjscallback != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JalviewJSApp.this.doSendCallback(initjscallback, new Object[]{this});
                    }
                    catch (Exception e) {
                        System.err.println("Exception when executing _oninit callback '" + initjscallback + "'.");
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    String doSendCallback(Object callback, Object[] data) {
        Jalview me = this.jalview;
        if (me == null || callback != null) {
            // empty if block
        }
        return "";
    }

    void initFromParams(AlignFrame alf) {
        String sep = this.getParameter("separator");
        if (sep != null && sep.length() > 0) {
            this.separator = sep;
        }
        this.initTree(alf);
        this.initScoreFile(alf);
        this.initFeatures(alf);
        this.initAnnotations(alf);
        this.initJnetFile(alf);
        this.initPdbFiles(alf);
    }

    private boolean initAnnotations(AlignFrame alf) {
        String param = this.getParameter("annotations");
        if (param == null) {
            return false;
        }
        this.ret[0] = param;
        DataSourceType protocol = this.resolveFileProtocol(this.ret);
        param = this.ret[0];
        if (!new AnnotationFile().annotateAlignmentView(alf.getViewport(), param, protocol)) {
            System.err.println("Annotations were not added from annotation file '" + param + "'");
            return false;
        }
        this.updateForAnnotations();
        return true;
    }

    private boolean initFeatures(AlignFrame alf) {
        String param = this.getParameter("hidefeaturegroups");
        if (param != null) {
            this.setFeatureGroupState(JalviewJSApp.separatorListToArray(param, this.separator), false, alf);
        }
        if ((param = this.getParameter("showfeaturegroups")) != null) {
            this.setFeatureGroupState(JalviewJSApp.separatorListToArray(param, this.separator), true, alf);
        }
        if ((param = this.getParameter("features")) == null) {
            return false;
        }
        if (!this.parseFeaturesFile(param, alf)) {
            return false;
        }
        param = this.getParameter("showFeatureSettings");
        if (param != null && param.equalsIgnoreCase("true")) {
            alf.showFeatureSettingsUI();
        }
        return true;
    }

    private boolean initJnetFile(AlignFrame alf) {
        String param = this.getParameter("jnetfile");
        if (param == null) {
            param = this.getParameter("jpredfile");
        }
        if (param != null) {
            try {
                this.ret[0] = param;
                DataSourceType protocol = this.resolveFileProtocol(this.ret);
                JPredFile predictions = new JPredFile(this.ret[0], protocol);
                JnetAnnotationMaker.add_annotation(predictions, alf.getViewport().getAlignment(), 0, false);
                alf.getViewport().getAlignment().setupJPredAlignment();
                this.updateForAnnotations();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private boolean initPdbFiles(AlignFrame alf) {
        int plast;
        boolean relaxed = "true".equalsIgnoreCase(this.getParameter("relaxedidmatch"));
        SequenceIdMatcher matcher = relaxed ? new SequenceIdMatcher(alf.getViewport().getAlignment().getSequencesArray()) : null;
        String param = this.getParameter("PDBFILE");
        int n = plast = param == null ? 9 : 1;
        if (param == null && (param = this.getParameter("PDBFILE1")) == null) {
            return false;
        }
        for (int p = 1; p <= plast && (p <= 1 || (param = this.getParameter("PDBFILE" + p)) != null); ++p) {
            PDBEntry pdb = new PDBEntry();
            SequenceI[] seqs = null;
            String[] chains = null;
            StringTokenizer st = new StringTokenizer(param, " ");
            if (st.countTokens() < 2) {
                String sequence = this.getParameter("PDBSEQ");
                if (sequence != null) {
                    seqs = new SequenceI[]{matcher == null ? (Sequence)alf.getViewport().getAlignment().findName(sequence) : matcher.findIdMatch(sequence)};
                }
            } else {
                param = st.nextToken();
                ArrayList<SequenceI> tmp = new ArrayList<SequenceI>();
                ArrayList<String> tmp2 = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String seqstring = st.nextToken();
                    StringTokenizer st2 = new StringTokenizer(seqstring, "=");
                    if (st2.countTokens() > 1) {
                        tmp2.add(st2.nextToken());
                        seqstring = st2.nextToken();
                    }
                    tmp.add(matcher == null ? (Sequence)alf.getViewport().getAlignment().findName(seqstring) : matcher.findIdMatch(seqstring));
                }
                seqs = tmp.toArray(new SequenceI[tmp.size()]);
                if (tmp2.size() == tmp.size()) {
                    chains = tmp2.toArray(new String[tmp2.size()]);
                }
            }
            pdb.setId(param);
            this.ret[0] = param;
            DataSourceType protocol = this.resolveFileProtocol(this.ret);
            pdb.setFile(this.ret[0]);
            if (seqs == null) continue;
            for (int i = 0; i < seqs.length; ++i) {
                if (seqs[i] == null) continue;
                ((Sequence)seqs[i]).addPDBId(pdb);
                StructureSelectionManager.getStructureSelectionManager((StructureSelectionManagerProvider)((Object)this)).registerPDBEntry(pdb);
            }
            StructureViewer.launchStructureViewer((alf == null ? this.getCurrentAlignFrame() : alf).alignPanel, pdb, seqs);
        }
        return true;
    }

    private boolean initScoreFile(AlignFrame alf) {
        String sScoreFile = this.getParameter("scoreFile");
        if (sScoreFile != null && !"".equals(sScoreFile)) {
            try {
                if (this.loadScoreFile(sScoreFile, alf)) {
                    return true;
                }
                System.err.println("Failed to parse T-COFFEE parameter as a valid score file ('" + sScoreFile + "')");
            }
            catch (Exception e) {
                System.err.printf("Cannot read score file: '%s'. Cause: %s \n", sScoreFile, e.getMessage());
            }
        }
        return false;
    }

    private boolean initTree(AlignFrame alf) {
        String treeFile = this.getParameter("tree");
        if (treeFile == null && (treeFile = this.getParameter("treefile")) == null) {
            return false;
        }
        if (alf == null) {
            alf = this.getCurrentAlignFrame();
        }
        try {
            this.ret[0] = treeFile;
            NewickFile nf = new NewickFile(treeFile, this.resolveFileProtocol(this.ret));
            nf.parse();
            if (nf.getTree() != null) {
                treeFile = this.ret[0];
                alf.getViewport().setCurrentTree(alf.showNewickTree(nf, treeFile).getTree());
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private void updateForAnnotations() {
        this.getCurrentAlignFrame().updateForAnnotations();
    }

    public class JsSelectionListener
    implements SelectionListener {
        AlignFrame _alf;
        String _listener;

        public JsSelectionListener(AlignFrame alf, String listener) {
            this._alf = alf;
            this._listener = listener;
        }

        public boolean isFor(AlignFrame alf, String listener) {
            return (this._alf == null || this._alf == alf) && this._listener.equals(listener);
        }

        @Override
        public void selection(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
            int i;
            int end;
            AlignFrame srcFrame;
            String setid = "";
            AlignFrame alignFrame = srcFrame = this._alf == null ? JalviewJSApp.this.getCurrentAlignFrame() : this._alf;
            if (source != null && source instanceof AlignViewport && srcFrame.getViewport() != source) {
                return;
            }
            String[] seqs = new String[]{};
            String[] cols = new String[]{};
            int strt = 0;
            int n = end = srcFrame == null ? -1 : srcFrame.alignPanel.av.getAlignment().getWidth();
            if (seqsel != null && seqsel.getSize() > 0) {
                seqs = new String[seqsel.getSize()];
                for (i = 0; i < seqs.length; ++i) {
                    seqs[i] = seqsel.getSequenceAt(i).getName();
                }
                if (strt < seqsel.getStartRes()) {
                    strt = seqsel.getStartRes();
                }
                if (end == -1 || end > seqsel.getEndRes()) {
                    end = seqsel.getEndRes();
                }
            }
            if (colsel != null && !colsel.isEmpty()) {
                if (end == -1) {
                    end = colsel.getMax() + 1;
                }
                cols = new String[colsel.getSelected().size()];
                for (i = 0; i < cols.length; ++i) {
                    cols[i] = "" + (1 + colsel.getSelected().get(i));
                }
            } else if (seqsel != null && seqsel.getSize() > 0) {
                cols = new String[]{1 + strt + "-" + (1 + end)};
            }
            JalviewJSApp.this.doSendCallback(this._listener, new Object[]{Jalview.getInstance().j2sAppletID, srcFrame, source, setid, seqs, cols});
        }
    }
}

