/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AlignSeq;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignmentPanel;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Format;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class PairwiseAlignPanel
extends Panel
implements ActionListener {
    Vector sequences = new Vector();
    AlignmentPanel ap;
    protected ScrollPane scrollPane = new ScrollPane();
    protected TextArea textarea = new TextArea();
    protected Button viewInEditorButton = new Button();
    Panel jPanel1 = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();

    public PairwiseAlignPanel(AlignmentPanel ap) {
        int j;
        int i;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ap = ap;
        this.sequences = new Vector();
        String[] seqStrings = ap.av.getViewAsString(true);
        SequenceI[] seqs = ap.av.getSelectionGroup() == null ? ap.av.getAlignment().getSequencesArray() : ap.av.getSelectionGroup().getSequencesInOrder(ap.av.getAlignment());
        float[][] scores = new float[seqs.length][seqs.length];
        double totscore = 0.0;
        int count = ap.av.getSelectionGroup().getSize();
        String type = ap.av.getAlignment().isNucleotide() ? "dna" : "pep";
        for (i = 1; i < count; ++i) {
            for (j = 0; j < i; ++j) {
                AlignSeq as = new AlignSeq(seqs[i], seqStrings[i], seqs[j], seqStrings[j], type);
                if (as.s1str.length() == 0 || as.s2str.length() == 0) continue;
                as.calcScoreMatrix();
                as.traceAlignment();
                as.printAlignment(System.out);
                scores[i][j] = as.getMaxScore() / (float)as.getASeq1().length;
                totscore += (double)scores[i][j];
                this.textarea.append(as.getOutput());
                this.sequences.add(as.getAlignedSeq1());
                this.sequences.add(as.getAlignedSeq1());
            }
        }
        if (count > 2) {
            Console.outPrintln("Pairwise alignment scaled similarity score matrix\n");
            for (i = 0; i < count; ++i) {
                Format.print(System.out, "%s \n", i + " " + seqs[i].getName());
            }
            Console.outPrintln("\n");
            for (i = 0; i < count; ++i) {
                for (j = 0; j < i; ++j) {
                    Format.print(System.out, "%7.3f", (double)scores[i][j] / totscore);
                }
            }
            Console.outPrintln("\n");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.viewInEditorButton) {
            this.viewInEditorButton_actionPerformed();
        }
    }

    protected void viewInEditorButton_actionPerformed() {
        SequenceI[] seq = new Sequence[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            seq[i] = (Sequence)this.sequences.elementAt(i);
        }
        new AlignFrame(new Alignment(seq), this.ap.av.applet, "Pairwise Aligned Sequences", false);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.textarea.setFont(new Font("Monospaced", 0, 12));
        this.textarea.setText("");
        this.viewInEditorButton.setFont(new Font("Verdana", 0, 12));
        this.viewInEditorButton.setLabel(MessageManager.getString("label.view_alignment_editor"));
        this.viewInEditorButton.addActionListener(this);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.add(this.textarea);
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.viewInEditorButton, null);
    }
}

