/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.FeatureColourI;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.FeatureSettings;
import jalview.appletgui.JVDialog;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.UserDefinedColours;
import jalview.datamodel.GraphLine;
import jalview.schemes.FeatureColour;
import jalview.util.MessageManager;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class FeatureColourChooser
extends Panel
implements ActionListener,
AdjustmentListener,
ItemListener,
MouseListener {
    private static final int SCALE_FACTOR_1K = 1000;
    private static final String COLON = ":";
    private JVDialog frame;
    private Frame owner;
    private FeatureRenderer fr;
    private FeatureSettings fs = null;
    private FeatureColourI cs;
    private FeatureColourI oldcs;
    private boolean adjusting = false;
    private float min;
    private float max;
    private String type = null;
    private AlignFrame af = null;
    private Panel minColour = new Panel();
    private Panel maxColour = new Panel();
    private Choice threshold = new Choice();
    private Scrollbar slider = new Scrollbar(0);
    private TextField thresholdValue = new TextField(20);
    private Checkbox thresholdIsMin = new Checkbox();
    private Checkbox colourFromLabel = new Checkbox();
    private GraphLine threshline;

    public FeatureColourChooser(AlignFrame alignFrame, String featureType) {
        this.af = alignFrame;
        this.init(alignFrame.getSeqcanvas().getFeatureRenderer(), featureType);
    }

    public FeatureColourChooser(FeatureSettings fsettings, String featureType) {
        this.fs = fsettings;
        this.init(fsettings.fr, featureType);
    }

    private void init(FeatureRenderer frenderer, String featureType) {
        this.type = featureType;
        this.fr = frenderer;
        float[] mm = this.fr.getMinMax().get(this.type)[0];
        this.min = mm[0];
        this.max = mm[1];
        this.threshline = new GraphLine((this.max - this.min) / 2.0f, "Threshold", Color.black);
        this.oldcs = this.fr.getFeatureColours().get(this.type);
        if (this.oldcs.isGraduatedColour()) {
            this.threshline.value = this.oldcs.getThreshold();
            this.cs = new FeatureColour(this.oldcs.getColour(), this.oldcs.getMinColour(), this.oldcs.getMaxColour(), this.oldcs.getNoColour(), this.min, this.max);
        } else {
            Color bl = Color.black;
            if (this.oldcs.isSimpleColour()) {
                bl = this.oldcs.getColour();
            }
            this.cs = new FeatureColour(bl, Color.white, bl, Color.white, mm[0], mm[1]);
        }
        this.minColour.setBackground(this.cs.getMinColour());
        this.maxColour.setBackground(this.cs.getMaxColour());
        this.minColour.setForeground(this.cs.getMinColour());
        this.maxColour.setForeground(this.cs.getMaxColour());
        this.colourFromLabel.setState(this.cs.isColourByLabel());
        this.adjusting = true;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.threshold.select(this.cs.isAboveThreshold() ? 1 : (this.cs.isBelowThreshold() ? 2 : 0));
        this.adjusting = false;
        this.changeColour(true);
        this.colourFromLabel.addItemListener(this);
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        this.owner = this.af != null ? this.af : this.fs.frame;
        this.frame = new JVDialog(this.owner, MessageManager.formatMessage("label.variable_color_for", new String[]{this.type}), true, 480, 248);
        this.frame.setMainPanel(this);
        this.validate();
        this.frame.setVisible(true);
        if (this.frame.accept) {
            this.changeColour(true);
        } else {
            this.reset();
            this.frame.setVisible(false);
        }
    }

    public FeatureColourChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Label minLabel = new Label(MessageManager.getString("label.min_value") + COLON);
        Label maxLabel = new Label(MessageManager.getString("label.max_value") + COLON);
        minLabel.setFont(new Font("Verdana", 0, 11));
        maxLabel.setFont(new Font("Verdana", 0, 11));
        this.minColour.setBounds(0, 0, 40, 27);
        this.maxColour.setBounds(0, 0, 40, 27);
        this.minColour.addMouseListener(this);
        this.maxColour.setFont(new Font("Verdana", 0, 11));
        this.maxColour.addMouseListener(this);
        this.thresholdIsMin.addItemListener(this);
        this.setLayout(new GridLayout(4, 1));
        Panel jPanel1 = new Panel();
        jPanel1.setLayout(new FlowLayout());
        Panel jPanel2 = new Panel();
        jPanel2.setLayout(new FlowLayout());
        Panel jPanel3 = new Panel();
        jPanel3.setLayout(new GridLayout(1, 1));
        Panel jPanel4 = new Panel();
        jPanel4.setLayout(new FlowLayout());
        jPanel1.setBackground(Color.white);
        jPanel2.setBackground(Color.white);
        jPanel4.setBackground(Color.white);
        this.threshold.addItemListener(this);
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_no_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_above_threshold"));
        this.threshold.addItem(MessageManager.getString("label.threshold_feature_below_threshold"));
        this.thresholdValue.addActionListener(this);
        this.thresholdValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FeatureColourChooser.this.thresholdValue_actionPerformed();
            }
        });
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setSize(new Dimension(93, 21));
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setSize(new Dimension(79, 22));
        this.thresholdValue.setColumns(5);
        jPanel3.setBackground(Color.white);
        this.colourFromLabel.setFont(new Font("Verdana", 0, 11));
        this.colourFromLabel.setLabel(MessageManager.getString("label.colour_by_label"));
        this.colourFromLabel.setSize(new Dimension(139, 22));
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setLabel(MessageManager.getString("label.threshold_minmax"));
        this.thresholdIsMin.setSize(new Dimension(135, 23));
        jPanel1.add(minLabel);
        jPanel1.add(this.minColour);
        jPanel1.add(maxLabel);
        jPanel1.add(this.maxColour);
        jPanel1.add(this.colourFromLabel);
        jPanel2.add(this.threshold);
        jPanel3.add(this.slider);
        jPanel4.add(this.thresholdValue);
        jPanel4.add(this.thresholdIsMin);
        this.add(jPanel1);
        this.add(jPanel2);
        this.add(jPanel3);
        this.add(jPanel4);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.thresholdValue) {
            this.thresholdValue_actionPerformed();
        } else if (evt.getSource() == this.minColour) {
            this.minColour_actionPerformed(null);
        } else if (evt.getSource() == this.maxColour) {
            this.maxColour_actionPerformed(null);
        } else {
            this.changeColour(true);
        }
    }

    protected void thresholdValue_actionPerformed() {
        try {
            float f = Float.valueOf(this.thresholdValue.getText()).floatValue();
            this.slider.setValue((int)(f * 1000.0f));
            this.adjustmentValueChanged(null);
            this.changeColour(true);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.maxColour.setEnabled(!this.colourFromLabel.getState());
        this.minColour.setEnabled(!this.colourFromLabel.getState());
        this.changeColour(true);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (!this.adjusting) {
            this.thresholdValue.setText("" + (float)this.slider.getValue() / 1000.0f);
            this.valueChanged();
        }
    }

    protected void valueChanged() {
        this.threshline.value = (float)this.slider.getValue() / 1000.0f;
        this.cs.setThreshold(this.threshline.value);
        this.changeColour(false);
        PaintRefresher.Refresh(this, this.fr.getViewport().getSequenceSetId());
    }

    public void minColour_actionPerformed(Color newCol) {
        if (newCol == null) {
            new UserDefinedColours(this, this.minColour.getBackground(), this.owner, MessageManager.getString("label.select_colour_minimum_value"));
        } else {
            this.minColour.setBackground(newCol);
            this.minColour.setForeground(newCol);
            this.minColour.repaint();
            this.changeColour(true);
        }
    }

    public void maxColour_actionPerformed(Color newCol) {
        if (newCol == null) {
            new UserDefinedColours(this, this.maxColour.getBackground(), this.owner, MessageManager.getString("label.select_colour_maximum_value"));
        } else {
            this.maxColour.setBackground(newCol);
            this.maxColour.setForeground(newCol);
            this.maxColour.repaint();
            this.changeColour(true);
        }
    }

    void changeColour(boolean updateOverview) {
        if (this.adjusting) {
            return;
        }
        int thresholdOption = -1;
        if (this.threshold.getSelectedIndex() == 1) {
            thresholdOption = 1;
        } else if (this.threshold.getSelectedIndex() == 2) {
            thresholdOption = 0;
        }
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        Color minc = this.minColour.getBackground();
        Color maxc = this.maxColour.getBackground();
        FeatureColour acg = new FeatureColour(maxc, minc, maxc, minc, this.min, this.max);
        acg.setColourByLabel(this.colourFromLabel.getState());
        this.maxColour.setEnabled(!this.colourFromLabel.getState());
        this.minColour.setEnabled(!this.colourFromLabel.getState());
        if (thresholdOption == -1) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
        }
        if (thresholdOption != -1) {
            this.adjusting = true;
            acg.setThreshold(this.threshline.value);
            this.slider.setMinimum((int)(this.min * 1000.0f));
            this.slider.setMaximum((int)(this.max * 1000.0f));
            this.slider.setValue((int)(this.threshline.value * 1000.0f));
            this.thresholdValue.setText("" + this.threshline.value);
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
        }
        acg.setAboveThreshold(thresholdOption == 1);
        acg.setBelowThreshold(thresholdOption == 0);
        if (this.thresholdIsMin.getState() && thresholdOption != -1) {
            acg = thresholdOption == 1 ? new FeatureColour(acg.getColour(), acg.getMinColour(), acg.getMaxColour(), acg.getNoColour(), this.threshline.value, this.max) : new FeatureColour(acg.getColour(), acg.getMinColour(), acg.getMaxColour(), acg.getNoColour(), this.min, this.threshline.value);
        }
        this.fr.setColour(this.type, acg);
        this.cs = acg;
        this.fs.selectionChanged(updateOverview);
    }

    void reset() {
        this.fr.setColour(this.type, this.oldcs);
        this.fs.selectionChanged(true);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.getSource() == this.minColour) {
            this.minColour_actionPerformed(null);
        } else if (evt.getSource() == this.maxColour) {
            this.maxColour_actionPerformed(null);
        } else {
            this.changeColour(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

