/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.AlignViewportI;
import jalview.api.FeatureSettingsModelI;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AnnotationColumnChooser;
import jalview.appletgui.FeatureSettings;
import jalview.bin.Console;
import jalview.bin.JalviewLite;
import jalview.commands.CommandI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceGroup;
import jalview.renderer.ResidueShader;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.UserColourScheme;
import jalview.structure.SelectionSource;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.viewmodel.AlignmentViewport;
import jalview.workers.AlignCalcManager2;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;

public class AlignViewport
extends AlignmentViewport<AlignmentPanel>
implements SelectionSource {
    boolean cursorMode = false;
    Font font = new Font("SansSerif", 0, 10);
    boolean validCharWidth = true;
    public JalviewLite applet;
    private AnnotationColumnChooser annotationColumnSelectionState;
    Frame nullFrame;
    protected FeatureSettings featureSettings = null;
    private float heightScale = 1.0f;
    private float widthScale = 1.0f;
    boolean centreColumnLabels;
    public boolean followSelection = true;

    public AlignViewport(AlignmentI al, JalviewLite applet) {
        super(al);
        String param;
        this.calculator = new AlignCalcManager2();
        this.applet = applet;
        this.setPadGaps(true);
        if (applet != null) {
            param = applet.getParameter("widthScale");
            if (param != null) {
                try {
                    this.widthScale = Float.valueOf(param).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((double)this.widthScale <= 1.0) {
                    Console.errPrintln("Invalid alignment character width scaling factor (" + this.widthScale + "). Ignoring.");
                    this.widthScale = 1.0f;
                }
                if (JalviewLite.debug) {
                    Console.errPrintln("Alignment character width scaling factor is now " + this.widthScale);
                }
            }
            if ((param = applet.getParameter("heightScale")) != null) {
                try {
                    this.heightScale = Float.valueOf(param).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((double)this.heightScale <= 1.0) {
                    Console.errPrintln("Invalid alignment character height scaling factor (" + this.heightScale + "). Ignoring.");
                    this.heightScale = 1.0f;
                }
                if (JalviewLite.debug) {
                    Console.errPrintln("Alignment character height scaling factor is now " + this.heightScale);
                }
            }
        }
        this.setFont(this.font, true);
        if (applet != null) {
            this.setShowJVSuffix(applet.getDefaultParameter("showFullId", this.getShowJVSuffix()));
            this.setShowAnnotation(applet.getDefaultParameter("showAnnotation", this.isShowAnnotation()));
            this.showConservation = applet.getDefaultParameter("showConservation", this.showConservation);
            this.showQuality = applet.getDefaultParameter("showQuality", this.showQuality);
            this.showConsensus = applet.getDefaultParameter("showConsensus", this.showConsensus);
            this.showOccupancy = applet.getDefaultParameter("showOccupancy", this.showOccupancy);
            this.setShowUnconserved(applet.getDefaultParameter("showUnconserved", this.getShowUnconserved()));
            this.setScaleProteinAsCdna(applet.getDefaultParameter("scaleProteinAsCdna", this.isScaleProteinAsCdna()));
            param = applet.getParameter("upperCase");
            if (param != null && param.equalsIgnoreCase("bold")) {
                this.setUpperCasebold(true);
            }
            this.sortByTree = applet.getDefaultParameter("sortByTree", this.sortByTree);
            this.setFollowHighlight(applet.getDefaultParameter("automaticScrolling", this.isFollowHighlight()));
            this.followSelection = this.isFollowHighlight();
            this.showSequenceLogo = applet.getDefaultParameter("showSequenceLogo", this.showSequenceLogo);
            this.normaliseSequenceLogo = applet.getDefaultParameter("normaliseSequenceLogo", applet.getDefaultParameter("normaliseLogo", this.normaliseSequenceLogo));
            this.showGroupConsensus = applet.getDefaultParameter("showGroupConsensus", this.showGroupConsensus);
            this.showGroupConservation = applet.getDefaultParameter("showGroupConservation", this.showGroupConservation);
            this.showConsensusHistogram = applet.getDefaultParameter("showConsensusHistogram", this.showConsensusHistogram);
        }
        if (applet != null) {
            String colour;
            String string = colour = al.isNucleotide() ? applet.getParameter("defaultColourNuc") : applet.getParameter("defaultColourProt");
            if (colour == null) {
                colour = applet.getParameter("defaultColour");
            }
            if (colour == null && (colour = applet.getParameter("userDefinedColour")) != null) {
                colour = "User Defined";
            }
            if (colour != null) {
                this.residueShading = new ResidueShader(ColourSchemeProperty.getColourScheme(this, this.alignment, colour));
                if (this.residueShading != null) {
                    this.residueShading.setConsensus(this.consensusProfiles);
                }
            }
            if (applet.getParameter("userDefinedColour") != null) {
                this.residueShading = new ResidueShader(new UserColourScheme(applet.getParameter("userDefinedColour")));
            }
        }
        this.initAutoAnnotation();
    }

    @Override
    public void setFont(Font f, boolean setGrid) {
        this.font = f;
        if (this.nullFrame == null) {
            this.nullFrame = new Frame();
            this.nullFrame.addNotify();
        }
        if (setGrid) {
            FontMetrics fm = this.nullFrame.getGraphics().getFontMetrics(this.font);
            this.setCharHeight((int)(this.heightScale * (float)fm.getHeight()));
            this.setCharWidth((int)(this.widthScale * (float)fm.charWidth('M')));
        }
        if (this.isUpperCasebold()) {
            Font f2 = new Font(f.getName(), 1, f.getSize());
            FontMetrics fm = this.nullFrame.getGraphics().getFontMetrics(f2);
            this.setCharWidth((int)(this.widthScale * (float)(fm.stringWidth("MMMMMMMMMMM") / 10)));
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void resetSeqLimits(int height) {
        this.ranges.setEndSeq(height / this.getCharHeight() - 1);
    }

    public boolean getCentreColumnLabels() {
        return this.centreColumnLabels;
    }

    public boolean getFollowSelection() {
        return this.followSelection;
    }

    @Override
    public void sendSelection() {
        this.getStructureSelectionManager().sendSelection(new SequenceGroup(this.getSelectionGroup()), new ColumnSelection(this.getColumnSelection()), new HiddenColumns(this.getAlignment().getHiddenColumns()), this);
    }

    @Override
    public StructureSelectionManager getStructureSelectionManager() {
        return StructureSelectionManager.getStructureSelectionManager(this.applet);
    }

    @Override
    public boolean isValidCharWidth() {
        return this.validCharWidth;
    }

    public AnnotationColumnChooser getAnnotationColumnSelectionState() {
        return this.annotationColumnSelectionState;
    }

    public void setAnnotationColumnSelectionState(AnnotationColumnChooser annotationColumnSelectionState) {
        this.annotationColumnSelectionState = annotationColumnSelectionState;
    }

    @Override
    public void mirrorCommand(CommandI command, boolean undo, StructureSelectionManager ssm, VamsasSource source) {
        if (!(source instanceof AlignViewportI) || ((AlignViewportI)((Object)source)).getCodingComplement() != this) {
            return;
        }
        CommandI mappedCommand = ssm.mapCommand(command, undo, this.getAlignment(), this.getGapCharacter());
        if (mappedCommand != null) {
            mappedCommand.doCommand(null);
            this.notifyAlignment();
        }
    }

    @Override
    public VamsasSource getVamsasSource() {
        return this;
    }

    public void scrollComplementaryAlignment(AlignmentPanel complementPanel) {
        if (complementPanel == null) {
            return;
        }
        SearchResults sr = new SearchResults();
        int seqOffset = this.findComplementScrollTarget(sr);
        if (!sr.isEmpty()) {
            complementPanel.setToScrollComplementPanel(false);
            complementPanel.scrollToCentre(sr, seqOffset);
            complementPanel.setToScrollComplementPanel(true);
        }
    }

    @Override
    public void applyFeaturesStyle(FeatureSettingsModelI featureSettings) {
    }

    @Override
    public void mergeFeaturesStyle(FeatureSettingsModelI featureSettings) {
    }
}

