/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.scoremodels.FeatureDistanceModel;
import jalview.analysis.scoremodels.PIDModel;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.SecondaryStructureDistanceModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.analysis.ScoreModelI;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Console;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.ScoreMatrixFile;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScoreModels
implements ApplicationSingletonProvider.ApplicationSingletonI {
    private final ScoreMatrix BLOSUM62;
    private final ScoreMatrix PAM250;
    private final ScoreMatrix DNA;
    private final ScoreMatrix SECONDARYSTRUCTURE;
    private Map<String, ScoreModelI> models = new LinkedHashMap<String, ScoreModelI>();

    public static ScoreModels getInstance() {
        return ApplicationSingletonProvider.getInstance(ScoreModels.class);
    }

    private ScoreModels() {
        this.BLOSUM62 = this.loadScoreMatrix("scoreModel/blosum62.scm", true);
        this.PAM250 = this.loadScoreMatrix("scoreModel/pam250.scm", true);
        this.DNA = this.loadScoreMatrix("scoreModel/dna.scm", true);
        this.registerScoreModel(new PIDModel());
        this.registerScoreModel(new FeatureDistanceModel());
        this.SECONDARYSTRUCTURE = this.loadScoreMatrix("scoreModel/secondarystructure.scm", false);
        this.registerScoreModel(new SecondaryStructureDistanceModel());
    }

    ScoreMatrix loadScoreMatrix(String resourcePath, boolean register) {
        try {
            FileParse fp = new FileParse(resourcePath, DataSourceType.CLASSLOADER);
            ScoreMatrix sm = new ScoreMatrixFile(fp).parseMatrix();
            if (register) {
                this.registerScoreModel(sm);
            }
            return sm;
        }
        catch (IOException e) {
            Console.errPrintln("Error reading " + resourcePath + ": " + e.getMessage());
            return null;
        }
    }

    public Iterable<ScoreModelI> getModels() {
        return this.models.values();
    }

    public ScoreModelI getScoreModel(String name, AlignmentViewPanel avp) {
        ScoreModelI model = this.models.get(name);
        return model == null ? null : model.getInstance(avp);
    }

    public void registerScoreModel(ScoreModelI sm) {
        ScoreModelI sm2 = this.models.get(sm.getName());
        if (sm2 != null) {
            Console.errPrintln("Warning: replacing score model " + sm2.getName());
        }
        this.models.put(sm.getName(), sm);
    }

    public void reset() {
        ApplicationSingletonProvider.removeInstance(this.getClass());
    }

    public ScoreMatrix getDefaultModel(boolean forPeptide) {
        return forPeptide ? this.BLOSUM62 : this.DNA;
    }

    public ScoreMatrix getBlosum62() {
        return this.BLOSUM62;
    }

    public ScoreMatrix getPam250() {
        return this.PAM250;
    }

    public ScoreMatrix getSecondaryStructureMatrix() {
        return this.SECONDARYSTRUCTURE;
    }
}

