/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.AlignSeq;
import jalview.analysis.SequenceIdMatcher;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;

public class SeqsetUtils {
    public static SequenceInfo SeqCharacterHash(SequenceI seq) {
        SequenceInfo sqinfo = new SequenceInfo(seq.getName(), seq.getStart(), seq.getEnd());
        sqinfo.description = Optional.ofNullable(seq.getDescription());
        sqinfo.dataset = Optional.ofNullable(seq.getDatasetSequence());
        if (!sqinfo.dataset.isPresent()) {
            ArrayList<SequenceFeature> feats = new ArrayList<SequenceFeature>(seq.getFeatures().getAllFeatures(new String[0]));
            sqinfo.features = Optional.of(feats);
            Vector<PDBEntry> pdbEntries = seq.getAllPDBEntries();
            sqinfo.pdbId = Optional.of(pdbEntries != null ? pdbEntries : new ArrayList());
        }
        if (seq.hasHMMProfile()) {
            sqinfo.hmm = Optional.of(seq.getHMM());
        }
        sqinfo.searchScores = Optional.ofNullable(seq.getAnnotation("Search Scores"));
        return sqinfo;
    }

    public static char[] filterSequence(char[] sequence, BitSet mask) {
        mask = mask.get(0, sequence.length);
        char[] result = new char[mask.cardinality()];
        int i = mask.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            result[j++] = sequence[i];
            if (i == Integer.MAX_VALUE) break;
            i = mask.nextSetBit(i + 1);
        }
        return result;
    }

    public static boolean SeqCharacterUnhash(SequenceI sq, SequenceInfo sqinfo) {
        if (sqinfo == null) {
            return false;
        }
        if (sqinfo.name != null) {
            sq.setName(sqinfo.name);
        }
        sq.setStart(sqinfo.start);
        sq.setEnd(sqinfo.end);
        if (sqinfo.pdbId.isPresent() && !sqinfo.pdbId.get().isEmpty()) {
            sq.setPDBId(new Vector<PDBEntry>((Collection)sqinfo.pdbId.get()));
        }
        if (sqinfo.features.isPresent() && !sqinfo.features.get().isEmpty()) {
            sq.setSequenceFeatures(sqinfo.features.get());
        }
        if (sqinfo.description.isPresent()) {
            sq.setDescription(sqinfo.description.get());
        }
        if (sqinfo.dataset.isPresent()) {
            if (sqinfo.features.isPresent()) {
                Console.warn("Setting dataset sequence for a sequence which has sequence features. Dataset sequence features will not be visible.");
                assert (false);
            }
            sq.setDatasetSequence(sqinfo.dataset.get());
        }
        if (sqinfo.hmm.isPresent()) {
            sq.setHMM(new HiddenMarkovModel(sqinfo.hmm.get(), sq));
        }
        if (sqinfo.searchScores.isPresent()) {
            for (AlignmentAnnotation score : sqinfo.searchScores.get()) {
                sq.addAlignmentAnnotation(score);
            }
        }
        return sqinfo.name != null;
    }

    public static String unique_name(int i) {
        return String.format("Sequence%d", i);
    }

    public static Map<String, SequenceInfo> uniquify(SequenceI[] sequences, boolean write_names) {
        HashMap<String, SequenceInfo> map = new HashMap<String, SequenceInfo>();
        for (int i = 0; i < sequences.length; ++i) {
            String safename = SeqsetUtils.unique_name(i);
            map.put(safename, SeqsetUtils.SeqCharacterHash(sequences[i]));
            if (!write_names) continue;
            sequences[i].setName(safename);
        }
        return map;
    }

    public static boolean deuniquify(Map<String, SequenceInfo> map, SequenceI[] sequences) {
        return SeqsetUtils.deuniquify(map, sequences, true);
    }

    public static boolean deuniquify(Map<String, SequenceInfo> map, SequenceI[] sequences, boolean quiet) {
        SequenceIdMatcher matcher = new SequenceIdMatcher(sequences);
        SequenceI msq = null;
        Iterator<String> keys = map.keySet().iterator();
        Vector<SequenceI> unmatched = new Vector<SequenceI>();
        int j = sequences.length;
        for (int i = 0; i < j; ++i) {
            unmatched.addElement(sequences[i]);
        }
        while (keys.hasNext()) {
            String key = keys.next();
            try {
                msq = matcher.findIdMatch(key);
                if (msq != null) {
                    SequenceInfo sqinfo = map.get(key);
                    unmatched.removeElement(msq);
                    SeqsetUtils.SeqCharacterUnhash(msq, sqinfo);
                    continue;
                }
                if (quiet) continue;
                Console.warn(String.format("Can't find '%s' in uniquified alignment", key));
            }
            catch (ClassCastException ccastex) {
                if (quiet) continue;
                Console.error("Unexpected object in SeqSet map : " + key.getClass());
            }
        }
        if (unmatched.size() > 0 && !quiet) {
            StringBuilder sb = new StringBuilder("Did not find match for sequences: ");
            Enumeration i = unmatched.elements();
            sb.append(((SequenceI)i.nextElement()).getName());
            while (i.hasMoreElements()) {
                sb.append(", " + ((SequenceI)i.nextElement()).getName());
            }
            Console.warn(sb.toString());
            return false;
        }
        return true;
    }

    public static SequenceI[] getNonEmptySequenceSet(SequenceI[] sequences) {
        boolean[] ungapped = new boolean[sequences.length];
        int msflen = 0;
        int j = sequences.length;
        for (int i = 0; i < j; ++i) {
            String tempseq = AlignSeq.extractGaps(Comparison.GapChars, sequences[i].getSequenceAsString());
            if (tempseq.length() == 0) {
                ungapped[i] = false;
                continue;
            }
            ungapped[i] = true;
            ++msflen;
        }
        if (msflen == 0) {
            return null;
        }
        SequenceI[] mset = new SequenceI[msflen];
        int j2 = sequences.length;
        int k = 0;
        for (int i = 0; i < j2; ++i) {
            if (!ungapped[i]) continue;
            mset[k++] = sequences[i];
        }
        ungapped = null;
        return mset;
    }

    public static class SequenceInfo {
        private String name;
        private int start;
        private int end;
        private Optional<String> description = Optional.empty();
        private Optional<List<SequenceFeature>> features = Optional.empty();
        private Optional<List<PDBEntry>> pdbId = Optional.empty();
        private Optional<SequenceI> dataset = Optional.empty();
        private Optional<HiddenMarkovModel> hmm = Optional.empty();
        private Optional<AlignmentAnnotation[]> searchScores = Optional.empty();

        private SequenceInfo(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }
    }
}

