/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Point;
import jalview.math.MatrixI;
import java.io.PrintStream;

public class PCA
implements Runnable {
    private final AlignmentView seqs;
    private final ScoreModelI scoreModel;
    private final SimilarityParamsI similarityParams;
    private MatrixI pairwiseScores;
    private MatrixI tridiagonal;
    private MatrixI eigenMatrix;

    public PCA(AlignmentView sequences, ScoreModelI sm, SimilarityParamsI options) {
        this.seqs = sequences;
        this.scoreModel = sm;
        this.similarityParams = options;
    }

    public double getEigenvalue(int i) {
        return this.eigenMatrix.getD()[i];
    }

    public Point[] getComponents(int l, int n, int mm, float factor) {
        Point[] out = new Point[this.getHeight()];
        for (int i = 0; i < this.getHeight(); ++i) {
            float x = (float)this.component(i, l) * factor;
            float y = (float)this.component(i, n) * factor;
            float z = (float)this.component(i, mm) * factor;
            out[i] = new Point(x, y, z);
        }
        return out;
    }

    public double[] component(int n) {
        double[] out = new double[this.getHeight()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.component(i, n);
        }
        return out;
    }

    double component(int row, int n) {
        double out = 0.0;
        for (int i = 0; i < this.pairwiseScores.width(); ++i) {
            out += this.pairwiseScores.getValue(row, i) * this.eigenMatrix.getValue(i, n);
        }
        return out / this.eigenMatrix.getD()[n];
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("PCA calculation using ").append(this.scoreModel.getName()).append(" sequence similarity matrix\n========\n\n");
        PrintStream ps = this.wrapOutputBuffer(sb);
        sb.append(" --- OrigT * Orig ---- \n");
        this.pairwiseScores.print(ps, "%8.2f");
        sb.append(" ---Tridiag transform matrix ---\n");
        sb.append(" --- D vector ---\n");
        this.tridiagonal.printD(ps, "%15.4e");
        ps.println();
        sb.append("--- E vector ---\n");
        this.tridiagonal.printE(ps, "%15.4e");
        ps.println();
        sb.append(" --- New diagonalization matrix ---\n");
        this.eigenMatrix.print(ps, "%8.2f");
        sb.append(" --- Eigenvalues ---\n");
        this.eigenMatrix.printD(ps, "%15.4e");
        ps.println();
        return sb.toString();
    }

    @Override
    public void run() {
        try {
            this.pairwiseScores = this.scoreModel.findSimilarities(this.seqs, this.similarityParams);
            this.tridiagonal = this.pairwiseScores.copy();
            this.tridiagonal.tred();
            this.eigenMatrix = this.tridiagonal.copy();
            this.eigenMatrix.tqli();
        }
        catch (Exception q) {
            Console.error("Error computing PCA:  " + q.getMessage());
            q.printStackTrace();
        }
    }

    protected PrintStream wrapOutputBuffer(final StringBuilder sb) {
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void print(String x) {
                sb.append(x);
            }

            @Override
            public void println() {
                sb.append("\n");
            }
        };
        return ps;
    }

    public int getHeight() {
        return this.pairwiseScores.height();
    }

    public MatrixI getPairwiseScores() {
        return this.pairwiseScores;
    }

    public void setPairwiseScores(MatrixI m) {
        this.pairwiseScores = m;
    }

    public MatrixI getEigenmatrix() {
        return this.eigenMatrix;
    }

    public void setEigenmatrix(MatrixI m) {
        this.eigenMatrix = m;
    }

    public MatrixI getTridiagonal() {
        return this.tridiagonal;
    }

    public void setTridiagonal(MatrixI tridiagonal) {
        this.tridiagonal = tridiagonal;
    }
}

