/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.CodingUtils;
import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.Profile;
import jalview.datamodel.ProfileI;
import jalview.datamodel.Profiles;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.SecondaryStructureCount;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.ext.android.SparseIntArray;
import jalview.schemes.ResidueProperties;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.MappingUtils;
import jalview.util.QuickSort;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class AAFrequency {
    private static final double LOG2 = Math.log(2.0);
    public static final String PROFILE = "P";

    public static final ProfilesI calculate(List<SequenceI> list, int start, int end) {
        return AAFrequency.calculate(list, start, end, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ProfilesI calculate(List<SequenceI> sequences, int start, int end, boolean profile) {
        SequenceI[] seqs = new SequenceI[sequences.size()];
        int width = 0;
        List<SequenceI> list = sequences;
        synchronized (list) {
            for (int i = 0; i < sequences.size(); ++i) {
                seqs[i] = sequences.get(i);
                int length = seqs[i].getLength();
                if (length <= width) continue;
                width = length;
            }
            if (end >= width) {
                end = width;
            }
            ProfilesI reply = AAFrequency.calculate(seqs, width, start, end, profile);
            return reply;
        }
    }

    public static final ProfilesI calculate(SequenceI[] sequences, int width, int start, int end, boolean saveFullProfile) {
        int seqCount = sequences.length;
        boolean nucleotide = false;
        int nucleotideCount = 0;
        int peptideCount = 0;
        ProfileI[] result = new ProfileI[width];
        for (int column = start; column < end; ++column) {
            if (nucleotideCount > 100 && column % 10 == 0) {
                nucleotide = 9 * peptideCount < nucleotideCount;
            }
            ResidueCount residueCounts = new ResidueCount(nucleotide);
            for (int row = 0; row < seqCount; ++row) {
                if (sequences[row] == null) {
                    Console.errPrintln("WARNING: Consensus skipping null sequence - possible race condition.");
                    continue;
                }
                if (sequences[row].getLength() > column) {
                    char c = sequences[row].getCharAt(column);
                    residueCounts.add(c);
                    if (Comparison.isNucleotide(c)) {
                        ++nucleotideCount;
                        continue;
                    }
                    if (Comparison.isGap(c)) continue;
                    ++peptideCount;
                    continue;
                }
                residueCounts.addGap();
            }
            int maxCount = residueCounts.getModalCount();
            String maxResidue = residueCounts.getResiduesForCount(maxCount);
            int gapCount = residueCounts.getGapCount();
            Profile profile = new Profile(seqCount, gapCount, maxCount, maxResidue);
            if (saveFullProfile) {
                profile.setCounts(residueCounts);
            }
            result[column] = profile;
        }
        return new Profiles(seqCount, result);
    }

    public static final ProfilesI calculateSS(List<SequenceI> list, int start, int end, String source) {
        return AAFrequency.calculateSS(list, start, end, false, source);
    }

    public static final ProfilesI calculateSS(List<SequenceI> sequences, int start, int end, boolean profile, String source) {
        return AAFrequency.calculateSS(sequences, start, end, profile, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ProfilesI calculateSS(List<SequenceI> sequences, int start, int end, boolean profile, String source, SequenceGroup sequenceGroup) {
        SequenceI[] seqs = new SequenceI[sequences.size()];
        int width = 0;
        List<SequenceI> list = sequences;
        synchronized (list) {
            for (int i = 0; i < sequences.size(); ++i) {
                seqs[i] = sequences.get(i);
                int length = seqs[i].getLength();
                if (length <= width) continue;
                width = length;
            }
            if (end >= width) {
                end = width;
            }
            ProfilesI reply = AAFrequency.calculateSS(seqs, width, start, end, profile, source, sequenceGroup);
            return reply;
        }
    }

    public static final ProfilesI calculateSS(SequenceI[] sequences, int width, int start, int end, boolean saveFullProfile, String source, SequenceGroup sequenceGroup) {
        int seqCount = sequences.length;
        ProfileI[] result = new ProfileI[width];
        int maxSSannotcount = 0;
        int maxSeqWithSScount = 0;
        if (source == null || "".equals(source)) {
            source = "All";
        }
        Map<SequenceI, ArrayList<AlignmentAnnotation>> sq_group_by_source = null;
        if (sequenceGroup != null && sequenceGroup.getAnnotationsFromTree().size() > 0 && source != null) {
            sq_group_by_source = AlignmentUtils.getSequenceAssociatedAlignmentAnnotations(sequenceGroup.getAnnotationsFromTree().toArray(new AlignmentAnnotation[0]), source);
        }
        for (int column = start; column < end; ++column) {
            int seqWithSSCount = 0;
            int ssCount = 0;
            SecondaryStructureCount ssCounts = new SecondaryStructureCount();
            for (int row = 0; row < seqCount; ++row) {
                List annots;
                if (sequences[row] == null) {
                    Console.errPrintln("WARNING: Consensus skipping null sequence - possible race condition.");
                    continue;
                }
                char c = sequences[row].getCharAt(column);
                if (sq_group_by_source == null) {
                    annots = AlignmentUtils.getAlignmentAnnotationForSource(sequences[row], source);
                } else {
                    annots = sq_group_by_source.get(sequences[row]);
                    if (annots == null) {
                        annots = sq_group_by_source.get(sequences[row].getDatasetSequence());
                    }
                }
                if (annots == null) continue;
                if (annots.size() > 0) {
                    ++seqWithSSCount;
                }
                for (AlignmentAnnotation aa : annots) {
                    if (aa != null) {
                        ++ssCount;
                    }
                    if (sequences[row].getLength() > column && !Comparison.isGap(c) && aa != null) {
                        int seqPosition = sequences[row].findPosition(column);
                        char ss = AlignmentUtils.findSSAnnotationForGivenSeqposition(aa, seqPosition);
                        if (ss == '*') continue;
                        ssCounts.add(ss);
                        continue;
                    }
                    if (!Comparison.isGap(c) || aa == null) continue;
                    ssCounts.addGap();
                }
            }
            int maxSSCount = ssCounts.getModalCount();
            String maxSS = ssCounts.getSSForCount(maxSSCount);
            int gapCount = ssCounts.getGapCount();
            Profile profile = new Profile(maxSS, ssCount, gapCount, maxSSCount, seqWithSSCount);
            maxSeqWithSScount = Math.max(maxSeqWithSScount, seqWithSSCount);
            if (saveFullProfile) {
                profile.setSSCounts(ssCounts);
            }
            result[column] = profile;
            maxSSannotcount = Math.max(maxSSannotcount, ssCount);
        }
        return new Profiles(maxSSannotcount, result);
    }

    public static ProfilesI calculateHMMProfiles(HiddenMarkovModel hmm, int width, int start, int end, boolean removeBelowBackground, boolean infoLetterHeight) {
        ProfileI[] result = new ProfileI[width];
        char[] symbols = hmm.getSymbols().toCharArray();
        int symbolCount = symbols.length;
        for (int column = start; column < end; ++column) {
            ResidueCount counts = new ResidueCount();
            for (char symbol : symbols) {
                int value = AAFrequency.getAnalogueCount(hmm, column, symbol, removeBelowBackground, infoLetterHeight);
                counts.put(symbol, value);
            }
            int maxCount = counts.getModalCount();
            String maxResidue = counts.getResiduesForCount(maxCount);
            int gapCount = counts.getGapCount();
            Profile profile = new Profile(symbolCount, gapCount, maxCount, maxResidue);
            profile.setCounts(counts);
            result[column] = profile;
        }
        return new Profiles(1, result);
    }

    static int estimateProfileSize(SparseIntArray profileSizes) {
        if (profileSizes.size() == 0) {
            return 4;
        }
        return profileSizes.keyAt(profileSizes.size() - 1);
    }

    public static void completeConsensus(AlignmentAnnotation consensus, ProfilesI profiles, int startCol, int endCol, boolean ignoreGaps, boolean showSequenceLogo, long nseq) {
        if (consensus == null || consensus.annotations == null || consensus.annotations.length < endCol) {
            return;
        }
        for (int i = startCol; i < endCol; ++i) {
            ProfileI profile = profiles.get(i);
            if (profile == null) {
                consensus.annotations[i] = null;
                return;
            }
            int dp = AAFrequency.getPercentageDp(nseq);
            float value = profile.getPercentageIdentity(ignoreGaps);
            String description = AAFrequency.getTooltip(profile, value, showSequenceLogo, ignoreGaps, dp);
            String modalResidue = profile.getModalResidue();
            if ("".equals(modalResidue)) {
                modalResidue = "-";
            } else if (modalResidue.length() > 1) {
                modalResidue = "+";
            }
            consensus.annotations[i] = new Annotation(modalResidue, description, ' ', value);
        }
    }

    public static void completeSSConsensus(AlignmentAnnotation ssConsensus, ProfilesI profiles, int startCol, int endCol, boolean ignoreGaps, boolean showSequenceLogo, long nseq) {
        if (ssConsensus == null || ssConsensus.annotations == null || ssConsensus.annotations.length < endCol) {
            return;
        }
        for (int i = startCol; i < endCol; ++i) {
            ProfileI profile = profiles.get(i);
            if (profile == null) {
                ssConsensus.annotations[i] = null;
                return;
            }
            if (ssConsensus.getNoOfSequencesIncluded() < 0L) {
                ssConsensus.setNoOfSequencesIncluded(profile.getSeqWithSSCount());
                ssConsensus.setNoOfTracksIncluded(profiles.getCount());
            }
            int dp = AAFrequency.getPercentageDp(nseq);
            float value = profile.getSSPercentageIdentity(ignoreGaps);
            String description = AAFrequency.getSSTooltip(profile, value, showSequenceLogo, ignoreGaps, dp);
            String modalSS = profile.getModalSS();
            if ("".equals(modalSS)) {
                modalSS = "-";
            } else if (modalSS.length() > 1) {
                modalSS = "+";
            }
            ssConsensus.annotations[i] = new Annotation(modalSS, description, ' ', value);
        }
        if (ssConsensus.getNoOfSequencesIncluded() < 1L) {
            ssConsensus.visible = false;
        }
    }

    public static float completeInformation(AlignmentAnnotation information, ProfilesI profiles, int startCol, int endCol) {
        if (information == null || information.annotations == null) {
            return 0.0f;
        }
        float max = 0.0f;
        SequenceI hmmSeq = information.sequenceRef;
        int seqLength = hmmSeq.getLength();
        if (information.annotations.length < seqLength) {
            return 0.0f;
        }
        HiddenMarkovModel hmm = hmmSeq.getHMM();
        for (int column = startCol; column < endCol && column < seqLength; ++column) {
            float value = hmm.getInformationContent(column);
            boolean isNaN = Float.isNaN(value);
            if (!isNaN) {
                max = Math.max(max, value);
            }
            String description = isNaN ? null : String.format("%.4f bits", Float.valueOf(value));
            information.annotations[column] = new Annotation(Character.toString(Character.toUpperCase(hmmSeq.getCharAt(column))), description, ' ', value);
        }
        information.graphMax = max;
        return max;
    }

    public static void completeGapAnnot(AlignmentAnnotation occupancy, ProfilesI profiles, int startCol, int endCol, long nseq) {
        if (occupancy == null || occupancy.annotations == null || occupancy.annotations.length < endCol) {
            return;
        }
        occupancy.graphMax = nseq;
        occupancy.graphMin = 0.0f;
        double scale = 0.8 / (double)nseq;
        for (int i = startCol; i < endCol; ++i) {
            ProfileI profile = profiles.get(i);
            if (profile == null) {
                occupancy.annotations[i] = null;
                return;
            }
            int gapped = profile.getNonGapped();
            String description = "" + gapped;
            occupancy.annotations[i] = new Annotation("", description, '\u0000', gapped, ColorUtils.bleachColour(Color.DARK_GRAY, (float)scale * (float)gapped));
        }
    }

    static String getTooltip(ProfileI profile, float pid, boolean showSequenceLogo, boolean ignoreGaps, int dp) {
        ResidueCount counts = profile.getCounts();
        String description = null;
        if (counts != null && showSequenceLogo) {
            int normaliseBy = ignoreGaps ? profile.getNonGapped() : profile.getHeight();
            description = counts.getTooltip(normaliseBy, dp);
        } else {
            StringBuilder sb = new StringBuilder(64);
            String maxRes = profile.getModalResidue();
            if (maxRes.length() > 1) {
                sb.append("[").append(maxRes).append("]");
            } else {
                sb.append(maxRes);
            }
            if (maxRes.length() > 0) {
                sb.append(" ");
                Format.appendPercentage(sb, pid, dp);
                sb.append("%");
            }
            description = sb.toString();
        }
        return description;
    }

    static String getSSTooltip(ProfileI profile, float pid, boolean showSequenceLogo, boolean ignoreGaps, int dp) {
        SecondaryStructureCount counts = profile.getSSCounts();
        String description = null;
        if (counts != null && showSequenceLogo) {
            int normaliseBy = ignoreGaps ? profile.getNonGapped() : profile.getHeight();
            description = counts.getTooltip(normaliseBy, dp);
        } else {
            StringBuilder sb = new StringBuilder(64);
            String maxSS = profile.getModalSS();
            if (maxSS.length() > 1) {
                sb.append("[").append(maxSS).append("]");
            } else {
                sb.append(maxSS);
            }
            if (maxSS.length() > 0) {
                sb.append(" ");
                Format.appendPercentage(sb, pid, dp);
                sb.append("%");
            }
            description = sb.toString();
        }
        return description;
    }

    public static int[] extractProfile(ProfileI profile, boolean ignoreGaps) {
        int[] values;
        char[] symbols;
        Object symbolCounts;
        Object counts;
        if (profile.getCounts() != null) {
            counts = profile.getCounts();
            symbolCounts = ((ResidueCount)counts).getSymbolCounts();
            symbols = ((ResidueCount.SymbolCounts)symbolCounts).symbols;
            values = ((ResidueCount.SymbolCounts)symbolCounts).values;
        } else if (profile.getSSCounts() != null) {
            counts = profile.getSSCounts();
            symbolCounts = ((SecondaryStructureCount)counts).getSymbolCounts();
            symbols = ((SecondaryStructureCount.SymbolCounts)symbolCounts).symbols;
            values = ((SecondaryStructureCount.SymbolCounts)symbolCounts).values;
        } else {
            return null;
        }
        QuickSort.sort(values, symbols);
        int totalPercentage = 0;
        int divisor = ignoreGaps ? profile.getNonGapped() : profile.getHeight();
        int[] result = new int[3 + 2 * symbols.length];
        int nextArrayPos = 3;
        int nonZeroCount = 0;
        for (int i = symbols.length - 1; i >= 0; --i) {
            int theChar = symbols[i];
            int charCount = values[i];
            int percentage = charCount * 100 / divisor;
            if (percentage == 0) break;
            ++nonZeroCount;
            result[nextArrayPos++] = theChar;
            result[nextArrayPos++] = percentage;
            totalPercentage += percentage;
        }
        if (nonZeroCount < symbols.length) {
            int[] tmp = new int[3 + 2 * nonZeroCount];
            System.arraycopy(result, 0, tmp, 0, tmp.length);
            result = tmp;
        }
        result[0] = 0;
        result[1] = nonZeroCount;
        result[2] = totalPercentage;
        return result;
    }

    public static int[] extractCdnaProfile(Hashtable<String, Object> hashtable, boolean ignoreGaps) {
        int percentage;
        int codonCount;
        int[] codonCounts = (int[])hashtable.get(PROFILE);
        int[] sortedCounts = new int[codonCounts.length - 2];
        System.arraycopy(codonCounts, 2, sortedCounts, 0, codonCounts.length - 2);
        int[] result = new int[3 + 2 * sortedCounts.length];
        result[0] = 2;
        char[] codons = new char[sortedCounts.length];
        for (int i = 0; i < codons.length; ++i) {
            codons[i] = (char)i;
        }
        QuickSort.sort(sortedCounts, codons);
        int totalPercentage = 0;
        int distinctValuesCount = 0;
        int j = 3;
        int divisor = ignoreGaps ? codonCounts[1] : codonCounts[0];
        for (int i = codons.length - 1; i >= 0 && (codonCount = sortedCounts[i]) != 0 && (percentage = codonCount * 100 / divisor) != 0; --i) {
            ++distinctValuesCount;
            result[j++] = codons[i];
            result[j++] = percentage;
            totalPercentage += percentage;
        }
        result[2] = totalPercentage;
        result[1] = distinctValuesCount;
        return Arrays.copyOfRange(result, 0, j);
    }

    public static void calculateCdna(AlignmentI alignment, Hashtable<String, Object>[] hconsensus) {
        char gapCharacter = alignment.getGapCharacter();
        List<AlignedCodonFrame> mappings = alignment.getCodonFrames();
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        int cols = alignment.getWidth();
        for (int col = 0; col < cols; ++col) {
            Hashtable<String, int[]> columnHash = new Hashtable<String, int[]>();
            int[] codonCounts = new int[66];
            codonCounts[0] = alignment.getSequences().size();
            int ungappedCount = 0;
            block1: for (SequenceI seq : alignment.getSequences()) {
                if (seq.getCharAt(col) == gapCharacter) continue;
                List<char[]> codons = MappingUtils.findCodonsFor(seq, col, mappings);
                for (char[] codon : codons) {
                    int codonEncoded = CodingUtils.encodeCodon(codon);
                    if (codonEncoded < 0) continue;
                    int n = codonEncoded + 2;
                    codonCounts[n] = codonCounts[n] + 1;
                    ++ungappedCount;
                    continue block1;
                }
            }
            codonCounts[1] = ungappedCount;
            columnHash.put(PROFILE, codonCounts);
            hconsensus[col] = columnHash;
        }
    }

    public static void completeCdnaConsensus(AlignmentAnnotation consensusAnnotation, Hashtable<String, Object>[] consensusData, boolean showProfileLogo, int nseqs) {
        if (consensusAnnotation == null || consensusAnnotation.annotations == null || consensusAnnotation.annotations.length < consensusData.length) {
            return;
        }
        consensusAnnotation.scaleColLabel = true;
        for (int col = 0; col < consensusData.length; ++col) {
            Hashtable<String, Object> hci = consensusData[col];
            if (hci == null) continue;
            int[] codonCounts = (int[])hci.get(PROFILE);
            int totalCount = 0;
            char[] codons = new char[codonCounts.length - 2];
            for (int j = 2; j < codonCounts.length; ++j) {
                int codonCount = codonCounts[j];
                codons[j - 2] = (char)(j - 2);
                totalCount += codonCount;
            }
            int[] sortedCodonCounts = new int[codonCounts.length - 2];
            System.arraycopy(codonCounts, 2, sortedCodonCounts, 0, codonCounts.length - 2);
            QuickSort.sort(sortedCodonCounts, codons);
            char modalCodonEncoded = codons[codons.length - 1];
            int modalCodonCount = sortedCodonCounts[codons.length - 1];
            String modalCodon = String.valueOf(CodingUtils.decodeCodon(modalCodonEncoded));
            if (sortedCodonCounts.length > 1 && sortedCodonCounts[codons.length - 2] == sortedCodonCounts[codons.length - 1]) {
                modalCodon = "+";
            }
            float pid = (float)(sortedCodonCounts[sortedCodonCounts.length - 1] * 100) / (float)totalCount;
            StringBuilder mouseOver = new StringBuilder(32);
            StringBuilder samePercent = new StringBuilder();
            String percent = null;
            String lastPercent = null;
            int percentDecPl = AAFrequency.getPercentageDp(nseqs);
            for (int j = codons.length - 1; j >= 0; --j) {
                int codonCount = sortedCodonCounts[j];
                if (codonCount == 0) {
                    if (samePercent.length() <= 0) break;
                    mouseOver.append((CharSequence)samePercent).append(": ").append(percent).append("% ");
                    break;
                }
                char codonEncoded = codons[j];
                int pct = codonCount * 100 / totalCount;
                String codon = String.valueOf(CodingUtils.decodeCodon(codonEncoded));
                StringBuilder sb = new StringBuilder();
                Format.appendPercentage(sb, pct, percentDecPl);
                percent = sb.toString();
                if (!showProfileLogo && codonCount != modalCodonCount) continue;
                if (percent.equals(lastPercent) && j > 0) {
                    samePercent.append(samePercent.length() == 0 ? "" : ", ");
                    samePercent.append(codon);
                } else {
                    if (samePercent.length() > 0) {
                        mouseOver.append((CharSequence)samePercent).append(": ").append(lastPercent).append("% ");
                    }
                    samePercent.setLength(0);
                    samePercent.append(codon);
                }
                lastPercent = percent;
            }
            consensusAnnotation.annotations[col] = new Annotation(modalCodon, mouseOver.toString(), ' ', pid);
        }
    }

    protected static int getPercentageDp(long nseq) {
        int scale = 0;
        while (nseq >= 100L) {
            ++scale;
            nseq /= 10L;
        }
        return scale;
    }

    public static int[] extractHMMProfile(HiddenMarkovModel hmm, int column, boolean removeBelowBackground, boolean infoHeight) {
        if (hmm == null) {
            return null;
        }
        String alphabet = hmm.getSymbols();
        int size = alphabet.length();
        char[] symbols = new char[size];
        int[] values = new int[size];
        int totalCount = 0;
        for (int i = 0; i < size; ++i) {
            int value;
            char symbol;
            symbols[i] = symbol = alphabet.charAt(i);
            values[i] = value = AAFrequency.getAnalogueCount(hmm, column, symbol, removeBelowBackground, infoHeight);
            totalCount += value;
        }
        QuickSort.sort(values, symbols);
        int[] profile = new int[3 + size * 2];
        profile[0] = 0;
        profile[1] = size;
        profile[2] = 100;
        if (totalCount != 0) {
            int arrayPos = 3;
            for (int k = size - 1; k >= 0; --k) {
                int value = values[k];
                Float percentage = removeBelowBackground ? Float.valueOf((float)value / (float)totalCount * 100.0f) : Float.valueOf((float)value / 100.0f);
                int intPercent = Math.round(percentage.floatValue());
                profile[arrayPos] = symbols[k];
                profile[arrayPos + 1] = intPercent;
                arrayPos += 2;
            }
        }
        return profile;
    }

    static int getAnalogueCount(HiddenMarkovModel hmm, int column, char symbol, boolean removeBelowBackground, boolean infoHeight) {
        double freq;
        double value = hmm.getMatchEmissionProbability(column, symbol);
        if (value < (freq = (double)ResidueProperties.backgroundFrequencies.get(hmm.getAlphabetType()).get(Character.valueOf(symbol)).floatValue()) && removeBelowBackground) {
            return 0;
        }
        if (infoHeight) {
            value *= Math.log(value / freq) / LOG2;
        }
        return Math.round((float)(value *= 10000.0));
    }
}

