/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.PartialBuffer;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringBufferLike;
import com.stevesoft.pat.Transformer;
import com.stevesoft.pat.wrap.WriterWrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RegexWriter
extends Writer {
    Replacer repr;
    Writer w;
    WriterWrap ww;
    StringBuffer sb = new StringBuffer();
    PartialBuffer wrap = new PartialBuffer(this.sb);
    int pos;
    int epos;
    int interval = 128;
    int bufferSize = 2048;
    char EOLchar = (char)10;
    int max_lines = 2;

    public RegexWriter(Transformer t, Writer w) {
        this.w = w;
        this.ww = new WriterWrap(w);
        this.repr = t.getReplacer();
        this.repr.setBuffer(new StringBufferLike(this.ww));
        this.repr.setSource(this.wrap);
    }

    public RegexWriter(Regex r, Writer w) {
        this.w = w;
        this.ww = new WriterWrap(w);
        this.repr = r.getReplacer();
        this.repr.setBuffer(new StringBufferLike(this.ww));
        this.repr.setSource(this.wrap);
    }

    @Deprecated
    public char getEOLchar() {
        return this.EOLchar;
    }

    @Deprecated
    public void setEOLchar(char c) {
        this.EOLchar = c;
    }

    @Deprecated
    public int getMaxLines() {
        return this.max_lines;
    }

    @Deprecated
    public void setMaxLines(int ml) {
        this.max_lines = ml;
    }

    void write() throws IOException {
        Regex rex = this.repr.getRegex();
        int eposOld = this.epos;
        if (rex.matchAt(this.wrap, this.epos) && !this.wrap.overRun) {
            while (this.pos < this.epos) {
                this.w.write(this.sb.charAt(this.pos++));
            }
            int to = rex.matchedTo();
            this.repr.setPos(to);
            this.repr.apply(rex, rex.getReplaceRule());
            this.epos = this.pos = to;
            if (this.epos == eposOld && this.epos < this.sb.length()) {
                ++this.epos;
            }
        } else if (!this.wrap.overRun && this.epos < this.sb.length()) {
            ++this.epos;
        }
        while (this.pos < this.epos) {
            this.w.write(this.sb.charAt(this.pos++));
        }
        if (this.epos == this.sb.length()) {
            this.sb.setLength(1);
            this.epos = 1;
            this.pos = 1;
        } else if (this.pos > this.bufferSize) {
            for (int i = this.bufferSize; i < this.sb.length(); ++i) {
                this.sb.setCharAt(i - this.bufferSize, this.sb.charAt(i));
            }
            this.pos -= this.bufferSize;
            this.epos -= this.bufferSize;
            this.sb.setLength(this.sb.length() - this.bufferSize);
        }
    }

    @Override
    public void write(char[] ca, int b, int n) throws IOException {
        int m = b + n;
        for (int i = b; i < m; ++i) {
            this.sb.append(ca[i]);
            if (this.sb.length() % this.interval != this.interval - 1) continue;
            this.wrap.overRun = false;
            while (this.epos + this.interval < this.sb.length() && !this.wrap.overRun) {
                this.write();
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.wrap.allowOverRun = false;
        this.wrap.overRun = false;
        while (this.epos < this.sb.length()) {
            this.write();
        }
        this.write();
        this.w.close();
    }

    public int length() {
        return this.sb.length();
    }

    public char charAt(int i) {
        return this.sb.charAt(i);
    }

    public void setInterval(int i) {
        this.interval = i;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int i) {
        this.bufferSize = i;
    }

    static void test(String re, String inp, int n) throws Exception {
        StringWriter sw = new StringWriter();
        Regex rex = Regex.perlCode(re);
        String res1 = rex.replaceAll(inp);
        RegexWriter rw = new RegexWriter(rex, (Writer)sw);
        for (int i = 0; i < inp.length(); ++i) {
            rw.write(inp.charAt(i));
        }
        rw.close();
        String res2 = sw.toString();
        if (!res1.equals(res2)) {
            System.out.println("nmax=" + n);
            System.out.println("re=" + re);
            System.out.println("inp=" + inp);
            System.out.println("res1=" + res1);
            System.out.println("res2=" + res2);
            System.exit(255);
        }
    }

    public static void main(String[] args) throws Exception {
        for (int n = 1; n <= 1; ++n) {
            RegexWriter.test("s/x/y/", "-----x123456789", n);
            RegexWriter.test("s/x/y/", "x123456789", n);
            RegexWriter.test("s/x/y/", "-----x", n);
            RegexWriter.test("s/x.*?x/y/", ".xx..x..x...x...x....x....x", n);
            RegexWriter.test("s/x.*x/[$&]/", "--x........x--xx", n);
            RegexWriter.test("s/x.*x/[$&]/", "--x........x------", n);
            RegexWriter.test("s/.$/a/m", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbbbbbbbbbbbb", n);
            RegexWriter.test("s/.$/a/", "123", n);
            RegexWriter.test("s/.$/a/", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbb", n);
            RegexWriter.test("s/^./a/", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbb", n);
            RegexWriter.test("s/$/a/", "bbb", n);
            RegexWriter.test("s/^/a/", "bbb", n);
            RegexWriter.test("s/^/a/", "", n);
            RegexWriter.test("s{.*}{N}", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", n);
            RegexWriter.test("s/.{0,7}/y/", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", n);
            RegexWriter.test("s/x/$&/", "xxx", n);
        }
        System.out.println("Success!!!");
    }
}

