/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobStatus;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.util.FileUtil;
import compbio.util.Util;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class WSTester {
    public static final String fastaInput2records = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV\n>Bar\nASDAAPEHPGIALWLHALEDAGQAEAAAAYTRAHQLLPEEPYITAQLLNAVA\n";
    public static final String fastaInput1record = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV\n";
    public static final String fastaAlignment = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV--------\n>Bar\nASDAAPEH------------PGIALWLHALE-DAGQAEAAA---AYTRAHQLLPEEPYITAQLLNAVA\n";
    public static final String fastaRNAAlignment = ">Foo\nC-UUGCGUUAAUGAGAACAGAAACG-UAAA--CUAUAA-CCUAG-G-GGUUUCUGUUGGAUGGUUG----GCAAC\n>Bar\nG-UGGCGCUUAUGACGCAGUUGUCU-UAAA-CUCGAAC--UCGA-GCGGGCAAUUGCUGAU-UACGAUUAACCAC\n";
    public static final String clustalRNAAlignment = "CLUSTAL\nFoo             C-UUGCGUUAAUGAGAACAGAAACG-UAAA--CUAUAA-CCUAG-G-GGUUUCUGUUGGA\nBar             G-UGGCGCUUAUGACGCAGUUGUCU-UAAA-CUCGAAC--UCGA-GCGGGCAAUUGCUGA\nFoo             UGGUUG----GCAAC\nBar             U-UACGAUUAACCAC";
    private static final String FAILED = "FAILED";
    private static final String OK = "OK";
    private static final String UNSUPPORTED = "UNSUPPORTED";
    private final PrintWriter writer;
    private final String hostname;

    private static List<FastaSequence> loadSeqs(int nLines) {
        try {
            if (nLines == 1) {
                return SequenceUtil.readFasta(new ByteArrayInputStream(fastaInput1record.getBytes()));
            }
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaInput2records.getBytes()));
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static List<FastaSequence> loadAlignment() {
        try {
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaAlignment.getBytes()));
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static List<FastaSequence> loadRNAAlignment() {
        try {
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaRNAAlignment.getBytes()));
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    public WSTester(String hostname, PrintWriter writer) {
        if (Util.isEmpty(hostname)) {
            throw new NullPointerException("Hostname must be provided!");
        }
        this.hostname = hostname;
        this.writer = writer;
    }

    static void printUsage() {
        System.out.println("Usage: <Class or Jar file name> -h=host_and_context <-s=serviceName>");
        System.out.println();
        System.out.println("-h=<host_and_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws");
        System.out.println("-s=<ServiceName> - optional if unspecified all services are tested otherwise one of " + Arrays.toString((Object[])Services.values()));
        System.out.println();
    }

    private <T> boolean presetAlign(MsaWS<T> msaws, List<Preset<T>> presets) throws UnsupportedRuntimeException {
        boolean succeed = false;
        for (Preset<T> preset : presets) {
            this.writer.print("Aligning with preset '" + preset.getName() + "'... ");
            Alignment al = null;
            try {
                String taskId = msaws.presetAlign(WSTester.loadSeqs(2), preset);
                al = msaws.getResult(taskId);
                if (al != null) {
                    this.writer.println(OK);
                }
                succeed = true;
            }
            catch (Exception e) {
                if (e instanceof UnsupportedRuntimeException) {
                    throw (UnsupportedRuntimeException)e;
                }
                this.reportException(e);
            }
        }
        return succeed;
    }

    private <T> boolean testMsaWS(MsaWS<T> msaws, Services service) throws Exception {
        assert (msaws != null);
        boolean succeed = this.testDefaultAlignment(msaws, service);
        PresetManager pmanager = msaws.getPresets();
        if (pmanager != null && pmanager.getPresets().size() > 0) {
            this.writer.println("Testing alignment with presets:");
            List plist = pmanager.getPresets();
            succeed = !succeed ? this.presetAlign(msaws, plist) : succeed;
        }
        this.testMetadata(msaws);
        return succeed;
    }

    private <T> boolean checkService(JABAService wservice, Services service) {
        try {
            if (wservice == null) {
                throw new NullPointerException("JABAService instance must be provided!");
            }
            if (wservice instanceof MsaWS) {
                return this.testMsaWS((MsaWS)wservice, service);
            }
            if (wservice instanceof SequenceAnnotation) {
                return this.testSequenceAnnotationWS((SequenceAnnotation)wservice, service);
            }
            throw new UnsupportedOperationException("The service: " + wservice.getClass() + " is not supported! ");
        }
        catch (Exception e) {
            this.reportException(e);
            return false;
        }
    }

    private <T> boolean testSequenceAnnotationWS(SequenceAnnotation<T> wservice, Services service) throws Exception {
        List presets;
        this.writer.print("Calling annotation test.........");
        List<FastaSequence> input = WSTester.loadSeqs(2);
        if (service == Services.AAConWS) {
            input = WSTester.loadAlignment();
        } else if (service == Services.RNAalifoldWS) {
            input = WSTester.loadRNAAlignment();
        }
        boolean success = this.testDefaultAnalyse(input, wservice, null, null);
        PresetManager presetman = wservice.getPresets();
        if (presetman != null && (presets = presetman.getPresets()) != null && !presets.isEmpty()) {
            Preset preset = presets.get(0);
            this.writer.print("Calling analyse with Preset.........");
            success = this.testDefaultAnalyse(input, wservice, preset, null);
        }
        this.testMetadata(wservice);
        return success;
    }

    private <T> boolean testDefaultAnalyse(List<FastaSequence> fastalist, SequenceAnnotation<T> wsproxy, Preset<T> preset, List<Option<T>> customOptions) throws Exception {
        ScoreManager scores = null;
        String jobId = null;
        jobId = customOptions != null ? wsproxy.customAnalize(fastalist, customOptions) : (preset != null ? wsproxy.presetAnalize(fastalist, preset) : wsproxy.analize(fastalist));
        Thread.sleep(1000L);
        scores = wsproxy.getAnnotation(jobId);
        if (scores != null) {
            this.writer.println(OK);
        }
        return scores != null;
    }

    private void reportException(Exception e) {
        this.writer.println(FAILED);
        this.writer.println("Exception while waiting for results. Exception details are below:");
        this.writer.println(e.getLocalizedMessage());
        e.printStackTrace(this.writer);
    }

    private <T> void testMetadata(Metadata<T> msaws) throws UnsupportedRuntimeException {
        this.writer.print("Querying presets...");
        PresetManager<T> pmanager = msaws.getPresets();
        if (pmanager != null && pmanager.getPresets().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Parameters...");
        RunnerConfig<T> options = msaws.getRunnerOptions();
        if (options != null && options.getArguments().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Limits...");
        LimitsManager<T> limits = msaws.getLimits();
        if (limits != null && limits.getLimits().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Local Engine Limits...");
        Limit<T> localLimit = msaws.getLimit("# LocalEngineExecutionLimit #");
        if (localLimit != null) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
    }

    private <T> boolean testDefaultAlignment(MsaWS<T> msaws, Services service) throws Exception {
        this.writer.print("Testing alignment with default parameters:");
        Alignment al = null;
        boolean succeed = false;
        String taskId = msaws.align(WSTester.loadSeqs(2));
        this.writer.print("\nQuerying job status...");
        JobStatus status = msaws.getJobStatus(taskId);
        while (status != JobStatus.FINISHED) {
            Thread.sleep(1000L);
            status = msaws.getJobStatus(taskId);
        }
        this.writer.println(OK);
        this.writer.print("Retrieving results...");
        al = msaws.getResult(taskId);
        succeed = true;
        if (al != null) {
            this.writer.println(OK);
        }
        return succeed;
    }

    public static <T> void main(String[] args) throws IOException {
        if (args == null || args.length < 1) {
            WSTester.printUsage();
            System.exit(0);
        }
        String host = CmdHelper.getHost(args);
        String serviceName = CmdHelper.getServiceName(args);
        if (!Jws2Client.validURL(host)) {
            System.err.println("<host_and_context> parameter is not provided or is incorrect!");
            System.exit(1);
        }
        WSTester tester = new WSTester(host, new PrintWriter(System.out, true));
        if (serviceName != null) {
            Services service = Services.getService(serviceName);
            if (service == null) {
                tester.writer.println("Service '" + serviceName + "' is not supported. Valid values are: " + Arrays.toString((Object[])Services.values()));
                tester.writer.println();
                WSTester.printUsage();
                System.exit(1);
            }
            tester.checkService(service);
            System.exit(0);
        }
        tester.writer.println("<ServiceName> is not provided checking all known services...");
        for (Services serv : Services.values()) {
            tester.writer.println();
            tester.checkService(serv);
        }
    }

    private JABAService connect(String host, Services service) throws WebServiceException, ConnectException {
        URL url = null;
        System.out.println("Attempting to connect with " + service.toString() + "...");
        try {
            url = new URL(host + "/" + service.toString() + "?wsdl");
            System.out.println("URL: " + url.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Service serv = null;
        try {
            serv = service.getService(url, service.getServiceNamespace());
        }
        catch (WebServiceException wse) {
            wse.printStackTrace();
        }
        if (serv == null) {
            throw new ConnectException("Could not connect to " + url + ". Is the server down?");
        }
        JABAService srv = service.getInterface(serv);
        System.out.println("Connected successfully!");
        return srv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkService(Services service) throws ConnectException, WebServiceException {
        JABAService ws = this.connect(this.hostname, service);
        if (ws == null) {
            String line = "Cannot estabilish the connection to host " + this.hostname + " with service ";
            this.writer.println(line + service.toString());
            return false;
        }
        boolean succeed = false;
        try {
            this.writer.println("Checking service " + service.toString());
            succeed = this.checkService(ws, service);
        }
        finally {
            FileUtil.closeSilently((Closeable)((Object)ws));
        }
        this.reportResults(service, succeed);
        return succeed;
    }

    private void reportResults(Services serv, boolean succeed) {
        if (succeed) {
            this.writer.println("Check is completed. The Service " + (Object)((Object)serv) + " IS WORKING\n");
        } else {
            this.writer.println("Check is aborted. The Service " + (Object)((Object)serv) + " HAS SOME PROBLEMS\n");
        }
    }
}

