/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.LimitExceededException;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import compbio.ws.server.IUPredWS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestIUPredWS {
    SequenceAnnotation<IUPredWS> msaws;

    @BeforeTest(groups={"webservices"})
    void initConnection() {
        try {
            JABAService client = Jws2Client.connect("http://localhost:8080/jabaws", Services.IUPredWS);
            this.msaws = (SequenceAnnotation)client;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void testCustomAnalize() throws FileNotFoundException, IOException {
        String CURRENT_DIRECTORY = SysPrefs.getCurrentDirectory() + File.separator;
        List<FastaSequence> fsl = SequenceUtil.readFasta(new FileInputStream(CURRENT_DIRECTORY + "testsrc" + File.separator + "testdata" + File.separator + "TO1381.fasta"));
        try {
            ArrayList opts = new ArrayList();
            opts.add(this.msaws.getRunnerOptions().getArgumentByOptionName("Long"));
            String jobId = this.msaws.customAnalize(fsl, opts);
            System.out.println("J: " + jobId);
            ScoreManager result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
        }
        catch (UnsupportedRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LimitExceededException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JobSubmissionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (ResultNotAvailableException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

