/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.runner.conservation.AACon;
import compbio.util.SysPrefs;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestAAConWS {
    SequenceAnnotation<AACon> msaws;

    @BeforeTest(groups={"webservices"})
    void initConnection() {
        try {
            JABAService client = Jws2Client.connect("http://localhost:8080/jabaws", Services.AAConWS);
            this.msaws = (SequenceAnnotation)client;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void testAnalize() throws FileNotFoundException, IOException {
        String CURRENT_DIRECTORY = SysPrefs.getCurrentDirectory() + File.separator;
        List<FastaSequence> fsl = SequenceUtil.readFasta(new FileInputStream(CURRENT_DIRECTORY + "testsrc" + File.separator + "testdata" + File.separator + "TO1381.fasta.aln"));
        try {
            System.out.println("Pres: " + this.msaws.getPresets().getPresets());
            String jobId = this.msaws.analize(fsl);
            System.out.println("J: " + jobId);
            ScoreManager result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)1);
            Assert.assertEquals((String)result.asSet().iterator().next().getMethod(), (String)ConservationMethod.SHENKIN.toString());
            ArrayList<Float> scores = result.asSet().iterator().next().getScores();
            Assert.assertNotNull(scores);
            Assert.assertEquals((int)scores.size(), (int)568);
            PresetManager presets = this.msaws.getPresets();
            jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Quick conservation"));
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)13);
            jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Slow conservation"));
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)5);
            jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Complete conservation"));
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)18);
        }
        catch (UnsupportedRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LimitExceededException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JobSubmissionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (ResultNotAvailableException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void testRecoverArgsForPreset() throws Exception {
        PresetManager presets = this.msaws.getPresets();
        for (Preset preset : presets.getPresets()) {
            List args = preset.getArguments(this.msaws.getRunnerOptions());
            List<String> opts = preset.getOptions();
            Assert.assertTrue((args.size() >= opts.size() ? 1 : 0) != 0, (String)("Couldn't recover all Option items for preset " + preset.getName()));
        }
    }

    @Test(groups={"webservices"})
    public void testPresetAnalize() throws FileNotFoundException, IOException {
        String CURRENT_DIRECTORY = SysPrefs.getCurrentDirectory() + File.separator;
        List<FastaSequence> fsl = SequenceUtil.readFasta(new FileInputStream(CURRENT_DIRECTORY + "testsrc" + File.separator + "testdata" + File.separator + "TO1381.fasta.aln"));
        try {
            System.out.println("Pres: " + this.msaws.getPresets().getPresets());
            PresetManager presets = this.msaws.getPresets();
            String jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Quick conservation"));
            ScoreManager result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)13);
            jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Slow conservation"));
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)5);
            jobId = this.msaws.presetAnalize(fsl, presets.getPresetByName("Complete conservation"));
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)18);
        }
        catch (UnsupportedRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LimitExceededException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JobSubmissionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (ResultNotAvailableException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void testCustomAnalize() throws FileNotFoundException, IOException {
        String CURRENT_DIRECTORY = SysPrefs.getCurrentDirectory() + File.separator;
        List<FastaSequence> fsl = SequenceUtil.readFasta(new FileInputStream(CURRENT_DIRECTORY + "testsrc" + File.separator + "testdata" + File.separator + "TO1381.fasta.aln"));
        RunnerConfig options = this.msaws.getRunnerOptions();
        try {
            ArrayList args = new ArrayList();
            Option arg = options.getArgument("SMERFS");
            args.add(arg);
            Option normarg = options.getArgument("Normalize");
            args.add(normarg);
            arg.setValue(arg.getPossibleValues().get(0));
            String jobId = this.msaws.customAnalize(fsl, args);
            ScoreManager result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)1);
            Assert.assertEquals((Object)result.asSet().iterator().next().getScores().get(0), (Object)Float.valueOf(0.698f));
            args.remove(normarg);
            jobId = this.msaws.customAnalize(fsl, args);
            result = this.msaws.getAnnotation(jobId);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((int)result.asSet().size(), (int)1);
            Assert.assertEquals((Object)result.asSet().iterator().next().getScores().get(0), (Object)Float.valueOf(0.401f));
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedRuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (LimitExceededException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JobSubmissionException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (ResultNotAvailableException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

