/*
 * Decompiled with CFR 0.152.
 */
package compbio.util.toys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Grep {
    private static Charset charset = Charset.forName("ISO-8859-15");
    private static CharsetDecoder decoder = charset.newDecoder();
    private static Pattern linePattern = Pattern.compile(".*\r?\n");
    private static Pattern pattern;

    private static void compile(String pat) {
        try {
            pattern = Pattern.compile(pat);
        }
        catch (PatternSyntaxException x) {
            System.err.println(x.getMessage());
            System.exit(1);
        }
    }

    private static void grep(File f, CharBuffer cb) {
        Matcher lm = linePattern.matcher(cb);
        Matcher pm = null;
        int lines = 0;
        while (lm.find()) {
            ++lines;
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                System.out.print(f + ":" + lines + ":" + cs);
            }
            if (lm.end() != cb.limit()) continue;
            break;
        }
    }

    private static void grep(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        FileChannel fc = fis.getChannel();
        int sz = (int)fc.size();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        CharBuffer cb = decoder.decode(bb);
        Grep.grep(f, cb);
        fc.close();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java Grep pattern file...");
            return;
        }
        Grep.compile(args[0]);
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]);
            try {
                Grep.grep(f);
                continue;
            }
            catch (IOException x) {
                System.err.println(f + ": " + x);
            }
        }
    }
}

