/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.metadata.AllTestSuit;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.msa.Mafft;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class PresetTester {
    public static final String input = AllTestSuit.TEST_DATA_PATH + "MafftPresets.xml";
    public static String test_input = AllTestSuit.TEST_DATA_PATH_ABSOLUTE + "MafftParameters.xml";
    PresetManager<Mafft> presets = null;
    RunnerConfig<Mafft> rconfParams = null;

    @BeforeTest(enabled=true)
    public void loadPresets() {
        try {
            RunnerConfigMarshaller rconfigPresets = new RunnerConfigMarshaller(PresetManager.class);
            File infile = new File(input);
            Assert.assertTrue((boolean)infile.exists());
            this.presets = (PresetManager)rconfigPresets.read((InputStream)new FileInputStream(infile), PresetManager.class);
            Assert.assertNotNull(this.presets);
            Assert.assertFalse((boolean)this.presets.preset.isEmpty());
            File input = new File(test_input);
            Assert.assertTrue((boolean)input.exists());
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RunnerConfig.class});
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement rconfigParams = um.unmarshal((Source)new StreamSource(input), RunnerConfig.class);
            this.rconfParams = (RunnerConfig)rconfigParams.getValue();
            Assert.assertNotNull(this.rconfParams);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void marshallPreset() {
        try {
            RunnerConfigMarshaller rconfig = new RunnerConfigMarshaller(PresetManager.class);
            PresetManager<Mafft> pman = PresetTester.getPresets();
            Assert.assertNotNull(pman);
            rconfig.readAndValidate((InputStream)new FileInputStream(new File(input)), PresetManager.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void validatePresets() {
        Assert.assertNotNull(this.presets);
        Assert.assertEquals((int)this.presets.getPresets().size(), (int)6);
        try {
            for (Preset<Mafft> pr : this.presets.getPresets()) {
                List<Option<Mafft>> options = pr.getArguments(this.rconfParams);
                Assert.assertFalse((boolean)options.isEmpty());
                if (pr.name.equals("L-INS-i (Accuracy-oriented)")) {
                    Assert.assertEquals((int)options.size(), (int)2);
                    Option<Mafft> o = options.get(0);
                    if (o.name.equals("Pairwise alignment computation method")) {
                        List<String> onames = o.getOptionNames();
                        boolean match = false;
                        for (String oname : onames) {
                            if (!oname.equals("--localpair")) continue;
                            match = true;
                            break;
                        }
                        Assert.assertTrue((boolean)match);
                    }
                }
                if (!pr.name.equals("NW-NS-PartTree-1 (Speed oriented)")) continue;
                Assert.assertEquals((int)options.size(), (int)4);
            }
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPresetWithMuptiOptions() {
        Assert.assertNotNull(this.presets);
        Assert.assertEquals((int)this.presets.getPresets().size(), (int)6);
        try {
            for (Preset<Mafft> pr : this.presets.getPresets()) {
                List<Option<Mafft>> options = pr.getArguments(this.rconfParams);
                Assert.assertFalse((boolean)options.isEmpty());
                if (pr.name.equals("E-INS-i (Accuracy-oriented)")) {
                    Assert.assertEquals((int)options.size(), (int)3);
                    Option<Mafft> o = options.get(0);
                    if (o.name.equals("Pairwise alignment computation method")) {
                        List<String> onames = o.getOptionNames();
                        boolean match = false;
                        for (String oname : onames) {
                            if (!oname.equals("--genafpair")) continue;
                            match = true;
                            break;
                        }
                        Assert.assertTrue((boolean)match);
                    }
                }
                if (!pr.name.equals("NW-NS-PartTree-1 (Speed oriented)")) continue;
                Assert.assertEquals((int)options.size(), (int)4);
            }
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static PresetManager<Mafft> getPresets() {
        Preset preset1 = new Preset();
        preset1.name = "L-INS-i (Accuracy-oriented)";
        preset1.description = "dsfjkg fdjksghkjsgdfh jksdfg sdfgkjhsdfgk kjsdfg ";
        ArrayList<String> optionNames = new ArrayList<String>();
        optionNames.add("--localpair");
        optionNames.add("--maxiterate 1000");
        preset1.option = optionNames;
        PresetManager<Mafft> prman = new PresetManager<Mafft>();
        prman.preset = Collections.singletonList(preset1);
        prman.runnerClassName = Mafft.class.getCanonicalName();
        return prman;
    }
}

