/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

public class Range
implements Comparable<Range> {
    public final int from;
    public final int to;

    private Range() {
        this.to = this.from = 0;
    }

    public Range(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public Range(String[] twoElementAr) {
        if (twoElementAr == null || twoElementAr.length != 2) {
            throw new IllegalArgumentException();
        }
        this.from = Integer.parseInt(twoElementAr[0].trim());
        this.to = Integer.parseInt(twoElementAr[1].trim());
    }

    public String toString() {
        return this.from + "-" + this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from;
        result = 31 * result + this.to;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.from != other.from) {
            return false;
        }
        return this.to == other.to;
    }

    @Override
    public int compareTo(Range o) {
        if (o == null) {
            return 1;
        }
        if (new Integer(this.from).compareTo(new Integer(o.from)) != 0) {
            return new Integer(this.from).compareTo(new Integer(o.from));
        }
        return new Integer(this.to).compareTo(new Integer(o.to));
    }
}

