/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class FastaSequenceGenerator {
    final SeqType seqtype;
    final int seqNumber;
    final Random rand;

    public FastaSequenceGenerator(SeqType type, int seqNumber) {
        this.seqtype = type;
        this.seqNumber = seqNumber;
        this.rand = new Random();
    }

    public List<FastaSequence> generateFasta(int maxSeqLength) {
        ArrayList<FastaSequence> fastal = new ArrayList<FastaSequence>();
        FastaSequence seq = null;
        for (int i = 0; i < this.seqNumber; ++i) {
            switch (this.seqtype) {
                case DNA: {
                    seq = new FastaSequence(this.generateName(), this.generateDna(maxSeqLength, this.getRandomNumber(0.5, 0.99)));
                    break;
                }
                case PROTEIN: {
                    seq = new FastaSequence(this.generateName(), this.generateProtein(maxSeqLength, this.getRandomNumber(0.5, 0.99)));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Cannot recognise a type!");
                }
            }
            fastal.add(seq);
        }
        return fastal;
    }

    private String generateName() {
        Letters[] letters = Letters.values();
        int max = letters.length - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append((Object)letters[this.getRandomNumber(0, max)]);
        }
        return sb.toString();
    }

    private String generateProtein(int length, double variability) {
        ProteinAlphabet[] proteinA = ProteinAlphabet.values();
        int max = proteinA.length - 1;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((double)i < (double)length * variability) {
            sb.append((Object)proteinA[this.getRandomNumber(max)]);
            ++i;
        }
        return sb.toString();
    }

    private String generateDna(int length, double variability) {
        if (variability == 0.0) {
            variability = 1.0;
        }
        DNAAlphabet[] dnaA = DNAAlphabet.values();
        int max = dnaA.length - 1;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((double)i < (double)length * variability) {
            sb.append((Object)dnaA[this.getRandomNumber(max)]);
            ++i;
        }
        return sb.toString();
    }

    private int getRandomNumber(int max) {
        return this.rand.nextInt(max);
    }

    private int getRandomNumber(int min, int max) {
        return new Long(Math.round((double)(max - min) * this.rand.nextDouble() + (double)min)).intValue();
    }

    private double getRandomNumber(double min, double max) {
        return (max - min) * this.rand.nextDouble() + min;
    }

    static enum Letters {
        q,
        w,
        e,
        r,
        t,
        y,
        u,
        i,
        o,
        p,
        a,
        s,
        d,
        f,
        g,
        h,
        j,
        k,
        l,
        z,
        x,
        c,
        v,
        b,
        n,
        m;

    }

    static enum DNAAlphabet {
        C,
        T,
        G,
        A,
        U;

    }

    static enum ProteinAlphabet {
        A,
        R,
        N,
        D,
        C,
        E,
        Q,
        G,
        H,
        I,
        L,
        K,
        M,
        F,
        P,
        S,
        T,
        W,
        V;

    }

    static enum SeqType {
        DNA,
        PROTEIN;

    }
}

