/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.SequenceUtil;
import compbio.util.SysPrefs;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FastaSequence {
    private String id;
    private String sequence;

    FastaSequence() {
    }

    public FastaSequence(String id, String sequence) {
        this.id = id;
        this.sequence = SequenceUtil.cleanSequence(sequence);
    }

    public String getId() {
        return this.id;
    }

    public String getSequence() {
        return this.sequence;
    }

    public static int countMatchesInSequence(String theString, String theRegExp) {
        Pattern p = Pattern.compile(theRegExp);
        Matcher m = p.matcher(theString);
        int cnt = 0;
        while (m.find()) {
            ++cnt;
        }
        return cnt;
    }

    public String getFormattedFasta() {
        return this.getFormatedSequence(80);
    }

    public String getOnelineFasta() {
        String fasta = ">" + this.getId() + SysPrefs.newlinechar;
        fasta = fasta + this.getSequence() + SysPrefs.newlinechar;
        return fasta;
    }

    public String getFormatedSequence(int width) {
        if (this.sequence == null) {
            return "";
        }
        assert (width >= 0) : "Wrong width parameter ";
        StringBuilder sb = new StringBuilder(this.sequence);
        int tailLen = this.sequence.length() % width;
        int nchunks = (this.sequence.length() - tailLen) / width;
        int nlineCharcounter = 0;
        int insPos = 0;
        for (int i = 1; i <= nchunks; ++i) {
            insPos = width * i + nlineCharcounter;
            if (sb.length() <= insPos) break;
            sb.insert(insPos, "\n");
            ++nlineCharcounter;
        }
        return sb.toString();
    }

    public int getLength() {
        return this.sequence.length();
    }

    public String toString() {
        return this.getOnelineFasta();
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 17 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastaSequence)) {
            return false;
        }
        FastaSequence fs = (FastaSequence)obj;
        if (!fs.getId().equals(this.getId())) {
            return false;
        }
        return fs.getSequence().equalsIgnoreCase(this.getSequence());
    }
}

