/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaReader;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.AllTestSuit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FastaReaderTester {
    static FastaSequence s0 = new FastaSequence("zedpshvyzg", "GCQDKNNIAELNEIMGTTRSPSDWQHMKGASPRAEIGLTGKKDSWWRHCCSKEFNKTPPPIHPDMKRWGWMWNRENFEKFLIDNFLNPPCPRLMLTKGTWWRHEDLCHEIFWSTLRWLCLGNQSFSAMIWGHLCECHRMIWWESNEHMFWLKFRRALKKMNSNGPCMGPDNREWMITNRMGKEFCGPAFAGDCQSCWRKCHKTNKICFNEKKGTPTKIDHEQKDIMDILKDIDNHRNWKQCQLWLLTSKSTDQESTTMLTWSTWRDFFIIIKQPFDHKCRGALDANGDFQIAAELKWPAPMIILRQNQKTMHDKSCHHFFTNRCPLMHTTRANDKQCSWHTRKQFICQQDFTTWQHRPDTHRILPSWCMSTRRKNHIKNTPALAFSTCEMGDLPNGWAPGTIILQRQFTQAIKLPQETTGWPRCDPKFDHWNMSKWLRQLLGRDDEMIPPQCD");
    static FastaSequence s1 = new FastaSequence("xovkactesa", "CPLSKWWNRRAFLSHTANHWMILMTWEGPHDGESKMRIAMMKWSPCKPTMSHFRCGLDAWAEPIRQIACESTFRMFCTTPRPIHKLTEMWGHMNGWTGAFCRQLECEWMMPPRHPHPCTSTFNNNKKRLIGQIPNEGKQLFINFQKPQHGFSESDIWIWKDNPTAWHEGLTIAGIGDGQHCWNWMPMPWSGAPTSNALIEFWTWLGMIGTRCKTQGMWWDAMNHHDQFELSANAHIAAHHMEKKMILKPDDRNLGDDTWMPPGKIWMRMFAKNTNACWPEGCRDDNEEDDCGTHNLHRMC");
    static FastaSequence s2 = new FastaSequence("ntazzewyvv", "CGCKIF D D NMKDNNRHG TDIKKHGFMH IRHPE KRDDC FDNHCIMPKHRRWGLWDEASINM\tAQQWRSLPPSRIMKLNG\tHGCDCMHSHMEAD\tDTKQSGIKGTFWNG\tHDAQWLCRWGEFITEA\tWWGRWGAITFFHAH\tENKNEIQECSDQNLKE\tSRTTCEIID   TCHLFTRHLDGW RCEKCQANATHMTW ACTKSCAEQW  FCAKELMMN    W        KQMGWRCKIFRKLFRDNCWID  FELPWWPICFCCKGLSTKSHSAHDGDQCRRW    WPDCARDWLGPGIRGEF   FCTHICQQLQRNFWCGCFRWNIEKRMFEIFDDNMAAHWKKCMHFKFLIRIHRHGPITMKMTWCRSGCCFGKTRRLPDSSFISAFLDPKHHRDGSGMMMWSSEMRSCAIPDPQQAWNQGKWIGQIKDWNICFAWPIRENQQCWATPHEMPSGFHFILEKWDALAHPHMHIRQKKCWAWAFLSLMSSTHSDMATFQWAIPGHNIWSNWDNIICGWPRI");
    static FastaSequence s3 = new FastaSequence(" 12 d t y wi \t\tk\tjbke  \t", "  KLSHHDCD   N    H    HSKCTEPHCGNSHQML\n\rHRDP    CCDQCQSWEAENWCASMRKAILF");
    static FastaSequence s4 = new FastaSequence(" 12 d t>y wi->foo \t\tk\tjbke  \t", "  KLSHHDCD   N    H    HSKCTEPHCGNSHQML\n\rHRDP    CCDQCQSWEAENWCASMRKAILF");

    @Test
    public void test() {
        List<FastaSequence> old_seqs = null;
        ArrayList<FastaSequence> list = new ArrayList<FastaSequence>();
        try {
            old_seqs = SequenceUtil.readFasta(new FileInputStream(AllTestSuit.TEST_DATA_PATH + "complicated.fasta"));
            FastaReader fr = new FastaReader(AllTestSuit.TEST_DATA_PATH + "complicated.fasta");
            while (fr.hasNext()) {
                FastaSequence fs = fr.next();
                list.add(fs);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        System.out.println("OLD: " + old_seqs);
        System.out.println("NEW: " + list);
        Assert.assertEquals((int)old_seqs.size(), (int)list.size());
        Assert.assertEquals((Object)old_seqs.get(0), list.get(0));
        Assert.assertEquals((Object)old_seqs.get(1), list.get(1));
        Assert.assertEquals((Object)s0, list.get(0));
        Assert.assertEquals((Object)s1, list.get(1));
        Assert.assertEquals((Object)s2, list.get(2));
        Assert.assertEquals((Object)s3, list.get(3));
        Assert.assertEquals((Object)s4, list.get(4));
    }
}

