/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.msa;

import compbio.ws.client.Services;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Category {
    public static final String CATEGORY_ALIGNMENT = "Alignment";
    public static final String CATEGORY_DISORDER = "Protein Disorder";
    public static final String CATEGORY_CONSERVATION = "Conservation";
    public static final String CATEGORY_PREDICTION = "Prediction";
    public String name;
    Set<Services> services;

    private Category(String name, Set<Services> services) {
        this.name = name;
        this.services = services;
    }

    private Category() {
    }

    public Set<Services> getServices() {
        return new TreeSet<Services>(this.services);
    }

    public static Set<Category> getCategories() {
        return Category.init();
    }

    private static Set<Category> init() {
        HashSet<Services> align_services = new HashSet<Services>();
        align_services.add(Services.ClustalOWS);
        align_services.add(Services.ClustalWS);
        align_services.add(Services.MafftWS);
        align_services.add(Services.MuscleWS);
        align_services.add(Services.ProbconsWS);
        align_services.add(Services.MSAprobsWS);
        align_services.add(Services.GLprobsWS);
        align_services.add(Services.TcoffeeWS);
        Category alignment = new Category(CATEGORY_ALIGNMENT, align_services);
        HashSet<Services> disorder_services = new HashSet<Services>();
        disorder_services.add(Services.DisemblWS);
        disorder_services.add(Services.GlobPlotWS);
        disorder_services.add(Services.IUPredWS);
        disorder_services.add(Services.JronnWS);
        Category disorder = new Category(CATEGORY_DISORDER, disorder_services);
        HashSet<Services> conservation_services = new HashSet<Services>();
        conservation_services.add(Services.AAConWS);
        Category conservation = new Category(CATEGORY_CONSERVATION, conservation_services);
        HashSet<Services> prediction_services = new HashSet<Services>();
        prediction_services.add(Services.RNAalifoldWS);
        Category prediction = new Category(CATEGORY_PREDICTION, prediction_services);
        HashSet<Category> categories = new HashSet<Category>();
        categories.add(alignment);
        categories.add(disorder);
        categories.add(conservation);
        categories.add(prediction);
        return categories;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

