/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.dundee.compbio.hmmerclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.dundee.compbio.hmmerclient.ResultType;

class XMLProcessor {
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newDefaultInstance();
    private static final DocumentBuilder documentBuilder;

    XMLProcessor() {
    }

    static IOException processErrorBody(InputStream responseBody) {
        Document doc;
        try {
            doc = documentBuilder.parse(responseBody);
            doc.normalize();
        }
        catch (IOException e) {
            return e;
        }
        catch (SAXException e) {
            return new IOException("malformed XML received from the server", e);
        }
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("error")) {
            return new IOException("server response missing XML node /error");
        }
        Node descriptionNode = root.getElementsByTagName("description").item(0);
        if (descriptionNode == null) {
            return new IOException("server response missing XML node /error/description");
        }
        return new IOException(descriptionNode.getTextContent());
    }

    static Collection<ResultType> processResultTypesBody(InputStream responseBody) throws IOException {
        Document doc;
        try {
            doc = documentBuilder.parse(responseBody);
            doc.normalize();
        }
        catch (SAXException e) {
            throw new IOException("malformed XML received from the server", e);
        }
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("types")) {
            throw new IOException("XML response missing /types node");
        }
        ArrayList<ResultType> results = new ArrayList<ResultType>();
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals("type")) continue;
            results.add(XMLProcessor.parseResultTypeNode(node));
        }
        return results;
    }

    private static ResultType parseResultTypeNode(Node rootNode) throws IOException {
        assert (rootNode.getNodeType() == 1);
        assert (rootNode.getNodeName().equals("type"));
        String description = null;
        String fileSuffix = null;
        String identifier = null;
        String label = null;
        String mediaType = null;
        block14: for (Node node = rootNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            String textContent = node.getTextContent();
            switch (node.getNodeName()) {
                case "description": {
                    description = textContent;
                    continue block14;
                }
                case "fileSuffix": {
                    fileSuffix = textContent;
                    continue block14;
                }
                case "identifier": {
                    identifier = textContent;
                    continue block14;
                }
                case "label": {
                    label = textContent;
                    continue block14;
                }
                case "mediaType": {
                    mediaType = textContent;
                }
            }
        }
        if (description == null || fileSuffix == null || identifier == null || label == null || mediaType == null) {
            throw new IOException("incomplete <type> node");
        }
        return new ResultType(description, fileSuffix, identifier, label, mediaType);
    }

    static {
        try {
            documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

