/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.seqfetcher;

import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class ASequenceFetcher {
    protected Hashtable<String, Map<String, DbSourceProxy>> fetchableDbs;
    private Comparator<DbSourceProxy> proxyComparator = new Comparator<DbSourceProxy>(){

        @Override
        public int compare(DbSourceProxy o1, DbSourceProxy o2) {
            int compared = Integer.compare(o1.getTier(), o2.getTier());
            if (compared == 0) {
                String o1Name = o1.getDbName();
                String o2Name = o2.getDbName();
                if (o1Name != null && o2Name != null) {
                    compared = o1Name.compareToIgnoreCase(o2Name);
                }
            }
            return compared;
        }
    };

    protected ASequenceFetcher() {
    }

    public String[] getSupportedDb() {
        if (this.fetchableDbs == null) {
            return null;
        }
        String[] sf = this.fetchableDbs.keySet().toArray(new String[this.fetchableDbs.size()]);
        return sf;
    }

    public boolean isFetchable(String source) {
        for (String db : this.fetchableDbs.keySet()) {
            if (!source.equalsIgnoreCase(db)) continue;
            return true;
        }
        Cache.log.warn((Object)("isFetchable doesn't know about '" + source + "'"));
        return false;
    }

    public SequenceI[] getSequences(List<DBRefEntry> refs, boolean dna) {
        Vector<SequenceI> rseqs = new Vector<SequenceI>();
        Hashtable queries = new Hashtable();
        for (DBRefEntry ref : refs) {
            List qset;
            String canonical = DBRefUtils.getCanonicalName(ref.getSource());
            if (!queries.containsKey(canonical)) {
                queries.put(canonical, new ArrayList());
            }
            if ((qset = (List)queries.get(canonical)).contains(ref.getAccessionId())) continue;
            qset.add(ref.getAccessionId());
        }
        Enumeration e = queries.keys();
        while (e.hasMoreElements()) {
            List query = null;
            String db = null;
            db = (String)e.nextElement();
            query = (List)queries.get(db);
            if (!this.isFetchable(db)) {
                this.reportStdError(db, query, new Exception("Don't know how to fetch from this database :" + db));
                continue;
            }
            Stack<String> queriesLeft = new Stack<String>();
            queriesLeft.addAll(query);
            List<DbSourceProxy> proxies = this.getSourceProxy(db);
            for (DbSourceProxy fetcher : proxies) {
                ArrayList<String> queriesMade = new ArrayList<String>();
                HashSet<String> queriesFound = new HashSet<String>();
                try {
                    boolean doMultiple;
                    if (fetcher.isDnaCoding() != dna) continue;
                    boolean bl = doMultiple = fetcher.getMaximumQueryCount() > 1;
                    while (!queriesLeft.isEmpty()) {
                        StringBuffer qsb = new StringBuffer();
                        do {
                            if (qsb.length() > 0) {
                                qsb.append(fetcher.getAccessionSeparator());
                            }
                            String q = (String)queriesLeft.pop();
                            queriesMade.add(q);
                            qsb.append(q);
                        } while (doMultiple && !queriesLeft.isEmpty());
                        AlignmentI seqset = null;
                        try {
                            seqset = fetcher.getSequenceRecords(qsb.toString());
                        }
                        catch (Exception ex) {
                            System.err.println("Failed to retrieve the following from " + db);
                            System.err.println(qsb);
                            ex.printStackTrace(System.err);
                        }
                        if (seqset == null) continue;
                        SequenceI[] seqs = seqset.getSequencesArray();
                        if (seqs != null) {
                            for (int is = 0; is < seqs.length; ++is) {
                                rseqs.addElement(seqs[is]);
                                List<DBRefEntry> frefs = DBRefUtils.searchRefs(seqs[is].getDBRefs(), new DBRefEntry(db, null, null), 15);
                                for (DBRefEntry dbr : frefs) {
                                    queriesFound.add(dbr.getAccessionId());
                                    queriesMade.remove(dbr.getAccessionId());
                                }
                                seqs[is] = null;
                            }
                            continue;
                        }
                        if (fetcher.getRawRecords() == null) continue;
                        System.out.println("# Retrieved from " + db + ":" + qsb.toString());
                        StringBuffer rrb = fetcher.getRawRecords();
                        String hdr = "# " + db + ":" + qsb.toString();
                        System.out.println(hdr);
                        if (rrb != null) {
                            System.out.println(rrb);
                        }
                        System.out.println("# end of " + hdr);
                    }
                }
                catch (Exception ex) {
                    this.reportStdError(db, queriesMade, ex);
                }
                if (queriesMade.size() <= 0) continue;
                System.out.println("# Adding " + queriesMade.size() + " ids back to queries list for searching again (" + db + ")");
                queriesLeft.addAll(queriesMade);
            }
        }
        SequenceI[] result = null;
        if (rseqs.size() > 0) {
            result = new SequenceI[rseqs.size()];
            int si = 0;
            for (SequenceI s : rseqs) {
                result[si++] = s;
                s.updatePDBIds();
            }
        }
        return result;
    }

    public void reportStdError(String db, List<String> queriesMade, Exception ex) {
        System.err.println("Failed to retrieve the following references from " + db);
        int n = 0;
        for (String qv : queriesMade) {
            System.err.print(" " + qv + ";");
            if (n++ <= 10) continue;
            System.err.println();
            n = 0;
        }
        System.err.println();
        ex.printStackTrace();
    }

    public List<DbSourceProxy> getSourceProxy(String db) {
        Map<String, DbSourceProxy> dblist = this.fetchableDbs.get(db = DBRefUtils.getCanonicalName(db));
        if (dblist == null) {
            return new ArrayList<DbSourceProxy>();
        }
        ArrayList<DbSourceProxy> dbs = new ArrayList<DbSourceProxy>(dblist.values());
        Collections.sort(dbs, this.proxyComparator);
        return dbs;
    }

    protected void addDBRefSourceImpl(Class<? extends DbSourceProxy> dbSourceProxy) throws IllegalArgumentException {
        DbSourceProxy proxy = null;
        try {
            DbSourceProxy proxyObj;
            proxy = proxyObj = dbSourceProxy.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(MessageManager.getString("error.dbrefsource_implementation_exception"), e);
        }
        this.addDbRefSourceImpl(proxy);
    }

    protected void addDbRefSourceImpl(DbSourceProxy proxy) {
        if (proxy != null) {
            Map<String, DbSourceProxy> slist;
            if (this.fetchableDbs == null) {
                this.fetchableDbs = new Hashtable();
            }
            if ((slist = this.fetchableDbs.get(proxy.getDbSource())) == null) {
                slist = new Hashtable<String, DbSourceProxy>();
                this.fetchableDbs.put(proxy.getDbSource(), slist);
            }
            slist.put(proxy.getDbName(), proxy);
        }
    }

    public String[] getDbInstances(Class class1) {
        if (!DbSourceProxy.class.isAssignableFrom(class1)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_dbinstance_must_implement_interface", new String[]{class1.toString()}));
        }
        if (this.fetchableDbs == null) {
            return null;
        }
        Object[] sources = null;
        Vector<String> src = new Vector<String>();
        Enumeration<String> dbs = this.fetchableDbs.keys();
        while (dbs.hasMoreElements()) {
            String dbn = dbs.nextElement();
            for (DbSourceProxy dbp : this.fetchableDbs.get(dbn).values()) {
                if (!class1.isAssignableFrom(dbp.getClass())) continue;
                src.addElement(dbn);
            }
        }
        if (src.size() > 0) {
            sources = new String[src.size()];
            src.copyInto(sources);
        }
        return sources;
    }

    public DbSourceProxy[] getDbSourceProxyInstances(Class class1) {
        ArrayList<DbSourceProxy> prlist = new ArrayList<DbSourceProxy>();
        for (String fetchable : this.getSupportedDb()) {
            for (DbSourceProxy pr : this.getSourceProxy(fetchable)) {
                if (!class1.isInstance(pr)) continue;
                prlist.add(pr);
            }
        }
        if (prlist.size() == 0) {
            return null;
        }
        return prlist.toArray(new DbSourceProxy[0]);
    }

    public FeatureSettingsModelI getFeatureColourScheme(String source) {
        for (DbSourceProxy proxy : this.getSourceProxy(source)) {
            FeatureSettingsModelI preferredColours = proxy.getFeatureColourScheme();
            if (preferredColours == null) continue;
            return preferredColours;
        }
        return null;
    }
}

