/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.PaintRefresher;
import jalview.gui.WebserviceInfo;
import jalview.io.NewickFile;
import jalview.io.packed.JalviewDataset;
import jalview.util.MessageManager;
import jalview.ws.AWSThread;
import jalview.ws.AWsJob;
import jalview.ws.rest.HttpResultSet;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestClient;
import jalview.ws.rest.RestJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

public class RestJobThread
extends AWSThread {
    protected RestClient restClient;
    protected String warnings;

    public RestJobThread(RestClient restClient) {
        super(restClient.af, null, restClient._input, restClient.service.postUrl);
        this.restClient = restClient;
        if (!restClient.service.isHseparable()) {
            this.jobs = new RestJob[1];
            this.jobs[0] = new RestJob(0, this, restClient._input.getVisibleAlignment(restClient.service.getGapCharacter()), restClient._input.getVisibleContigs());
        } else {
            int[] viscontig = restClient._input.getVisibleContigs();
            AlignmentI[] viscontigals = restClient._input.getVisibleContigAlignments(restClient.service.getGapCharacter());
            if (viscontigals != null && viscontigals.length > 0) {
                this.jobs = new RestJob[viscontigals.length];
                for (int j = 0; j < this.jobs.length; ++j) {
                    int[] visc = new int[]{viscontig[j * 2], viscontig[j * 2 + 1]};
                    this.jobs[j] = j != 0 ? new RestJob(j, this, viscontigals[j], visc) : new RestJob(0, this, viscontigals[j], visc);
                }
            }
        }
        if (!restClient.service.isHseparable()) {
            // empty if block
        }
    }

    public void setWebServiceInfo(WebserviceInfo webserviceInfo) {
        this.wsInfo = webserviceInfo;
        for (int j = 0; j < this.jobs.length; ++j) {
            this.wsInfo.addJobPane();
            if (this.jobs.length > 1) {
                this.wsInfo.setProgressName("region " + this.jobs[j].getJobnum(), this.jobs[j].getJobnum());
                continue;
            }
            this.wsInfo.setProgressText(this.jobs[j].getJobnum(), this.OutputHeader);
        }
    }

    private String getStage(Stage stg) {
        if (stg == Stage.SUBMIT) {
            return "submitting ";
        }
        if (stg == Stage.POLL) {
            return "checking status of ";
        }
        return " being confused about ";
    }

    private void doPoll(RestJob rj) throws Exception {
        String postUrl = rj.getPollUrl();
        this.doHttpReq(Stage.POLL, rj, postUrl);
    }

    public void doPost(RestJob rj) throws Exception {
        String postUrl = rj.getPostUrl();
        this.doHttpReq(Stage.SUBMIT, rj, postUrl);
        this.wsInfo.invalidate();
    }

    protected void doHttpReq(Stage stg, RestJob rj, String postUrl) throws Exception {
        StringBuffer respText = new StringBuffer();
        HttpGet request = null;
        Object messages = "";
        if (stg == Stage.SUBMIT) {
            HttpPost htpost = new HttpPost(postUrl);
            MultipartEntity postentity = new MultipartEntity(HttpMultipartMode.STRICT);
            for (Map.Entry<String, InputType> input : rj.getInputParams()) {
                if (input.getValue().validFor(rj)) {
                    postentity.addPart(input.getKey(), input.getValue().formatForInput(rj));
                    continue;
                }
                messages = (String)messages + "Skipped an input (" + input.getKey() + ") - Couldn't generate it from available data.";
            }
            htpost.setEntity((HttpEntity)postentity);
            request = htpost;
        } else {
            request = new HttpGet(postUrl);
        }
        if (request != null) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            HttpResponse response = null;
            try {
                response = httpclient.execute((HttpUriRequest)request);
            }
            catch (ClientProtocolException he) {
                rj.statMessage = "Web Protocol Exception when " + this.getStage(stg) + "Job. <br>Problematic url was <a href=\"" + request.getURI() + "\">" + request.getURI() + "</a><br>See Console output for details.";
                rj.setAllowedServerExceptions(0);
                rj.error = true;
                Cache.log.fatal((Object)("Unexpected REST Job " + this.getStage(stg) + "exception for URL " + rj.rsd.postUrl));
                throw he;
            }
            catch (IOException e) {
                rj.statMessage = "IO Exception when " + this.getStage(stg) + "Job. <br>Problematic url was <a href=\"" + request.getURI() + "\">" + request.getURI() + "</a><br>See Console output for details.";
                Cache.log.warn((Object)("IO Exception for REST Job " + this.getStage(stg) + "exception for URL " + rj.rsd.postUrl));
                throw e;
            }
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    rj.running = false;
                    Cache.log.debug((Object)"Processing result set.");
                    this.processResultSet(rj, response, (HttpRequestBase)request);
                    break;
                }
                case 202: {
                    rj.statMessage = "<br>Job submitted successfully. Results available at this URL:\n<a href=" + rj.getJobId() + "\">" + rj.getJobId() + "</a><br>";
                    rj.running = true;
                    break;
                }
                case 302: {
                    Header[] loc;
                    if (!rj.isSubmitted() && (loc = response.getHeaders("Location")) != null && loc.length > 0) {
                        if (loc.length > 1) {
                            Cache.log.warn((Object)("Ignoring additional " + (loc.length - 1) + " location(s) provided in response header ( next one is '" + loc[1].getValue() + "' )"));
                        }
                        rj.setJobId(loc[0].getValue());
                        rj.setSubmitted(true);
                    }
                    this.completeStatus(rj, response);
                    break;
                }
                case 500: {
                    rj.setSubmitted(true);
                    rj.setAllowedServerExceptions(0);
                    rj.setSubjobComplete(true);
                    rj.error = true;
                    rj.running = false;
                    this.completeStatus(rj, response, this.getStage(stg) + "failed. Reason below:\n");
                    break;
                }
                default: {
                    Cache.log.warn((Object)("Unhandled response status when " + this.getStage(stg) + "for " + postUrl + ": " + response.getStatusLine()));
                    rj.error = true;
                    rj.setAllowedServerExceptions(0);
                    rj.setSubjobComplete(true);
                    rj.setSubmitted(true);
                    try {
                        this.completeStatus(rj, response, this.getStage(stg) + " resulted in an unexpected server response.<br/>Url concerned was <a href=\"" + request.getURI() + "\">" + request.getURI() + "</a><br/>Filtered response content below:<br/>");
                        break;
                    }
                    catch (IOException e) {
                        Cache.log.debug((Object)"IOException when consuming unhandled response", (Throwable)e);
                    }
                }
            }
        }
    }

    private void processResultSet(RestJob rj, HttpResponse con, HttpRequestBase req) {
        if (rj.statMessage == null) {
            rj.statMessage = "";
        }
        rj.statMessage = rj.statMessage + "Job Complete.\n";
        try {
            rj.resSet = new HttpResultSet(rj, con, req);
            rj.gotresult = true;
        }
        catch (IOException e) {
            rj.statMessage = rj.statMessage + "Couldn't parse results. Failed.";
            rj.error = true;
            rj.gotresult = false;
        }
    }

    private void completeStatus(RestJob rj, HttpResponse con) throws IOException {
        this.completeStatus(rj, con, null);
    }

    private void completeStatus(RestJob rj, HttpResponse con, String prefix) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (rj.statMessage != null && rj.statMessage.length() > 0) {
            sb.append(rj.statMessage);
        }
        HttpEntity en = con.getEntity();
        String f = EntityUtils.toString((HttpEntity)en);
        StringBuffer content = new StringBuffer(f);
        int body = (f = f.toLowerCase()).indexOf("<body");
        if (body > -1) {
            content.delete(0, f.indexOf(">", body) + 1);
        }
        if (body > -1 && sb.length() > 0) {
            sb.append("\n");
            content.insert(0, sb);
            sb = null;
        }
        f = null;
        rj.statMessage = content.toString();
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        assert (job instanceof RestJob);
        System.err.println("Debug RestJob: Polling Job");
        this.doPoll((RestJob)job);
    }

    @Override
    public void StartJob(AWsJob job) {
        assert (job instanceof RestJob);
        try {
            System.err.println("Debug RestJob: Posting Job");
            this.doPost((RestJob)job);
        }
        catch (NoValidInputDataException erex) {
            job.setSubjobComplete(true);
            job.setSubmitted(true);
            ((RestJob)job).statMessage = "<br>It looks like there was a problem with the data sent to the service :<br>" + erex.getMessage() + "\n";
            ((RestJob)job).error = true;
        }
        catch (Exception ex) {
            job.setSubjobComplete(true);
            job.setAllowedServerExceptions(-1);
            Cache.log.error((Object)"Exception when trying to start Rest Job.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseResult() {
        Cache.log.warn((Object)"Rest job result parser is currently INCOMPLETE!");
        int validres = 0;
        for (RestJob rj : (RestJob[])this.jobs) {
            if (!rj.hasResponse() || rj.resSet == null || !rj.resSet.isValid()) continue;
            Object ln = null;
            try {
                Cache.log.debug((Object)("Parsing data for job " + rj.getJobId()));
                rj.parseResultSet();
                if (rj.hasResults()) {
                    ++validres;
                }
                Cache.log.debug((Object)("Finished parsing data for job " + rj.getJobId()));
            }
            catch (Error ex) {
                Cache.log.warn((Object)("Failed to finish parsing data for job " + rj.getJobId()));
                ex.printStackTrace();
            }
            catch (Exception ex) {
                Cache.log.warn((Object)("Failed to finish parsing data for job " + rj.getJobId()));
                ex.printStackTrace();
            }
            finally {
                rj.error = true;
                rj.statMessage = "Error whilst parsing data for this job.<br>URL for job response is :<a href=\"" + rj.resSet.getUrl() + "\">" + rj.resSet.getUrl() + "</a><br>";
            }
        }
        if (validres > 0) {
            this.wsInfo.setViewResultsImmediatly(true);
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RestJobThread.this.realiseResults(false);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RestJobThread.this.realiseResults(true);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setStatus(4);
            this.wsInfo.setFinishedNoResults();
        }
    }

    public void realiseResults(boolean merge) {
        ArrayList<AlignmentPanel> destPanels = new ArrayList<AlignmentPanel>();
        ArrayList<AddDataTo> resultDest = new ArrayList<AddDataTo>();
        boolean newAlignment = false;
        char gapCharacter = this.restClient.av.getGapCharacter();
        boolean hsepjobs = this.restClient.service.isHseparable();
        boolean vsepjobs = this.restClient.service.isVseparable();
        int numAlSets = 0;
        int als = 0;
        ArrayList<AlignmentI> destAls = new ArrayList<AlignmentI>();
        ArrayList<HiddenColumns> destColsel = new ArrayList<HiddenColumns>();
        ArrayList trees = new ArrayList();
        do {
            int[][] ordermap = new int[this.jobs.length][];
            SequenceI[][] rseqs = new SequenceI[this.jobs.length][];
            AlignmentOrder[] orders = new AlignmentOrder[this.jobs.length];
            AlignmentAnnotation[][] alan = new AlignmentAnnotation[this.jobs.length][];
            SequenceGroup[][] sgrp = new SequenceGroup[this.jobs.length][];
            for (int j = 0; j < this.jobs.length; ++j) {
                JalviewDataset rset;
                RestJob rj = (RestJob)this.jobs[j];
                if (!rj.hasResults() || !(rset = rj.context).hasAlignments()) continue;
                if (numAlSets < rset.getAl().size()) {
                    numAlSets = rset.getAl().size();
                }
                if (als >= rset.getAl().size() || !rset.getAl().get(als).isModified()) continue;
                JalviewDataset.AlignmentSet alset = rset.getAl().get(als);
                alan[j] = alset.al.getAlignmentAnnotation();
                if (alset.al.getGroups() != null) {
                    sgrp[j] = new SequenceGroup[alset.al.getGroups().size()];
                    alset.al.getGroups().toArray(sgrp[j]);
                } else {
                    sgrp[j] = null;
                }
                orders[j] = new AlignmentOrder(alset.al);
                rseqs[j] = alset.al.getSequencesArray();
                ordermap[j] = rj.getOrderMap();
                if (alset.trees != null) {
                    trees.add(new ArrayList<NewickFile>(alset.trees));
                    continue;
                }
                trees.add(new ArrayList());
            }
            int nvertsep = 0;
            int nvertseps = 1;
            if (vsepjobs) {
                // empty if block
            }
            int vrestjob = 0;
            ArrayList<SequenceGroup> visgrps = new ArrayList<SequenceGroup>();
            Hashtable<String, SequenceGroup> groupNames = new Hashtable<String, SequenceGroup>();
            ArrayList<AlignmentAnnotation> visAlAn = null;
            for (nvertsep = 0; nvertsep < nvertseps; ++nvertsep) {
                int ncnt;
                int nrj = vrestjob;
                RestJob rj = (RestJob)this.jobs[nrj];
                int[] contigs = this.input.getVisibleContigs();
                AlignmentI destAl = null;
                HiddenColumns destHCs = null;
                if (als == 0 && rj.isInputContextModified()) {
                    if (destAls.size() > als) {
                        destAl = (AlignmentI)destAls.get(als);
                    } else {
                        if (!this.restClient.isAlignmentModified() && merge) {
                            destAl = this.restClient.av.getAlignment();
                            destHCs = this.restClient.av.getAlignment().getHiddenColumns();
                            resultDest.add(this.restClient.isShowResultsInNewView() ? AddDataTo.newView : AddDataTo.currentView);
                            destPanels.add(this.restClient.recoverAlignPanelForView());
                        } else {
                            newAlignment = true;
                            Object[] idat = this.input.getAlignmentAndHiddenColumns(gapCharacter);
                            destAl = new Alignment((SequenceI[])idat[0]);
                            destHCs = (HiddenColumns)idat[1];
                            resultDest.add(AddDataTo.newAlignment);
                        }
                        destAls.add(destAl);
                        destColsel.add(destHCs);
                    }
                } else if (destAls.size() > als) {
                    if (!vsepjobs) {
                        Cache.log.warn((Object)"dealing with multiple alignment products returned by non-vertically separable service.");
                    }
                    destAl = (AlignmentI)destAls.get(als);
                    destHCs = (HiddenColumns)destColsel.get(als);
                } else {
                    Object[] newview;
                    if (!hsepjobs) {
                        SequenceI[][] nsq = this.splitSeqsOnVisibleContigs(rseqs[nrj], contigs, gapCharacter);
                        AlignmentOrder[] alo = new AlignmentOrder[nsq.length];
                        for (int no = 0; no < alo.length; ++no) {
                            alo[no] = new AlignmentOrder(orders[nrj].getOrder());
                        }
                        newview = this.input.getUpdatedView(nsq, orders, gapCharacter);
                    } else {
                        newview = this.input.getUpdatedView(rseqs, orders, gapCharacter);
                    }
                    destAl = new Alignment((SequenceI[])newview[0]);
                    destHCs = (HiddenColumns)newview[1];
                    newAlignment = true;
                    destAls.add(destAl);
                    destColsel.add(destHCs);
                    resultDest.add(AddDataTo.newAlignment);
                    throw new Error(MessageManager.getString("error.implementation_error") + "TODO: ");
                }
                int initnrj = nrj;
                for (ncnt = 0; ncnt < contigs.length; ncnt += 2) {
                    if (hsepjobs && ncnt > 0) {
                        ++nrj;
                    }
                    if (sgrp[nrj] == null) continue;
                    for (SequenceGroup sg : sgrp[nrj]) {
                        SequenceI oseq;
                        SequenceI nseq;
                        boolean recovered = false;
                        SequenceGroup exsg = null;
                        if (sg.getName() != null) {
                            exsg = (SequenceGroup)groupNames.get(sg.getName());
                        }
                        if (exsg == null) {
                            exsg = new SequenceGroup(sg);
                            groupNames.put(exsg.getName(), exsg);
                            visgrps.add(exsg);
                            exsg.setStartRes(sg.getStartRes() + contigs[ncnt]);
                            exsg.setEndRes(sg.getEndRes() + contigs[ncnt]);
                        } else {
                            recovered = true;
                        }
                        for (SequenceI oseq2 : sg.getSequences(null)) {
                            SequenceI nseq2 = this.getNewSeq(oseq2, rseqs[nrj], ordermap[nrj], destAl);
                            if (nseq2 != null) {
                                if (!recovered) {
                                    exsg.deleteSequence(oseq2, false);
                                }
                                exsg.addSequence(nseq2, false);
                                continue;
                            }
                            Cache.log.warn((Object)"Couldn't resolve original sequence for new sequence.");
                        }
                        if (sg.hasSeqrep() && exsg.getSeqrep() == sg.getSeqrep() && (nseq = this.getNewSeq(oseq = sg.getSeqrep(), rseqs[nrj], ordermap[nrj], destAl)) != null) {
                            exsg.setSeqrep(nseq);
                        }
                        if (!recovered) continue;
                        int start = sg.getStartRes() + contigs[ncnt];
                        int end = sg.getEndRes() + contigs[ncnt];
                        if (start < exsg.getStartRes()) {
                            exsg.setStartRes(start);
                        }
                        if (end <= exsg.getEndRes()) continue;
                        exsg.setEndRes(end);
                    }
                }
                nrj = initnrj;
                for (ncnt = 0; ncnt < contigs.length; ncnt += 2) {
                    if (hsepjobs && ncnt > 0) {
                        ++nrj;
                    }
                    if (alan[nrj] != null) {
                        for (int an = 0; an < alan[nrj].length; ++an) {
                            SequenceI sqass = null;
                            SequenceGroup grass = null;
                            if (alan[nrj][an].sequenceRef != null) {
                                sqass = this.getNewSeq(alan[nrj][an].sequenceRef, rseqs[nrj], ordermap[nrj], destAl);
                            }
                            if (alan[nrj][an].groupRef != null && (grass = (SequenceGroup)groupNames.get(alan[nrj][an].groupRef.getName())) == null) {
                                Cache.log.error((Object)("Couldn't relocate group referemce for group " + alan[nrj][an].groupRef.getName()));
                            }
                            if (visAlAn == null) {
                                visAlAn = new ArrayList<AlignmentAnnotation>();
                            }
                            AlignmentAnnotation visan = null;
                            for (AlignmentAnnotation v : visAlAn) {
                                if (v.label == null || !v.label.equals(alan[nrj][an].label)) continue;
                                visan = v;
                            }
                            if (visan == null) {
                                visan = new AlignmentAnnotation(alan[nrj][an]);
                                visan.annotations = new Annotation[this.input.getWidth()];
                                visan.groupRef = grass;
                                visan.sequenceRef = sqass;
                                visAlAn.add(visan);
                            }
                            if (contigs[ncnt] + alan[nrj][an].annotations.length > visan.annotations.length) {
                                Annotation[] newannv = new Annotation[contigs[ncnt] + alan[nrj][an].annotations.length];
                                System.arraycopy(visan.annotations, 0, newannv, 0, visan.annotations.length);
                                visan.annotations = newannv;
                            }
                            System.arraycopy(alan[nrj][an].annotations, 0, visan.annotations, contigs[ncnt], alan[nrj][an].annotations.length);
                        }
                    }
                    if (((List)trees.get(nrj)).size() <= 0) continue;
                    for (NewickFile nf : (List)trees.get(nrj)) {
                        Cache.log.error((Object)"Tree recovery from restjob not yet implemented.");
                    }
                }
            }
            if (visAlAn != null) {
                for (AlignmentAnnotation v : visAlAn) {
                    ((AlignmentI)destAls.get(als)).addAnnotation(v);
                }
            }
            if (visgrps == null) continue;
            for (SequenceGroup sg : visgrps) {
                ((AlignmentI)destAls.get(als)).addGroup(sg);
            }
        } while (++als < numAlSets);
        AlignFrame destaf = this.restClient.recoverAlignFrameForView();
        AlignmentPanel destPanel = this.restClient.recoverAlignPanelForView();
        als = 0;
        for (AddDataTo action : resultDest) {
            String alTitle = MessageManager.formatMessage("label.webservice_job_title_on", new String[]{this.restClient.service.details.Action, this.restClient.service.details.Name, this.restClient.viewTitle});
            switch (action) {
                case newAlignment: {
                    AlignmentI destal = (AlignmentI)destAls.get(als);
                    HiddenColumns destcs = (HiddenColumns)destColsel.get(als);
                    destaf = new AlignFrame(destal, destcs, 700, 500);
                    PaintRefresher.Refresh(destaf, destaf.getViewport().getSequenceSetId());
                    Desktop.addInternalFrame(destaf, alTitle, 700, 500);
                    break;
                }
                case newView: {
                    break;
                }
            }
        }
        if (newAlignment || this.restClient.isShowResultsInNewView()) {
            // empty if block
        }
    }

    private SequenceI[][] splitSeqsOnVisibleContigs(SequenceI[] sequenceIs, int[] contigs, char gapChar) {
        int nvc = contigs == null ? 1 : contigs.length / 2;
        SequenceI[][] blocks = new SequenceI[nvc][];
        if (contigs == null) {
            blocks[0] = new SequenceI[sequenceIs.length];
            System.arraycopy(sequenceIs, 0, blocks[0], 0, sequenceIs.length);
        } else {
            Object gapset = null;
            int start = 0;
            int width = 0;
            for (int c = 0; c < nvc; ++c) {
                width = contigs[c * 2 + 1] - contigs[c * 2] + 1;
                for (int s = 0; s < sequenceIs.length; ++s) {
                    int end = sequenceIs[s].getLength();
                    if (start < end) {
                        if (start + width < end) {
                            blocks[c][s] = sequenceIs[s].getSubSequence(start, start + width);
                            continue;
                        }
                        blocks[c][s] = sequenceIs[s].getSubSequence(start, end);
                        Object sq = blocks[c][s].getSequenceAsString();
                        for (int n = start + width; n > end; --n) {
                            sq = (String)sq + gapChar;
                        }
                        continue;
                    }
                    if (gapset == null || (gapset).length < width) {
                        char[] ng = new char[width];
                        int gs = 0;
                        if (gapset != null) {
                            gs = (gapset).length;
                            System.arraycopy(gapset, 0, ng, 0, gs);
                        }
                        while (gs < ng.length) {
                            ng[gs++] = gapChar;
                        }
                    }
                    blocks[c][s] = sequenceIs[s].getSubSequence(end, end);
                    blocks[c][s].setSequence(gapset.toString().substring(0, width));
                }
                if (c <= 0) continue;
                start += contigs[c * 2 + 1] - contigs[c * 2];
            }
        }
        return blocks;
    }

    private SequenceI getNewSeq(SequenceI oseq, SequenceI[] sequenceIs, int[] is, AlignmentI destAl) {
        int p;
        for (p = 0; p < sequenceIs.length && sequenceIs[p] != oseq; ++p) {
        }
        if (p < sequenceIs.length && p < destAl.getHeight()) {
            return destAl.getSequenceAt(is[p]);
        }
        return null;
    }

    public boolean isValid() {
        ArrayList<String> _warnings = new ArrayList<String>();
        boolean validt = true;
        if (this.jobs != null) {
            for (RestJob rj : (RestJob[])this.jobs) {
                if (rj.hasValidInput()) continue;
                System.err.println("Job " + rj.getJobnum() + " has invalid input. ( " + rj.getStatus() + ")");
                if (rj.hasStatus() && !_warnings.contains(rj.getStatus())) {
                    _warnings.add(rj.getStatus());
                }
                validt = false;
            }
        }
        if (!validt) {
            this.warnings = "";
            for (String st : _warnings) {
                if (this.warnings.length() > 0) {
                    this.warnings = this.warnings + "\n";
                }
                this.warnings = this.warnings + st;
            }
        }
        return validt;
    }

    public boolean hasWarnings() {
        return this.warnings != null && this.warnings.length() > 0;
    }

    public String getWarnings() {
        return this.isValid() ? "Job can be started. No warnings." : (this.hasWarnings() ? this.warnings : "");
    }

    private static enum AddDataTo {
        currentView,
        newView,
        newAlignment;

    }

    static enum Stage {
        SUBMIT,
        POLL;

    }
}

