/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentView;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.WebserviceInfo;
import jalview.io.packed.DataProvider;
import jalview.io.packed.JalviewDataset;
import jalview.util.MessageManager;
import jalview.ws.WSClient;
import jalview.ws.WSClientI;
import jalview.ws.WSMenuEntryProviderI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.RestJobThread;
import jalview.ws.rest.RestServiceDescription;
import jalview.ws.rest.params.Alignment;
import jalview.ws.rest.params.SeqGroupIndexVector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class RestClient
extends WSClient
implements WSClientI,
WSMenuEntryProviderI {
    RestServiceDescription service;
    AlignFrame af;
    AlignViewport av;
    boolean headless = false;
    long[] undoredo = null;
    AlignmentView _input;
    JalviewDataset jds;
    public String viewTitle;
    protected static Vector<String> services = null;
    public static final String RSBS_SERVICES = "RSBS_SERVICES";

    public RestClient(RestServiceDescription rsd) {
        this.service = rsd;
    }

    protected AlignFrame recoverAlignFrameForView() {
        return Desktop.getAlignFrameFor(this.av);
    }

    public RestClient(RestServiceDescription service2, AlignFrame alignFrame) {
        this(service2, alignFrame, false);
    }

    public RestClient(RestServiceDescription service2, AlignFrame alignFrame, boolean nogui) {
        this.service = service2;
        this.af = alignFrame;
        this.av = alignFrame.getViewport();
        this.headless = nogui;
        this.constructJob();
    }

    public void setWebserviceInfo(boolean headless) {
        this.WebServiceJobTitle = MessageManager.formatMessage("label.webservice_job_title", new String[]{this.service.details.Action, this.service.details.Name});
        this.WebServiceName = this.service.details.Name;
        this.WebServiceReference = "No reference - go to url for more info";
        if (this.service.details.description != null) {
            this.WebServiceReference = this.service.details.description;
        }
        if (!headless) {
            this.wsInfo = new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceName + "\n" + this.WebServiceReference, true);
            this.wsInfo.setRenderAsHtml(true);
        }
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }

    @Override
    public void cancelJob() {
        System.err.println("Cannot cancel this job type: " + this.service);
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final AlignFrame alignFrame) {
        JMenuItem submit = new JMenuItem(this.service.details.Name);
        submit.setToolTipText(MessageManager.formatMessage("label.rest_client_submit", new String[]{this.service.details.Action, this.service.details.Name}));
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RestClient(RestClient.this.service, alignFrame);
            }
        });
        wsmenu.add(submit);
        wsmenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    protected boolean isAlignmentModified() {
        if (this.undoredo == null || this.av == null || this.av.getAlignment() == null) {
            return true;
        }
        return this.av.isUndoRedoHashModified(this.undoredo);
    }

    protected void constructJob() {
        boolean selExists;
        this.service.setInvolvesFlags();
        this.undoredo = this.av.getUndoRedoHash();
        boolean bl = selExists = this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSize() > 1;
        if (selExists) {
            if (this.service.partitiondata) {
                if (this.av.getAlignment().getGroups() != null && this.av.getAlignment().getGroups().size() > 0) {
                    this._input = new AlignmentView(this.av.getAlignment(), this.av.getAlignment().getHiddenColumns(), this.av.getSelectionGroup(), this.av.hasHiddenColumns(), true, true);
                    this.viewTitle = MessageManager.formatMessage("label.select_visible_region_of", new String[]{this.av.hasHiddenColumns() ? MessageManager.getString("label.visible") : "", this.af.getTitle()});
                } else {
                    this._input = new AlignmentView(this.av.getAlignment(), this.av.getAlignment().getHiddenColumns(), this.av.getSelectionGroup(), this.av.hasHiddenColumns(), false, true);
                }
                this.viewTitle = MessageManager.formatMessage("label.select_unselect_visible_regions_from", new String[]{this.av.hasHiddenColumns() ? MessageManager.getString("label.visible") : "", this.af.getTitle()});
            } else {
                this._input = new AlignmentView(this.av.getAlignment(), this.av.getAlignment().getHiddenColumns(), this.av.getSelectionGroup(), this.av.hasHiddenColumns(), true, true);
                this.viewTitle = MessageManager.formatMessage("label.select_visible_region_of", new String[]{this.av.hasHiddenColumns() ? MessageManager.getString("label.visible") : "", this.af.getTitle()});
            }
        } else {
            this._input = new AlignmentView(this.av.getAlignment(), this.av.getAlignment().getHiddenColumns(), null, this.av.hasHiddenColumns(), false, true);
            this.viewTitle = (this.av.hasHiddenColumns() ? new StringBuffer(" ").append(MessageManager.getString("label.visible_region_of")).toString() : "") + this.af.getTitle();
        }
        RestJobThread jobsthread = new RestJobThread(this);
        if (jobsthread.isValid()) {
            this.setWebserviceInfo(this.headless);
            if (!this.headless) {
                this.wsInfo.setthisService(this);
                jobsthread.setWebServiceInfo(this.wsInfo);
            }
            jobsthread.start();
        } else {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, jobsthread.hasWarnings() ? jobsthread.getWarnings() : MessageManager.getString("label.job_couldnt_be_started_check_input"), MessageManager.getString("label.unable_start_web_service_analysis"), 2);
        }
    }

    public static RestClient makeShmmrRestClient() {
        String action = "Analysis";
        String description = "Sequence Harmony and Multi-Relief (Brandt et al. 2010)";
        String name = MessageManager.getString("label.multiharmony");
        Hashtable<String, InputType> iparams = new Hashtable<String, InputType>();
        Alignment aliinput = new Alignment();
        aliinput.token = "ali_file";
        aliinput.writeAsFile = true;
        iparams.put(aliinput.token, aliinput);
        SeqGroupIndexVector sgroups = new SeqGroupIndexVector();
        sgroups.setMinsize(2);
        sgroups.min = 2;
        iparams.put("groups", sgroups);
        sgroups.token = "groups";
        sgroups.sep = " ";
        RestServiceDescription shmrService = new RestServiceDescription(action, description, name, "http://zeus.few.vu.nl/programs/shmrwww/index.php?tool=jalview", "?tool=jalview", iparams, true, false, '-');
        shmrService.addResultDatatype(DataProvider.JvDataType.ANNOTATION);
        return new RestClient(shmrService);
    }

    public AlignmentPanel recoverAlignPanelForView() {
        AlignmentPanel[] aps;
        for (AlignmentPanel alp : aps = Desktop.getAlignmentPanels(this.av.getSequenceSetId())) {
            if (alp.av != this.av) continue;
            return alp;
        }
        return null;
    }

    public boolean isShowResultsInNewView() {
        return true;
    }

    public static RestClient[] getRestClients() {
        if (services == null) {
            services = new Vector();
            try {
                for (RestServiceDescription descr : RestServiceDescription.parseDescriptions(Cache.getDefault(RSBS_SERVICES, RestClient.makeShmmrRestClient().service.toString()))) {
                    services.add(descr.toString());
                }
            }
            catch (Exception ex) {
                System.err.println("Serious - RSBS descriptions in user preferences are corrupt!");
                ex.printStackTrace();
            }
        }
        RestClient[] lst = new RestClient[services.size()];
        int i = 0;
        for (String svc : services) {
            lst[i++] = new RestClient(new RestServiceDescription(svc));
        }
        return lst;
    }

    public String getAction() {
        return this.service.details.Action;
    }

    public RestServiceDescription getRestDescription() {
        return this.service;
    }

    public static Vector<String> getRsbsDescriptions() {
        Vector<String> rsbsDescrs = new Vector<String>();
        for (RestClient rsbs : RestClient.getRestClients()) {
            rsbsDescrs.add(rsbs.getRestDescription().toString());
        }
        return rsbsDescrs;
    }

    public static void setRsbsServices(Vector<String> rsbsUrls) {
        if (rsbsUrls != null) {
            services = new Vector<String>(rsbsUrls);
            StringBuffer sprop = new StringBuffer();
            for (String s : services) {
                sprop.append(s);
            }
            Cache.setProperty(RSBS_SERVICES, sprop.toString());
        } else {
            Cache.removeProperty(RSBS_SERVICES);
        }
    }
}

