/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.JABAService;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.MsaWSClient;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.io.Closeable;
import javax.swing.JMenu;

public class Jws2Instance
implements AutoCloseable {
    public String hosturl;
    public String serviceType;
    public String action;
    public JABAService service;
    public String description;
    public String docUrl;
    PresetManager presets = null;
    public JabaParamStore paramStore = null;
    private boolean hasParams = false;
    private boolean lookedForParams = false;
    AlignAnalysisUIText aaui;

    public Jws2Instance(String hosturl, String serviceType, String action, String description, JABAService service) {
        this.hosturl = hosturl;
        this.serviceType = serviceType;
        this.service = service;
        this.action = action;
        this.description = description;
        int p = description.indexOf("MORE INFORMATION:");
        if (p > -1) {
            this.docUrl = description.substring(description.indexOf("http", p)).trim();
            if (this.docUrl.indexOf(10) > -1) {
                this.docUrl = this.docUrl.substring(0, this.docUrl.indexOf("\n")).trim();
            }
        }
    }

    public PresetManager getPresets() {
        if (this.presets == null) {
            try {
                if (this.service instanceof MsaWS) {
                    this.presets = ((MsaWS)this.service).getPresets();
                }
                if (this.service instanceof SequenceAnnotation) {
                    this.presets = ((SequenceAnnotation)this.service).getPresets();
                }
            }
            catch (Exception ex) {
                System.err.println("Exception when retrieving presets for service " + this.serviceType + " at " + this.hosturl);
            }
        }
        return this.presets;
    }

    public String getHost() {
        return this.hosturl;
    }

    public String getActionText() {
        return this.action + " with " + this.serviceType;
    }

    public RunnerConfig getRunnerConfig() {
        if (this.service instanceof MsaWS) {
            return ((MsaWS)this.service).getRunnerOptions();
        }
        if (this.service instanceof SequenceAnnotation) {
            return ((SequenceAnnotation)this.service).getRunnerOptions();
        }
        throw new Error(MessageManager.formatMessage("error.implementation_error_runner_config_not_available", new String[]{this.serviceType, this.service.getClass().toString()}));
    }

    @Override
    public void close() {
        if (this.service != null) {
            try {
                ((Closeable)this.service).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ParamDatastoreI getParamStore() {
        if (this.paramStore == null) {
            try {
                this.paramStore = new JabaParamStore(this, Desktop.instance != null ? Desktop.getUserParameterStore() : null);
            }
            catch (Exception ex) {
                System.err.println("Unexpected exception creating JabaParamStore.");
                ex.printStackTrace();
            }
        }
        return this.paramStore;
    }

    public String getUri() {
        return this.hosturl + (this.hosturl.lastIndexOf("/") == this.hosturl.length() - 1 ? "" : "/") + this.serviceType;
    }

    public boolean hasParameters() {
        if (!this.lookedForParams) {
            this.lookedForParams = true;
            try {
                this.hasParams = this.getRunnerConfig().getArguments().size() > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.hasParams;
    }

    public void attachWSMenuEntry(JMenu atpoint, AlignFrame alignFrame) {
        if (this.service instanceof MsaWS) {
            new MsaWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
        } else if (this.service instanceof SequenceAnnotation) {
            new SequenceAnnotationWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
        }
    }

    public String getServiceTypeURI() {
        return "java:" + this.serviceType;
    }

    public AlignAnalysisUIText getAlignAnalysisUI() {
        return this.aaui;
    }
}

