/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.MuscleWS;
import ext.vamsas.MuscleWSServiceLocator;
import ext.vamsas.MuscleWSSoapBindingStub;
import ext.vamsas.ServiceHandle;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.util.MessageManager;
import jalview.ws.jws1.MsaWSThread;
import jalview.ws.jws1.WS1Client;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MsaWSClient
extends WS1Client {
    MuscleWS server;
    AlignFrame alignFrame;

    public MsaWSClient(ServiceHandle sh, String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset, AlignFrame _alignFrame) {
        this.alignFrame = _alignFrame;
        if (!sh.getAbstractName().equals("MsaWS")) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.service_called_is_not_msa_service", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.wsInfo = this.setWebService(sh);
        if (this.wsInfo == null) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.msa_service_is_unknown", new String[]{sh.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
            return;
        }
        this.startMsaWSClient(altitle, msa, submitGaps, preserveOrder, seqdataset);
    }

    public MsaWSClient() {
    }

    private void startMsaWSClient(String altitle, AlignmentView msa, boolean submitGaps, boolean preserveOrder, AlignmentI seqdataset) {
        if (!this.locateWebService()) {
            return;
        }
        this.wsInfo.setProgressText((submitGaps ? "Re-alignment" : "Alignment") + " of " + altitle + "\nJob details\n");
        Object jobtitle = this.WebServiceName.toLowerCase();
        if (((String)jobtitle).endsWith("alignment")) {
            if (submitGaps && (!((String)jobtitle).endsWith("realignment") || ((String)jobtitle).indexOf("profile") == -1)) {
                int pos = ((String)jobtitle).indexOf("alignment");
                jobtitle = this.WebServiceName.substring(0, pos) + "re-alignment of " + altitle;
            } else {
                jobtitle = this.WebServiceName + " of " + altitle;
            }
        } else {
            jobtitle = this.WebServiceName + (submitGaps ? " re" : " ") + "alignment of " + altitle;
        }
        MsaWSThread msathread = new MsaWSThread(this.server, this.WsURL, this.wsInfo, this.alignFrame, this.WebServiceName, (String)jobtitle, msa, submitGaps, preserveOrder, seqdataset);
        this.wsInfo.setthisService(msathread);
        msathread.start();
    }

    private boolean locateWebService() {
        MuscleWSServiceLocator loc = new MuscleWSServiceLocator();
        try {
            this.server = loc.getMuscleWS(new URL(this.WsURL));
            ((MuscleWSSoapBindingStub)this.server).setTimeout(60000);
        }
        catch (Exception ex) {
            this.wsInfo.setProgressText("Serious! " + this.WebServiceName + " Service location failed\nfor URL :" + this.WsURL + "\n" + ex.getMessage());
            this.wsInfo.setStatus(64);
            ex.printStackTrace();
            return false;
        }
        loc.getEngine().setOption("axis", (Object)"1");
        return true;
    }

    protected String getServiceActionKey() {
        return "MsaWS";
    }

    protected String getServiceActionDescription() {
        return "Multiple Sequence Alignment";
    }

    private boolean canSubmitGaps() {
        return this.WebServiceName.indexOf("lustal") > -1;
    }

    @Override
    public void attachWSMenuEntry(JMenu msawsmenu, final ServiceHandle serviceHandle, final AlignFrame alignFrame) {
        this.setWebService(serviceHandle, true);
        JMenuItem method = new JMenuItem(this.WebServiceName);
        method.setToolTipText(this.WsURL);
        method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                new MsaWSClient(serviceHandle, alignFrame.getTitle(), msa, false, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
            }
        });
        msawsmenu.add(method);
        if (this.canSubmitGaps()) {
            JMenuItem methodR = new JMenuItem(serviceHandle.getName() + " Realign");
            methodR.setToolTipText(this.WsURL);
            methodR.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignmentView msa = alignFrame.gatherSequencesForAlignment();
                    new MsaWSClient(serviceHandle, alignFrame.getTitle(), msa, true, true, alignFrame.getViewport().getAlignment().getDataset(), alignFrame);
                }
            });
            msawsmenu.add(methodR);
        }
    }
}

