/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.OOMWarning;
import jalview.gui.WebserviceInfo;
import jalview.util.MessageManager;
import jalview.viewmodel.seqfeatures.FeatureRendererSettings;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import java.util.ArrayList;
import java.util.List;

public abstract class AWSThread
extends Thread {
    protected AlignmentI currentView = null;
    protected FeatureRendererSettings featureSettings = null;
    protected WebserviceInfo wsInfo = null;
    protected AlignmentView input = null;
    protected List<AlignedCodonFrame> codonframe = null;
    protected boolean jobComplete = false;
    protected AWsJob[] jobs = null;
    protected String WebServiceName = null;
    protected char defGapChar = (char)45;
    protected String OutputHeader;
    protected String WsUrl = null;
    private AlignFrame alignFrame;

    @Override
    public void run() {
        JobStateSummary jstate = null;
        if (this.jobs == null) {
            this.jobComplete = true;
        }
        while (!this.jobComplete) {
            jstate = new JobStateSummary();
            for (int j = 0; j < this.jobs.length; ++j) {
                if (!this.jobs[j].submitted && this.jobs[j].hasValidInput()) {
                    this.StartJob(this.jobs[j]);
                }
                if (this.jobs[j].submitted && !this.jobs[j].subjobComplete) {
                    try {
                        this.pollJob(this.jobs[j]);
                        if (!this.jobs[j].hasResponse()) {
                            throw new Exception("Timed out when communicating with server\nTry again later.\n");
                        }
                        Cache.log.debug((Object)("Job " + j + " Result state " + this.jobs[j].getState() + "(ServerError=" + this.jobs[j].isServerError() + ")"));
                    }
                    catch (Exception ex) {
                        this.wsInfo.appendProgressText(this.jobs[j].jobnum, MessageManager.formatMessage("info.server_exception", this.WebServiceName, ex.getMessage()));
                        Cache.log.warn((Object)(this.WebServiceName + " job(" + this.jobs[j].jobnum + ") Server exception."));
                        ex.printStackTrace();
                        if (this.jobs[j].allowedServerExceptions > 0) {
                            --this.jobs[j].allowedServerExceptions;
                            Cache.log.debug((Object)"Sleeping after a server exception.");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            Cache.log.warn((Object)("Dropping job " + j + " " + this.jobs[j].jobId));
                            this.jobs[j].subjobComplete = true;
                            this.wsInfo.setStatus(this.jobs[j].jobnum, 5);
                        }
                    }
                    catch (OutOfMemoryError er) {
                        this.jobComplete = true;
                        this.jobs[j].subjobComplete = true;
                        this.jobs[j].clearResponse();
                        this.wsInfo.setStatus(this.jobs[j].jobnum, 4);
                        Cache.log.error((Object)("Out of memory when retrieving Job " + j + " id:" + this.WsUrl + "/" + this.jobs[j].jobId), (Throwable)er);
                        new OOMWarning("retrieving result for " + this.WebServiceName, er);
                        System.gc();
                    }
                }
                jstate.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
            }
            this.updateGlobalStatus(jstate);
            if (this.jobComplete) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Cache.log.debug((Object)"Interrupted sleep waiting for next job poll.", (Throwable)e);
            }
        }
        if (this.jobComplete && this.jobs != null) {
            this.parseResult();
        } else {
            Cache.log.debug((Object)"WebServiceJob poll loop finished with no jobs created.");
            this.wsInfo.setStatus(4);
            this.wsInfo.appendProgressText(MessageManager.getString("info.no_jobs_ran"));
            this.wsInfo.setFinishedNoResults();
        }
    }

    protected void updateGlobalStatus(JobStateSummary jstate) {
        if (jstate.running > 0) {
            this.wsInfo.setStatus(1);
        } else if (jstate.queuing > 0) {
            this.wsInfo.setStatus(0);
        } else {
            this.jobComplete = true;
            if (jstate.finished > 0) {
                this.wsInfo.setStatus(2);
            } else if (jstate.error > 0) {
                this.wsInfo.setStatus(4);
            } else if (jstate.serror > 0) {
                this.wsInfo.setStatus(5);
            }
        }
    }

    public AWSThread() {
    }

    public AWSThread(Runnable target) {
        super(target);
    }

    public AWSThread(String name) {
        super(name);
    }

    public AWSThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public AWSThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public AWSThread(Runnable target, String name) {
        super(target, name);
    }

    public AWSThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public abstract void pollJob(AWsJob var1) throws Exception;

    public abstract void StartJob(AWsJob var1);

    public abstract void parseResult();

    public void propagateDatasetMappings(Alignment al) {
        if (this.codonframe != null) {
            SequenceI[] alignment = al.getSequencesArray();
            block0: for (int sq = 0; sq < alignment.length; ++sq) {
                for (AlignedCodonFrame acf : this.codonframe) {
                    SequenceI seq = alignment[sq];
                    if (acf == null || !acf.involvesSequence(seq)) continue;
                    al.addCodonFrame(acf);
                    continue block0;
                }
            }
        }
    }

    public AWSThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    public char getGapChar() {
        return this.defGapChar;
    }

    public AWSThread(AlignFrame alignFrame, WebserviceInfo wsinfo, AlignmentView input, String webServiceName, String wsUrl) {
        this(alignFrame, wsinfo, input, wsUrl);
        this.WebServiceName = webServiceName;
    }

    public AWSThread(AlignFrame alframe, WebserviceInfo wsinfo2, AlignmentView alview, String wsurl2) {
        List<AlignedCodonFrame> cf;
        this.alignFrame = alframe;
        this.currentView = alframe.getCurrentView().getAlignment();
        this.featureSettings = alframe.getFeatureRenderer().getSettings();
        this.defGapChar = alframe.getViewport().getGapCharacter();
        this.wsInfo = wsinfo2;
        this.input = alview;
        this.WsUrl = wsurl2;
        if (alframe != null && (cf = alframe.getViewport().getAlignment().getCodonFrames()) != null) {
            this.codonframe = new ArrayList<AlignedCodonFrame>();
            this.codonframe.addAll(cf);
        }
    }

    protected AlignFrame getRequestingAlignFrame() {
        return this.alignFrame;
    }
}

