/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.workers.AlignCalcWorker;

public class ConsensusThread
extends AlignCalcWorker {
    public ConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.calcMan.isPending(this)) {
            return;
        }
        this.calcMan.notifyStart(this);
        try {
            AlignmentAnnotation consensus = this.getConsensusAnnotation();
            AlignmentAnnotation gap = this.getGapAnnotation();
            if (consensus == null && gap == null || this.calcMan.isPending(this)) {
                this.calcMan.workerComplete(this);
                return;
            }
            while (!this.calcMan.notifyWorking(this)) {
                try {
                    if (this.ap != null) {
                        this.ap.paintAlignment(false, false);
                    }
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.alignViewport.isClosed()) {
                this.abortAndDestroy();
                return;
            }
            AlignmentI alignment = this.alignViewport.getAlignment();
            int aWidth = -1;
            if (alignment == null || (aWidth = alignment.getWidth()) < 0) {
                this.calcMan.workerComplete(this);
                return;
            }
            this.eraseConsensus(aWidth);
            this.computeConsensus(alignment);
            this.updateResultAnnotation(true);
            if (this.ap != null) {
                this.ap.paintAlignment(true, true);
            }
        }
        catch (OutOfMemoryError error) {
            this.calcMan.disableWorker(this);
            this.ap.raiseOOMWarning("calculating consensus", error);
        }
        finally {
            this.calcMan.workerComplete(this);
        }
    }

    protected void eraseConsensus(int aWidth) {
        AlignmentAnnotation gap;
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        if (consensus != null) {
            consensus.annotations = new Annotation[aWidth];
        }
        if ((gap = this.getGapAnnotation()) != null) {
            gap.annotations = new Annotation[aWidth];
        }
    }

    protected void computeConsensus(AlignmentI alignment) {
        SequenceI[] aseqs = this.getSequences();
        int width = alignment.getWidth();
        ProfilesI hconsensus = AAFrequency.calculate(aseqs, width, 0, width, true);
        this.alignViewport.setSequenceConsensusHash(hconsensus);
        this.setColourSchemeConsensus(hconsensus);
    }

    protected SequenceI[] getSequences() {
        return this.alignViewport.getAlignment().getSequencesArray();
    }

    protected void setColourSchemeConsensus(ProfilesI hconsensus) {
        ResidueShaderI cs = this.alignViewport.getResidueShading();
        if (cs != null) {
            cs.setConsensus(hconsensus);
        }
    }

    protected AlignmentAnnotation getConsensusAnnotation() {
        return this.alignViewport.getAlignmentConsensusAnnotation();
    }

    protected AlignmentAnnotation getGapAnnotation() {
        return this.alignViewport.getAlignmentGapAnnotation();
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        ProfilesI hconsensus = (ProfilesI)this.getViewportConsensus();
        if (immediate || !this.calcMan.isWorking(this) && consensus != null && hconsensus != null) {
            this.deriveConsensus(consensus, hconsensus);
            AlignmentAnnotation gap = this.getGapAnnotation();
            if (gap != null) {
                this.deriveGap(gap, hconsensus);
            }
        }
    }

    protected void deriveConsensus(AlignmentAnnotation consensusAnnotation, ProfilesI hconsensus) {
        long nseq = this.getSequences().length;
        AAFrequency.completeConsensus(consensusAnnotation, hconsensus, hconsensus.getStartColumn(), hconsensus.getEndColumn() + 1, this.alignViewport.isIgnoreGapsConsensus(), this.alignViewport.isShowSequenceLogo(), nseq);
    }

    protected void deriveGap(AlignmentAnnotation gapAnnotation, ProfilesI hconsensus) {
        long nseq = this.getSequences().length;
        AAFrequency.completeGapAnnot(gapAnnotation, hconsensus, hconsensus.getStartColumn(), hconsensus.getEndColumn() + 1, nseq);
    }

    protected Object getViewportConsensus() {
        return this.alignViewport.getSequenceConsensusHash();
    }
}

