/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Jalview;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.workers.AnnotationProviderI;
import jalview.workers.AnnotationWorker;
import jalview.workers.ColumnCounterSetWorker;
import jalview.workers.FeatureSetCounterI;
import java.awt.Color;

public class AlignmentAnnotationFactory {
    public static void newCalculator(FeatureSetCounterI counter) {
        AlignmentPanel currentAlignFrame = Jalview.getCurrentAlignFrame().alignPanel;
        if (currentAlignFrame == null) {
            System.err.println("Can't register calculator as no alignment window has focus");
            return;
        }
        new ColumnCounterSetWorker(currentAlignFrame.getAlignViewport(), currentAlignFrame, counter);
    }

    public static void newCalculator(AnnotationProviderI calculator) {
        AlignFrame currentAlignFrame = Jalview.getCurrentAlignFrame();
        if (currentAlignFrame != null) {
            new AnnotationWorker(currentAlignFrame.getViewport(), currentAlignFrame.getAlignPanels().get(0), calculator);
        } else {
            System.err.println("Can't register calculator as no alignment window has focus");
        }
    }

    public static void newCalculator(AlignViewportI viewport, AlignmentViewPanel panel, AnnotationProviderI calculator) {
        new AnnotationWorker(viewport, panel, calculator);
    }

    public static Annotation newAnnotation(String displayChar, String desc, char secondaryStructure, float val, Color color) {
        return new Annotation(displayChar, desc, secondaryStructure, val, color);
    }

    public static AlignmentAnnotation newAlignmentAnnotation(String name, String desc, Annotation[] anns) {
        return new AlignmentAnnotation(name, desc, anns);
    }
}

