/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignCalcManagerI;
import jalview.api.AlignCalcWorkerI;
import jalview.datamodel.AlignmentAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class AlignCalcManager
implements AlignCalcManagerI {
    private volatile List<AlignCalcWorkerI> restartable = Collections.synchronizedList(new ArrayList());
    private volatile List<Class<? extends AlignCalcWorkerI>> blackList = Collections.synchronizedList(new ArrayList());
    private volatile List<AlignCalcWorkerI> inProgress = Collections.synchronizedList(new ArrayList());
    private volatile Map<Class<? extends AlignCalcWorkerI>, List<AlignCalcWorkerI>> updating = Collections.synchronizedMap(new Hashtable());
    private HashSet<AlignCalcWorkerI> canUpdate = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStart(AlignCalcWorkerI worker) {
        Map<Class<? extends AlignCalcWorkerI>, List<AlignCalcWorkerI>> map = this.updating;
        synchronized (map) {
            List<AlignCalcWorkerI> upd = this.updating.get(worker.getClass());
            if (upd == null) {
                upd = Collections.synchronizedList(new ArrayList());
                this.updating.put(worker.getClass(), upd);
            }
            List<AlignCalcWorkerI> list = upd;
            synchronized (list) {
                upd.add(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPending(AlignCalcWorkerI workingClass) {
        Map<Class<? extends AlignCalcWorkerI>, List<AlignCalcWorkerI>> map = this.updating;
        synchronized (map) {
            List<AlignCalcWorkerI> upd = this.updating.get(workingClass.getClass());
            if (upd == null) {
                return false;
            }
            List<AlignCalcWorkerI> list = upd;
            synchronized (list) {
                if (upd.size() > 1) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyWorking(AlignCalcWorkerI worker) {
        List<AlignCalcWorkerI> list = this.inProgress;
        synchronized (list) {
            if (this.inProgress.contains(worker)) {
                return false;
            }
            this.inProgress.add(worker);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workerComplete(AlignCalcWorkerI worker) {
        List<AlignCalcWorkerI> list = this.inProgress;
        synchronized (list) {
            this.inProgress.remove(worker);
            List<AlignCalcWorkerI> upd = this.updating.get(worker.getClass());
            if (upd != null) {
                List<AlignCalcWorkerI> list2 = upd;
                synchronized (list2) {
                    upd.remove(worker);
                }
                this.canUpdate.add(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableWorker(AlignCalcWorkerI worker) {
        List<Class<? extends AlignCalcWorkerI>> list = this.blackList;
        synchronized (list) {
            this.blackList.add(worker.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisabled(AlignCalcWorkerI worker) {
        List<Class<? extends AlignCalcWorkerI>> list = this.blackList;
        synchronized (list) {
            return this.blackList.contains(worker.getClass());
        }
    }

    @Override
    public void startWorker(AlignCalcWorkerI worker) {
        if (!this.isDisabled(worker)) {
            Thread tw = new Thread(worker);
            tw.setName(worker.getClass().toString());
            tw.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWorking(AlignCalcWorkerI worker) {
        List<AlignCalcWorkerI> list = this.inProgress;
        synchronized (list) {
            return worker != null && this.inProgress.contains(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWorking() {
        List<AlignCalcWorkerI> list = this.inProgress;
        synchronized (list) {
            return this.inProgress.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWorker(AlignCalcWorkerI worker) {
        List<AlignCalcWorkerI> list = this.restartable;
        synchronized (list) {
            if (!this.restartable.contains(worker)) {
                this.restartable.add(worker);
            }
            this.startWorker(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWorkers() {
        List<AlignCalcWorkerI> list = this.restartable;
        synchronized (list) {
            for (AlignCalcWorkerI worker : this.restartable) {
                this.startWorker(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean workingInvolvedWith(AlignmentAnnotation alignmentAnnotation) {
        Object object = this.inProgress;
        synchronized (object) {
            for (AlignCalcWorkerI alignCalcWorkerI : this.inProgress) {
                if (!alignCalcWorkerI.involves(alignmentAnnotation)) continue;
                return true;
            }
        }
        object = this.updating;
        synchronized (object) {
            for (List list : this.updating.values()) {
                for (AlignCalcWorkerI worker : list) {
                    if (!worker.involves(alignmentAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAnnotationFor(Class<? extends AlignCalcWorkerI> workerClass) {
        AlignCalcWorkerI[] alignCalcWorkerIArray = this.canUpdate;
        synchronized (this.canUpdate) {
            AlignCalcWorkerI[] workers = this.canUpdate.toArray(new AlignCalcWorkerI[0]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (AlignCalcWorkerI worker : workers) {
                if (!workerClass.equals(worker.getClass())) continue;
                worker.updateAnnotation();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlignCalcWorkerI> getRegisteredWorkersOfClass(Class<? extends AlignCalcWorkerI> workerClass) {
        ArrayList<AlignCalcWorkerI> workingClass = new ArrayList<AlignCalcWorkerI>();
        HashSet<AlignCalcWorkerI> hashSet = this.canUpdate;
        synchronized (hashSet) {
            for (AlignCalcWorkerI worker : this.canUpdate) {
                if (!workerClass.equals(worker.getClass())) continue;
                workingClass.add(worker);
            }
        }
        return workingClass.size() == 0 ? null : workingClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableWorker(AlignCalcWorkerI worker) {
        List<Class<? extends AlignCalcWorkerI>> list = this.blackList;
        synchronized (list) {
            this.blackList.remove(worker.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegisteredWorkersOfClass(Class<? extends AlignCalcWorkerI> typeToRemove) {
        ArrayList<AlignCalcWorkerI> removable = new ArrayList<AlignCalcWorkerI>();
        HashSet<AlignCalcWorkerI> toremovannot = new HashSet<AlignCalcWorkerI>();
        Collection<AlignCalcWorkerI> collection = this.restartable;
        synchronized (collection) {
            for (AlignCalcWorkerI worker : this.restartable) {
                if (!typeToRemove.equals(worker.getClass())) continue;
                removable.add(worker);
                toremovannot.add(worker);
            }
            this.restartable.removeAll(removable);
        }
        collection = this.canUpdate;
        synchronized (collection) {
            for (AlignCalcWorkerI worker : this.canUpdate) {
                if (!typeToRemove.equals(worker.getClass())) continue;
                removable.add(worker);
                toremovannot.add(worker);
            }
            this.canUpdate.removeAll(removable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkerForAnnotation(AlignmentAnnotation ann) {
        ArrayList<AlignCalcWorkerI> toRemove = new ArrayList<AlignCalcWorkerI>();
        for (AlignCalcWorkerI worker : this.restartable) {
            if (!worker.involves(ann) || !worker.isDeletable()) continue;
            toRemove.add(worker);
        }
        for (AlignCalcWorkerI worker : toRemove) {
            this.restartable.remove(worker);
            this.blackList.remove(worker.getClass());
            this.inProgress.remove(worker);
            this.canUpdate.remove(worker);
            Map<Class<? extends AlignCalcWorkerI>, List<AlignCalcWorkerI>> map = this.updating;
            synchronized (map) {
                List<AlignCalcWorkerI> upd = this.updating.get(worker.getClass());
                if (upd != null) {
                    upd.remove(worker);
                }
            }
        }
    }
}

