/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.analysis.PCA;
import jalview.api.RotatableCanvasI;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import java.util.List;
import java.util.Vector;

public class PCAModel {
    private AlignmentView inputData;
    private final SequenceI[] seqs;
    private final SimilarityParamsI similarityParams;
    private ScoreModelI scoreModel;
    private boolean nucleotide = false;
    private PCA pca;
    int top;
    private List<SequencePoint> points;

    public PCAModel(AlignmentView seqData, SequenceI[] sqs, boolean nuc, ScoreModelI modelName, SimilarityParamsI params) {
        this.inputData = seqData;
        this.seqs = sqs;
        this.nucleotide = nuc;
        this.scoreModel = modelName;
        this.similarityParams = params;
    }

    public void calculate() {
        this.pca = new PCA(this.inputData, this.scoreModel, this.similarityParams);
        this.pca.run();
        for (int ii = 0; ii < this.seqs.length && this.seqs[ii] != null; ++ii) {
        }
        int height = this.pca.getHeight();
        this.top = height - 1;
        this.points = new Vector<SequencePoint>();
        Point[] scores = this.pca.getComponents(this.top - 1, this.top - 2, this.top - 3, 100.0f);
        for (int i = 0; i < height; ++i) {
            SequencePoint sp = new SequencePoint(this.seqs[i], scores[i]);
            this.points.add(sp);
        }
    }

    public void updateRc(RotatableCanvasI rc) {
        rc.setPoints(this.points, this.pca.getHeight());
    }

    public boolean isNucleotide() {
        return this.nucleotide;
    }

    public void setNucleotide(boolean nucleotide) {
        this.nucleotide = nucleotide;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int t) {
        this.top = t;
    }

    public void updateRcView(int dim1, int dim2, int dim3) {
        Point[] scores = this.pca.getComponents(dim1 - 1, dim2 - 1, dim3 - 1, 100.0f);
        for (int i = 0; i < this.pca.getHeight(); ++i) {
            this.points.get((int)i).coord = scores[i];
        }
    }

    public String getDetails() {
        return this.pca.getDetails();
    }

    public AlignmentView getInputData() {
        return this.inputData;
    }

    public void setInputData(AlignmentView data) {
        this.inputData = data;
    }

    public String getPointsasCsv(boolean transformed, int xdim, int ydim, int zdim) {
        StringBuffer csv = new StringBuffer();
        csv.append("\"Sequence\"");
        if (transformed) {
            csv.append(",");
            csv.append(xdim);
            csv.append(",");
            csv.append(ydim);
            csv.append(",");
            csv.append(zdim);
        } else {
            int dmax = this.pca.component(1).length;
            for (int d = 1; d <= dmax; ++d) {
                csv.append("," + d);
            }
        }
        csv.append("\n");
        for (int s = 0; s < this.seqs.length; ++s) {
            csv.append("\"" + this.seqs[s].getName() + "\"");
            if (!transformed) {
                double[] fl = this.pca.component(s);
                for (int d = fl.length - 1; d >= 0; --d) {
                    csv.append(",");
                    csv.append(fl[d]);
                }
            } else {
                Point p = this.points.get((int)s).coord;
                csv.append(",").append(p.x);
                csv.append(",").append(p.y);
                csv.append(",").append(p.z);
            }
            csv.append("\n");
        }
        return csv.toString();
    }

    public String getScoreModelName() {
        return this.scoreModel == null ? "" : this.scoreModel.getName();
    }

    public void setScoreModel(ScoreModelI sm) {
        this.scoreModel = sm;
    }

    public SimilarityParamsI getSimilarityParameters() {
        return this.similarityParams;
    }

    public List<SequencePoint> getSequencePoints() {
        return this.points;
    }

    public void setSequencePoints(List<SequencePoint> sp) {
        this.points = sp;
    }

    public PCA getPcaData() {
        return this.pca;
    }

    public void setPCA(PCA data) {
        this.pca = data;
    }
}

