/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ParseHtmlBodyAndLinks {
    private static final Pattern LEFT_ANGLE_BRACKET_PATTERN = Pattern.compile("<");
    String orig = null;
    boolean htmlContent = true;
    List<String> links = new ArrayList<String>();
    String content;

    public String getOrig() {
        return this.orig;
    }

    public boolean isHtmlContent() {
        return this.htmlContent;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getLinks() {
        return this.links;
    }

    public ParseHtmlBodyAndLinks(String description, boolean removeHTML, String newline) {
        if (description == null || description.length() == 0) {
            this.htmlContent = false;
            return;
        }
        StringBuilder sb = new StringBuilder(description.length());
        if (description.toUpperCase().indexOf("<HTML>") == -1) {
            this.htmlContent = false;
        }
        this.orig = description;
        StringTokenizer st = new StringTokenizer(description, "<");
        String tag = null;
        while (st.hasMoreElements()) {
            String token = st.nextToken(">");
            if (token.equalsIgnoreCase("html") || token.startsWith("/")) continue;
            tag = null;
            int startTag = token.indexOf("<");
            if (startTag > -1) {
                tag = token.substring(startTag + 1);
                token = token.substring(0, startTag);
            }
            if (tag != null && tag.toUpperCase().startsWith("A HREF=")) {
                if (token.length() > 0) {
                    sb.append(token);
                }
                String link = tag.substring(tag.indexOf("\"") + 1, tag.length() - 1);
                String label = st.nextToken("<>");
                this.links.add(label + "|" + link);
                sb.append(label + "%LINK%");
                continue;
            }
            if (tag != null && tag.equalsIgnoreCase("br")) {
                sb.append(newline);
                continue;
            }
            sb.append(token);
        }
        if (removeHTML && !this.htmlContent) {
            sb = new StringBuilder(LEFT_ANGLE_BRACKET_PATTERN.matcher(description).replaceAll("&lt;"));
        }
        this.content = this.translateEntities(sb.toString());
    }

    private String translateEntities(String s) {
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        return s;
    }

    public String getNonHtmlContent() {
        return this.isHtmlContent() ? this.content : this.orig;
    }
}

