/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.analysis.AlignmentSorter;
import jalview.api.AlignViewportI;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.ReverseListIterator;
import jalview.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MappingUtils {
    protected static void mapCutOrPaste(EditCommand.Edit edit, boolean undo, List<SequenceI> targetSeqs, EditCommand result, List<AlignedCodonFrame> mappings) {
        EditCommand.Action action = edit.getAction();
        if (undo) {
            action = action.getUndoAction();
        }
        System.err.println("MappingUtils.mapCutOrPaste not yet implemented");
    }

    public static EditCommand mapEditCommand(EditCommand command, boolean undo, AlignmentI mapTo, char gapChar, List<AlignedCodonFrame> mappings) {
        if (!mapTo.isNucleotide()) {
            return null;
        }
        HashMap<SequenceI, SequenceI> targetCopies = new HashMap<SequenceI, SequenceI>();
        for (SequenceI seq : mapTo.getSequences()) {
            SequenceI ds = seq.getDatasetSequence();
            if (ds == null) continue;
            Sequence copy = new Sequence(seq);
            copy.setDatasetSequence(ds);
            targetCopies.put(ds, copy);
        }
        Map<SequenceI, SequenceI> originalSequences = command.priorState(undo);
        EditCommand result = new EditCommand();
        Iterator<EditCommand.Edit> edits = command.getEditIterator(!undo);
        while (edits.hasNext()) {
            EditCommand.Edit edit = edits.next();
            if (edit.getAction() == EditCommand.Action.CUT || edit.getAction() == EditCommand.Action.PASTE) {
                MappingUtils.mapCutOrPaste(edit, undo, mapTo.getSequences(), result, mappings);
                continue;
            }
            if (edit.getAction() != EditCommand.Action.INSERT_GAP && edit.getAction() != EditCommand.Action.DELETE_GAP) continue;
            MappingUtils.mapInsertOrDelete(edit, undo, originalSequences, mapTo.getSequences(), targetCopies, gapChar, result, mappings);
        }
        return result.getSize() > 0 ? result : null;
    }

    protected static void mapInsertOrDelete(EditCommand.Edit edit, boolean undo, Map<SequenceI, SequenceI> originalSequences, List<SequenceI> targetSeqs, Map<SequenceI, SequenceI> targetCopies, char gapChar, EditCommand result, List<AlignedCodonFrame> mappings) {
        EditCommand.Action action = edit.getAction();
        if (undo) {
            action = action.getUndoAction();
        }
        int count = edit.getNumber();
        int editPos = edit.getPosition();
        for (SequenceI seq : edit.getSequences()) {
            SequenceI ds = seq.getDatasetSequence();
            if (ds == null) continue;
            SequenceI actedOn = originalSequences.get(ds);
            int seqpos = actedOn.findPosition(editPos);
            SearchResultsI sr = MappingUtils.buildSearchResults(seq, seqpos, mappings);
            if (!sr.isEmpty()) {
                for (SequenceI targetSeq : targetSeqs) {
                    SequenceI copyTarget;
                    int[] match;
                    ds = targetSeq.getDatasetSequence();
                    if (ds == null || (match = sr.getResults(copyTarget = targetCopies.get(ds), 0, copyTarget.getLength())) == null) continue;
                    int ratio = 3;
                    int mappedCount = count * 3;
                    int mappedEditPos = action == EditCommand.Action.DELETE_GAP ? match[0] - mappedCount : match[0];
                    EditCommand editCommand = result;
                    Objects.requireNonNull(editCommand);
                    EditCommand.Edit e = new EditCommand.Edit(editCommand, action, new SequenceI[]{targetSeq}, mappedEditPos, mappedCount, gapChar);
                    result.addEdit(e);
                    if (action == EditCommand.Action.INSERT_GAP) {
                        copyTarget.setSequence(new String(StringUtils.insertCharAt(copyTarget.getSequence(), mappedEditPos, mappedCount, gapChar)));
                        continue;
                    }
                    if (action != EditCommand.Action.DELETE_GAP) continue;
                    copyTarget.setSequence(new String(StringUtils.deleteChars(copyTarget.getSequence(), mappedEditPos, mappedEditPos + mappedCount)));
                }
            }
            if (action == EditCommand.Action.INSERT_GAP) {
                actedOn.setSequence(new String(StringUtils.insertCharAt(actedOn.getSequence(), editPos, count, gapChar)));
                continue;
            }
            if (action != EditCommand.Action.DELETE_GAP) continue;
            actedOn.setSequence(new String(StringUtils.deleteChars(actedOn.getSequence(), editPos, editPos + count)));
        }
    }

    public static SearchResultsI buildSearchResults(SequenceI seq, int index, List<AlignedCodonFrame> seqmappings) {
        SearchResults results = new SearchResults();
        MappingUtils.addSearchResults(results, seq, index, seqmappings);
        return results;
    }

    public static void addSearchResults(SearchResultsI results, SequenceI seq, int index, List<AlignedCodonFrame> seqmappings) {
        if (index >= seq.getStart() && index <= seq.getEnd()) {
            for (AlignedCodonFrame acf : seqmappings) {
                acf.markMappedRegion(seq, index, results);
            }
        }
    }

    public static SequenceGroup mapSequenceGroup(SequenceGroup sg, AlignViewportI mapFrom, AlignViewportI mapTo) {
        boolean targetIsNucleotide = mapTo.isNucleotide();
        AlignViewportI protein = targetIsNucleotide ? mapFrom : mapTo;
        List<AlignedCodonFrame> codonFrames = protein.getAlignment().getCodonFrames();
        SequenceGroup mappedGroup = new SequenceGroup(sg);
        mappedGroup.setColourScheme(mapTo.getGlobalColourScheme());
        mappedGroup.clear();
        int minStartCol = -1;
        int maxEndCol = -1;
        int selectionStartRes = sg.getStartRes();
        int selectionEndRes = sg.getEndRes();
        for (SequenceI selected : sg.getSequences()) {
            int lastUngappedPos;
            int firstUngappedPos;
            for (firstUngappedPos = selectionStartRes; firstUngappedPos <= selectionEndRes && Comparison.isGap(selected.getCharAt(firstUngappedPos)); ++firstUngappedPos) {
            }
            if (firstUngappedPos > selectionEndRes) continue;
            for (lastUngappedPos = selectionEndRes; lastUngappedPos >= selectionStartRes && Comparison.isGap(selected.getCharAt(lastUngappedPos)); --lastUngappedPos) {
            }
            int startResiduePos = selected.findPosition(firstUngappedPos);
            int endResiduePos = selected.findPosition(lastUngappedPos);
            block3: for (AlignedCodonFrame acf : codonFrames) {
                SequenceI mappedSequence = targetIsNucleotide ? acf.getDnaForAaSeq(selected) : acf.getAaForDnaSeq(selected);
                if (mappedSequence == null) continue;
                for (SequenceI seq : mapTo.getAlignment().getSequences()) {
                    int mappedStartResidue = 0;
                    int mappedEndResidue = 0;
                    if (seq.getDatasetSequence() != mappedSequence) continue;
                    List<AlignedCodonFrame> mapping = Arrays.asList(acf);
                    SearchResultsI sr = MappingUtils.buildSearchResults(selected, startResiduePos, mapping);
                    for (SearchResultMatchI m : sr.getResults()) {
                        mappedStartResidue = m.getStart();
                        mappedEndResidue = m.getEnd();
                    }
                    sr = MappingUtils.buildSearchResults(selected, endResiduePos, mapping);
                    for (SearchResultMatchI m : sr.getResults()) {
                        mappedStartResidue = Math.min(mappedStartResidue, m.getStart());
                        mappedEndResidue = Math.max(mappedEndResidue, m.getEnd());
                    }
                    int mappedStartCol = seq.findIndex(mappedStartResidue) - 1;
                    minStartCol = minStartCol == -1 ? mappedStartCol : Math.min(minStartCol, mappedStartCol);
                    int mappedEndCol = seq.findIndex(mappedEndResidue) - 1;
                    maxEndCol = maxEndCol == -1 ? mappedEndCol : Math.max(maxEndCol, mappedEndCol);
                    mappedGroup.addSequence(seq, false);
                    continue block3;
                }
            }
        }
        mappedGroup.setStartRes(minStartCol < 0 ? 0 : minStartCol);
        mappedGroup.setEndRes(maxEndCol < 0 ? 0 : maxEndCol);
        return mappedGroup;
    }

    public static CommandI mapOrderCommand(OrderCommand command, boolean undo, AlignmentI mapTo, List<AlignedCodonFrame> mappings) {
        SequenceI[] sortOrder = command.getSequenceOrder(undo);
        ArrayList<SequenceI> mappedOrder = new ArrayList<SequenceI>();
        int j = 0;
        boolean mappingToNucleotide = mapTo.isNucleotide();
        for (SequenceI seq : sortOrder) {
            block1: for (AlignedCodonFrame acf : mappings) {
                SequenceI mappedSeq = mappingToNucleotide ? acf.getDnaForAaSeq(seq) : acf.getAaForDnaSeq(seq);
                if (mappedSeq == null) continue;
                for (SequenceI seq2 : mapTo.getSequences()) {
                    if (seq2.getDatasetSequence() != mappedSeq) continue;
                    mappedOrder.add(seq2);
                    ++j;
                    continue block1;
                }
            }
        }
        if (j == 0) {
            return null;
        }
        if (j < mapTo.getHeight()) {
            for (SequenceI seq : mapTo.getSequences()) {
                if (mappedOrder.contains(seq)) continue;
                mappedOrder.add(seq);
            }
        }
        SequenceI[] mappedOrderArray = mappedOrder.toArray(new SequenceI[mappedOrder.size()]);
        SequenceI[] oldOrder = mapTo.getSequencesArray();
        AlignmentSorter.sortBy(mapTo, new AlignmentOrder(mappedOrderArray));
        OrderCommand result = new OrderCommand(command.getDescription(), oldOrder, mapTo);
        return result;
    }

    public static void mapColumnSelection(ColumnSelection colsel, HiddenColumns hiddencols, AlignViewportI mapFrom, AlignViewportI mapTo, ColumnSelection newColSel, HiddenColumns newHidden) {
        boolean targetIsNucleotide = mapTo.isNucleotide();
        AlignViewportI protein = targetIsNucleotide ? mapFrom : mapTo;
        List<AlignedCodonFrame> codonFrames = protein.getAlignment().getCodonFrames();
        if (colsel == null) {
            return;
        }
        char fromGapChar = mapFrom.getAlignment().getGapCharacter();
        List<SequenceI> fromSequences = mapFrom.getAlignment().getSequences();
        List<SequenceI> toSequences = mapTo.getAlignment().getSequences();
        for (Integer sel : colsel.getSelected()) {
            MappingUtils.mapColumn(sel, codonFrames, newColSel, fromSequences, toSequences, fromGapChar);
        }
        Iterator<int[]> regions = hiddencols.iterator();
        while (regions.hasNext()) {
            MappingUtils.mapHiddenColumns(regions.next(), codonFrames, newHidden, fromSequences, toSequences, fromGapChar);
        }
    }

    protected static void mapHiddenColumns(int[] hidden, List<AlignedCodonFrame> mappings, HiddenColumns mappedColumns, List<SequenceI> fromSequences, List<SequenceI> toSequences, char fromGapChar) {
        for (int col = hidden[0]; col <= hidden[1]; ++col) {
            int[] mappedTo = MappingUtils.findMappedColumns(col, mappings, fromSequences, toSequences, fromGapChar);
            if (mappedTo == null) continue;
            mappedColumns.hideColumns(mappedTo[0] - 1, mappedTo[1] - 1);
        }
    }

    protected static void mapColumn(int col, List<AlignedCodonFrame> mappings, ColumnSelection mappedColumns, List<SequenceI> fromSequences, List<SequenceI> toSequences, char fromGapChar) {
        int[] mappedTo = MappingUtils.findMappedColumns(col, mappings, fromSequences, toSequences, fromGapChar);
        if (mappedTo != null) {
            for (int i = mappedTo[0]; i <= mappedTo[1]; ++i) {
                mappedColumns.addElement(i - 1);
            }
        }
    }

    protected static int[] findMappedColumns(int col, List<AlignedCodonFrame> mappings, List<SequenceI> fromSequences, List<SequenceI> toSequences, char fromGapChar) {
        int[] mappedTo = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        boolean found = false;
        for (SequenceI fromSeq : fromSequences) {
            if (fromSeq.getCharAt(col) == fromGapChar) continue;
            int residuePos = fromSeq.findPosition(col);
            SearchResultsI sr = MappingUtils.buildSearchResults(fromSeq, residuePos, mappings);
            block1: for (SearchResultMatchI m : sr.getResults()) {
                int mappedStartResidue = m.getStart();
                int mappedEndResidue = m.getEnd();
                SequenceI mappedSeq = m.getSequence();
                for (SequenceI toSeq : toSequences) {
                    if (toSeq.getDatasetSequence() != mappedSeq) continue;
                    int mappedStartCol = toSeq.findIndex(mappedStartResidue);
                    int mappedEndCol = toSeq.findIndex(mappedEndResidue);
                    mappedTo[0] = Math.min(mappedTo[0], mappedStartCol);
                    mappedTo[1] = Math.max(mappedTo[1], mappedEndCol);
                    found = true;
                    continue block1;
                }
            }
        }
        return (int[])(found ? mappedTo : null);
    }

    public static List<char[]> findCodonsFor(SequenceI seq, int col, List<AlignedCodonFrame> mappings) {
        ArrayList<char[]> result = new ArrayList<char[]>();
        int dsPos = seq.findPosition(col);
        for (AlignedCodonFrame mapping : mappings) {
            List<char[]> codons;
            if (!mapping.involvesSequence(seq) || (codons = mapping.getMappedCodons(seq.getDatasetSequence(), dsPos)) == null) continue;
            result.addAll(codons);
        }
        return result;
    }

    public static int[] flattenRanges(int[] ranges) {
        int count = 0;
        for (int i = 0; i < ranges.length - 1; i += 2) {
            count += Math.abs(ranges[i + 1] - ranges[i]) + 1;
        }
        int[] result = new int[count];
        int k = 0;
        for (int i = 0; i < ranges.length - 1; i += 2) {
            int from = ranges[i];
            int to = ranges[i + 1];
            int step = from <= to ? 1 : -1;
            do {
                result[k++] = from;
            } while ((from += step) != to + step);
        }
        return result;
    }

    public static List<AlignedCodonFrame> findMappingsForSequence(SequenceI sequence, List<AlignedCodonFrame> mappings) {
        return MappingUtils.findMappingsForSequenceAndOthers(sequence, mappings, null);
    }

    public static List<AlignedCodonFrame> findMappingsForSequenceAndOthers(SequenceI sequence, List<AlignedCodonFrame> mappings, List<SequenceI> filterList) {
        ArrayList<AlignedCodonFrame> result = new ArrayList<AlignedCodonFrame>();
        if (sequence == null || mappings == null) {
            return result;
        }
        block0: for (AlignedCodonFrame mapping : mappings) {
            if (!mapping.involvesSequence(sequence)) continue;
            if (filterList != null) {
                for (SequenceI otherseq : filterList) {
                    SequenceI otherDataset = otherseq.getDatasetSequence();
                    if (otherseq == sequence || otherseq == sequence.getDatasetSequence() || otherDataset != null && (otherDataset == sequence || otherDataset == sequence.getDatasetSequence()) || !mapping.involvesSequence(otherseq)) continue;
                    result.add(mapping);
                    continue block0;
                }
                continue;
            }
            result.add(mapping);
        }
        return result;
    }

    public static int getLength(List<int[]> ranges) {
        if (ranges == null) {
            return 0;
        }
        int length = 0;
        for (int[] range : ranges) {
            if (range.length % 2 != 0) {
                System.err.println("Error unbalance start/end ranges: " + ranges.toString());
                return 0;
            }
            for (int i = 0; i < range.length - 1; i += 2) {
                length += Math.abs(range[i + 1] - range[i]) + 1;
            }
        }
        return length;
    }

    public static boolean contains(List<int[]> ranges, int value) {
        if (ranges == null) {
            return false;
        }
        for (int[] range : ranges) {
            if (range[1] >= range[0] && value >= range[0] && value <= range[1]) {
                return true;
            }
            if (range[1] >= range[0] || value > range[0] || value < range[1]) continue;
            return true;
        }
        return false;
    }

    public static int[] removeStartPositions(int removeCount, int[] ranges) {
        if (removeCount <= 0) {
            return ranges;
        }
        int[] copy = Arrays.copyOf(ranges, ranges.length);
        int sxpos = -1;
        int cdspos = 0;
        for (int x = 0; x < copy.length && sxpos == -1; x += 2) {
            if (removeCount >= (cdspos += Math.abs(copy[x + 1] - copy[x]) + 1)) continue;
            sxpos = x;
            if (copy[x] <= copy[x + 1]) {
                copy[x] = copy[x + 1] - cdspos + removeCount + 1;
                break;
            }
            copy[x] = copy[x + 1] + cdspos - removeCount - 1;
            break;
        }
        if (sxpos > 0) {
            int[] nxon = new int[copy.length - sxpos];
            System.arraycopy(copy, sxpos, nxon, 0, copy.length - sxpos);
            return nxon;
        }
        return copy;
    }

    public static boolean rangeContains(int[] range, int[] queryRange) {
        if (range == null || queryRange == null || range.length != 2 || queryRange.length != 2) {
            return false;
        }
        int min = Math.min(range[0], range[1]);
        int max = Math.max(range[0], range[1]);
        return min <= queryRange[0] && max >= queryRange[0] && min <= queryRange[1] && max >= queryRange[1];
    }

    public static void removeEndPositions(int positions, List<int[]> ranges) {
        int toRemove = positions;
        ReverseListIterator<int[]> it = new ReverseListIterator<int[]>(ranges);
        while (toRemove > 0) {
            int[] endRange = (int[])it.next();
            if (endRange.length != 2) {
                System.err.println("MappingUtils.removeEndPositions doesn't handle multiple  ranges");
                return;
            }
            int length = endRange[1] - endRange[0] + 1;
            if (length <= 0) {
                System.err.println("MappingUtils.removeEndPositions doesn't handle reverse strand");
                return;
            }
            if (length > toRemove) {
                endRange[1] = endRange[1] - toRemove;
                toRemove = 0;
                continue;
            }
            toRemove -= length;
            it.remove();
        }
    }
}

